/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.config.PaxPropertySetter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.OptionHandler;
import org.ops4j.pax.logging.service.internal.AppenderBridgeImpl;
import org.ops4j.pax.logging.service.internal.PaxAppenderProxy;
import org.osgi.framework.BundleContext;

public class PaxLoggingConfigurator
extends PropertyConfigurator {
    public static final String OSGI_APPENDER_PREFIX = "osgi:";
    private static final String LOGGER_REF = "logger-ref";
    private static final String ROOT_REF = "root-ref";
    private static final String APPENDER_REF_TAG = "appender-ref";
    private LoggerRepository repository;
    private BundleContext m_bundleContext;
    private List proxies = new ArrayList();

    public PaxLoggingConfigurator(BundleContext bundleContext) {
        this.m_bundleContext = bundleContext;
    }

    public List getProxies() {
        return this.proxies;
    }

    public void doConfigure(Properties properties, LoggerRepository hierarchy) {
        this.repository = hierarchy;
        super.doConfigure(properties, hierarchy);
    }

    Appender parseAppender(Properties props, String appenderName) {
        Appender appender = this.registryGet(appenderName);
        if (appender != null) {
            LogLog.debug("Appender \"" + appenderName + "\" was already parsed.");
            return appender;
        }
        if (appenderName.startsWith(OSGI_APPENDER_PREFIX)) {
            String osgiAppenderName = appenderName.substring(OSGI_APPENDER_PREFIX.length());
            PaxAppenderProxy paxAppender = new PaxAppenderProxy(this.m_bundleContext, osgiAppenderName);
            this.proxies.add(paxAppender);
            appender = new AppenderBridgeImpl(paxAppender);
            appender.setName(appenderName);
        } else {
            String prefix = "log4j.appender." + appenderName;
            String layoutPrefix = prefix + ".layout";
            appender = (Appender)OptionConverter.instantiateByKey(props, prefix, Appender.class, null);
            if (appender == null) {
                LogLog.error("Could not instantiate appender named \"" + appenderName + "\".");
                return null;
            }
            appender.setName(appenderName);
            if (appender instanceof OptionHandler) {
                ErrorHandler eh;
                String errorHandlerPrefix;
                String errorHandlerClass;
                Layout layout;
                if (appender.requiresLayout() && (layout = (Layout)OptionConverter.instantiateByKey(props, layoutPrefix, Layout.class, null)) != null) {
                    appender.setLayout(layout);
                    LogLog.debug("Parsing layout options for \"" + appenderName + "\".");
                    PaxPropertySetter.setProperties(layout, props, layoutPrefix + ".");
                    LogLog.debug("End of parsing for \"" + appenderName + "\".");
                }
                if ((errorHandlerClass = OptionConverter.findAndSubst(errorHandlerPrefix = prefix + ".errorhandler", props)) != null && (eh = (ErrorHandler)OptionConverter.instantiateByKey(props, errorHandlerPrefix, ErrorHandler.class, null)) != null) {
                    appender.setErrorHandler(eh);
                    LogLog.debug("Parsing errorhandler options for \"" + appenderName + "\".");
                    this.parseErrorHandler(eh, errorHandlerPrefix, props, this.repository);
                    Properties edited = new Properties();
                    String[] keys = new String[]{errorHandlerPrefix + "." + ROOT_REF, errorHandlerPrefix + "." + LOGGER_REF, errorHandlerPrefix + "." + APPENDER_REF_TAG};
                    Iterator<Map.Entry<Object, Object>> iter = props.entrySet().iterator();
                    while (iter.hasNext()) {
                        int i;
                        Map.Entry<Object, Object> entry = iter.next();
                        for (i = 0; i < keys.length && !keys[i].equals(entry.getKey()); ++i) {
                        }
                        if (i != keys.length) continue;
                        edited.put(entry.getKey(), entry.getValue());
                    }
                    PaxPropertySetter.setProperties(eh, edited, errorHandlerPrefix + ".");
                    LogLog.debug("End of errorhandler parsing for \"" + appenderName + "\".");
                }
                if (appender instanceof AppenderAttachable) {
                    String appenderPrefix = prefix + ".appenders";
                    String appenderNames = OptionConverter.findAndSubst(appenderPrefix, props);
                    StringTokenizer st = new StringTokenizer(appenderNames, ",");
                    while (st.hasMoreTokens()) {
                        String childAppenderName = st.nextToken().trim();
                        if (childAppenderName == null || childAppenderName.equals(",")) continue;
                        LogLog.debug("Parsing appender named \"" + childAppenderName + "\".");
                        Appender childAppender = this.parseAppender(props, childAppenderName);
                        if (childAppender == null) continue;
                        ((AppenderAttachable)((Object)appender)).addAppender(childAppender);
                    }
                }
                PaxPropertySetter.setProperties(appender, props, prefix + ".");
                LogLog.debug("Parsed \"" + appenderName + "\" options.");
            }
        }
        this.parseAppenderFilters(props, appenderName, appender);
        this.registryPut(appender);
        return appender;
    }

    private void parseErrorHandler(ErrorHandler eh, String errorHandlerPrefix, Properties props, LoggerRepository hierarchy) {
        Appender backup;
        String appenderName;
        String loggerName;
        boolean rootRef = OptionConverter.toBoolean(OptionConverter.findAndSubst(errorHandlerPrefix + ROOT_REF, props), false);
        if (rootRef) {
            eh.setLogger(hierarchy.getRootLogger());
        }
        if ((loggerName = OptionConverter.findAndSubst(errorHandlerPrefix + LOGGER_REF, props)) != null) {
            Logger logger = this.loggerFactory == null ? hierarchy.getLogger(loggerName) : hierarchy.getLogger(loggerName, this.loggerFactory);
            eh.setLogger(logger);
        }
        if ((appenderName = OptionConverter.findAndSubst(errorHandlerPrefix + APPENDER_REF_TAG, props)) != null && (backup = this.parseAppender(props, appenderName)) != null) {
            eh.setBackupAppender(backup);
        }
    }
}

