/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.karaf.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="activemq", name="create-broker", description="Creates a broker instance.", detailedDescription="classpath:create-broker.txt")
public class CreateBrokerCommand
extends OsgiCommandSupport {
    @Option(name="-n", aliases={"--name"}, description="The name of the broker (defaults to localhost).")
    private String name = "localhost";
    @Option(name="-t", aliases={"--type"}, description="type of configuration to be used: spring or blueprint (defaults to spring)")
    private String type = "spring";

    protected Object doExecute() throws Exception {
        try {
            String name = this.getName();
            File base = new File(System.getProperty("karaf.base"));
            File deploy = new File(base, "deploy");
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("${name}", name);
            this.mkdir(deploy);
            File configFile = new File(deploy, name + "-broker.xml");
            if (!this.type.equalsIgnoreCase("spring") && !this.type.equalsIgnoreCase("blueprint")) {
                System.out.println("@|green Unknown type '" + this.type + "' Using spring by default");
                this.type = "spring";
            }
            this.copyFilteredResourceTo(configFile, this.type.toLowerCase() + ".xml", props);
            System.out.println("");
            System.out.println("Default ActiveMQ Broker (" + name + ") configuration file created at: " + configFile.getPath());
            System.out.println("Please review the configuration and modify to suite your needs.  ");
            System.out.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFilteredResourceTo(File outFile, String resource, HashMap<String, String> props) throws Exception {
        block8: {
            if (!outFile.exists()) {
                System.out.println("Creating file: @|green " + outFile.getPath() + "|");
                InputStream is = CreateBrokerCommand.class.getResourceAsStream(resource);
                try {
                    PrintStream out = new PrintStream(new FileOutputStream(outFile));
                    try {
                        Scanner scanner = new Scanner(is);
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            line = this.filter(line, props);
                            out.println(line);
                        }
                        break block8;
                    }
                    finally {
                        this.safeClose(out);
                    }
                }
                finally {
                    this.safeClose(is);
                }
            }
            System.out.println("@|red File already exists|. Move it out of the way if you want it re-created: " + outFile.getPath() + "");
        }
    }

    private void safeClose(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String filter(String line, HashMap<String, String> props) {
        for (Map.Entry<String, String> i : props.entrySet()) {
            int p1;
            while ((p1 = line.indexOf(i.getKey())) >= 0) {
                String l1 = line.substring(0, p1);
                String l2 = line.substring(p1 + i.getKey().length());
                line = l1 + i.getValue() + l2;
            }
        }
        return line;
    }

    private void mkdir(File file) {
        if (!file.exists()) {
            System.out.println("Creating missing directory: @|green " + file.getPath() + "|");
            file.mkdirs();
        }
    }

    public String getName() {
        if (this.name == null) {
            File base = new File(System.getProperty("karaf.base"));
            this.name = base.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

