/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.bundles.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.management.mbeans.bundles.BundlesMBean;
import org.apache.karaf.management.mbeans.bundles.internal.BundlesSelector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class BundlesMBeanImpl
extends StandardMBean
implements BundlesMBean {
    private BundleContext bundleContext;

    public BundlesMBeanImpl() throws NotCompliantMBeanException {
        super(BundlesMBean.class);
    }

    public TabularData list() throws Exception {
        ServiceReference startLevelReference = this.bundleContext.getServiceReference(StartLevel.class.getName());
        StartLevel startLevel = null;
        if (startLevelReference != null) {
            startLevel = (StartLevel)this.bundleContext.getService(startLevelReference);
        }
        CompositeType bundleType = new CompositeType("Bundle", "OSGi Bundle", new String[]{"ID", "Name", "Version", "Start Level", "State"}, new String[]{"ID of the Bundle", "Name of the Bundle", "Version of the Bundle", "Start Level of the Bundle", "Current State of the Bundle"}, new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING});
        TabularType tableType = new TabularType("Bundles", "Tables of all Bundles", bundleType, new String[]{"ID"});
        TabularDataSupport table = new TabularDataSupport(tableType);
        Bundle[] bundles = this.bundleContext.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            int bundleState;
            int bundleStartLevel = 1;
            if (startLevel != null) {
                bundleStartLevel = startLevel.getBundleStartLevel(bundles[i]);
            }
            String bundleStateString = (bundleState = bundles[i].getState()) == 32 ? "ACTIVE" : (bundleState == 2 ? "INSTALLED" : (bundleState == 4 ? "RESOLVED" : (bundleState == 8 ? "STARTING" : (bundleState == 16 ? "STOPPING" : "UNKNOWN"))));
            CompositeDataSupport data = new CompositeDataSupport(bundleType, new String[]{"ID", "Name", "Version", "Start Level", "State"}, new Object[]{bundles[i].getBundleId(), bundles[i].getSymbolicName(), bundles[i].getVersion().toString(), bundleStartLevel, bundleStateString});
            table.put(data);
        }
        this.bundleContext.ungetService(startLevelReference);
        return table;
    }

    public int getStartLevel(String bundleId) throws Exception {
        ServiceReference startLevelReference = this.bundleContext.getServiceReference(StartLevel.class.getName());
        if (startLevelReference == null) {
            throw new IllegalStateException("StartLevel service is not available");
        }
        StartLevel startLevel = (StartLevel)this.bundleContext.getService(startLevelReference);
        if (startLevel == null) {
            throw new IllegalStateException("StartLevel service is not available");
        }
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        if (bundles.size() != 1) {
            throw new IllegalArgumentException("Provided bundle Id doesn't return any bundle or more than one bundle selected");
        }
        int bundleStartLevel = startLevel.getBundleStartLevel(bundles.get(0));
        this.bundleContext.ungetService(startLevelReference);
        return bundleStartLevel;
    }

    public void setStartLevel(String bundleId, int bundleStartLevel) throws Exception {
        ServiceReference startLevelReference = this.bundleContext.getServiceReference(StartLevel.class.getName());
        if (startLevelReference == null) {
            throw new IllegalStateException("StartLevel service is not available");
        }
        StartLevel startLevel = (StartLevel)this.bundleContext.getService(startLevelReference);
        if (startLevel == null) {
            throw new IllegalStateException("StartLevel service is not available");
        }
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        for (Bundle bundle : bundles) {
            startLevel.setBundleStartLevel(bundle, bundleStartLevel);
        }
        this.bundleContext.ungetService(startLevelReference);
    }

    public void refresh() throws Exception {
        ServiceReference packageAdminReference = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (packageAdminReference == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(packageAdminReference);
        if (packageAdmin == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        packageAdmin.refreshPackages(null);
        this.getBundleContext().ungetService(packageAdminReference);
    }

    public void refresh(String bundleId) throws Exception {
        ServiceReference packageAdminReference = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (packageAdminReference == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(packageAdminReference);
        if (packageAdmin == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        Bundle[] bundlesArray = new Bundle[bundles.size()];
        packageAdmin.refreshPackages(bundles.toArray(bundlesArray));
        this.getBundleContext().ungetService(packageAdminReference);
    }

    public void update(String bundleId) throws Exception {
        this.update(bundleId, null);
    }

    public void update(String bundleId, String location) throws Exception {
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        if (location == null) {
            for (Bundle bundle : bundles) {
                bundle.update();
            }
            return;
        }
        if (bundles.size() != 1) {
            throw new IllegalArgumentException("Provided bundle Id doesn't return any bundle or more than one bundle selected");
        }
        InputStream is = new URL(location).openStream();
        bundles.get(0).update(is);
    }

    public void resolve() throws Exception {
        ServiceReference packageAdminReference = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (packageAdminReference == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(packageAdminReference);
        if (packageAdmin == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        packageAdmin.resolveBundles(null);
        this.getBundleContext().ungetService(packageAdminReference);
    }

    public void resolve(String bundleId) throws Exception {
        ServiceReference packageAdminReference = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (packageAdminReference == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(packageAdminReference);
        if (packageAdmin == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        Bundle[] bundlesArray = new Bundle[bundles.size()];
        packageAdmin.resolveBundles(bundles.toArray(bundlesArray));
        this.getBundleContext().ungetService(packageAdminReference);
    }

    public void restart(String bundleId) throws Exception {
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        for (Bundle bundle : bundles) {
            bundle.stop();
            bundle.start();
        }
    }

    public long install(String url) throws Exception {
        return this.install(url, false);
    }

    public long install(String url, boolean start) throws Exception {
        Bundle bundle = this.bundleContext.installBundle(url, null);
        if (start) {
            bundle.start();
        }
        return bundle.getBundleId();
    }

    public void start(String bundleId) throws Exception {
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        for (Bundle bundle : bundles) {
            bundle.start();
        }
    }

    public void stop(String bundleId) throws Exception {
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        for (Bundle bundle : bundles) {
            bundle.stop();
        }
    }

    public void uninstall(String bundleId) throws Exception {
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        for (Bundle bundle : bundles) {
            bundle.uninstall();
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

