/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.karaf.diagnostic.common.FeaturesDumpProvider;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private Runnable featuresServiceSupport;

    public void start(BundleContext context) throws Exception {
        try {
            this.featuresServiceSupport = new FeaturesServiceSupport(context);
        }
        catch (NoClassDefFoundError ex) {
            LOGGER.warn("Feature service is not present, Feature dump provider will be disabled");
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.featuresServiceSupport != null) {
            this.featuresServiceSupport.run();
        }
    }

    private static class FeaturesServiceSupport
    implements Runnable {
        private BundleContext context;
        private ServiceRegistration registration;
        private ServiceTracker serviceTracker;

        private FeaturesServiceSupport(BundleContext context) {
            this.context = context;
            InvocationHandler invocationHandler = new InvocationHandler(){

                public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                    return method.invoke((Object)FeaturesServiceSupport.this.getFeaturesService(), objects);
                }
            };
            FeaturesService proxy = (FeaturesService)Proxy.newProxyInstance(FeaturesService.class.getClassLoader(), new Class[]{FeaturesService.class}, invocationHandler);
            FeaturesDumpProvider featuresDumpProvider = new FeaturesDumpProvider(proxy);
            this.registration = context.registerService("org.apache.karaf.diagnostic.core.DumpProvider", (Object)featuresDumpProvider, null);
        }

        public void run() {
            if (this.registration != null) {
                this.registration.unregister();
            }
        }

        private FeaturesService getFeaturesService() {
            this.serviceTracker = new ServiceTracker(this.context, FeaturesService.class.getName(), null);
            this.serviceTracker.open();
            return (FeaturesService)this.serviceTracker.getService();
        }
    }
}

