/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.exceptionpolicy.DefaultExceptionPolicyStrategy;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyKey;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.ChildServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ErrorHandlerSupport
extends ChildServiceSupport
implements ErrorHandler {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Map<ExceptionPolicyKey, OnExceptionDefinition> exceptionPolicies = new LinkedHashMap<ExceptionPolicyKey, OnExceptionDefinition>();
    protected ExceptionPolicyStrategy exceptionPolicy = ErrorHandlerSupport.createDefaultExceptionPolicyStrategy();

    public void addExceptionPolicy(RouteContext routeContext, OnExceptionDefinition exceptionType) {
        Processor errorHandler;
        if (routeContext != null && (errorHandler = exceptionType.getErrorHandler(routeContext.getRoute().getId())) != null) {
            this.addChildService(errorHandler);
        }
        List<Class> list = exceptionType.getExceptionClasses();
        for (Class clazz : list) {
            RouteDefinition route;
            String routeId = null;
            if (exceptionType.isRouteScoped() && (route = ProcessorDefinitionHelper.getRoute(exceptionType)) != null) {
                routeId = route.getId();
            }
            ExceptionPolicyKey key = new ExceptionPolicyKey(routeId, clazz, exceptionType.getOnWhen());
            this.exceptionPolicies.put(key, exceptionType);
        }
    }

    protected OnExceptionDefinition getExceptionPolicy(Exchange exchange, Throwable exception) {
        if (this.exceptionPolicy == null) {
            throw new IllegalStateException("The exception policy has not been set");
        }
        return this.exceptionPolicy.getExceptionPolicy(this.exceptionPolicies, exchange, exception);
    }

    public void setExceptionPolicy(ExceptionPolicyStrategy exceptionPolicy) {
        if (exceptionPolicy != null) {
            this.exceptionPolicy = exceptionPolicy;
        }
    }

    public static ExceptionPolicyStrategy createDefaultExceptionPolicyStrategy() {
        return new DefaultExceptionPolicyStrategy();
    }

    public abstract boolean supportTransacted();

    public abstract Processor getOutput();
}

