/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FilterEnabled;
import org.codehaus.plexus.archiver.FinalizerEnabled;
import org.codehaus.plexus.archiver.util.FilterSupport;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractZipUnArchiver
extends AbstractUnArchiver
implements FilterEnabled,
FinalizerEnabled {
    private static final String NATIVE_ENCODING = "native-encoding";
    private String encoding = "UTF8";
    private FilterSupport filterSupport;
    private List finalizers;

    public void setArchiveFilters(List filters) {
        this.filterSupport = new FilterSupport(filters, this.getLogger());
    }

    public void setEncoding(String encoding) {
        if (NATIVE_ENCODING.equals(encoding)) {
            encoding = null;
        }
        this.encoding = encoding;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute() throws ArchiverException, IOException {
        this.getLogger().info("Expanding: " + this.getSourceFile() + " into " + this.getDestDirectory());
        ZipFile zf = null;
        try {
            try {
                zf = new ZipFile(this.getSourceFile(), this.encoding);
                Enumeration e = zf.getEntries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = (ZipEntry)e.nextElement();
                    this.extractFileIfIncluded(this.getSourceFile(), this.getDestDirectory(), zf.getInputStream(ze), ze.getName(), new Date(ze.getTime()), ze.isDirectory());
                }
                this.runArchiveFinalizers();
                this.getLogger().debug("expand complete");
            }
            catch (IOException ioe) {
                throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), ioe);
            }
            Object var5_5 = null;
            if (zf == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (zf == null) throw throwable;
            try {
                zf.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e2) {}
        zf.close();
        return;
    }

    private void extractFileIfIncluded(File sourceFile, File destDirectory, InputStream inputStream, String name, Date time, boolean isDirectory) throws IOException, ArchiverException {
        try {
            if (this.filterSupport == null || this.filterSupport.include(inputStream, name)) {
                this.extractFile(sourceFile, destDirectory, inputStream, name, time, isDirectory);
            }
        }
        catch (ArchiveFilterException e) {
            throw new ArchiverException("Error verifying '" + name + "' for inclusion: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void extractFile(File srcF, File dir, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory) throws IOException {
        File f = FileUtils.resolveFile(dir, entryName);
        try {
            block12: {
                if (!this.isOverwrite() && f.exists() && f.lastModified() >= entryDate.getTime()) {
                    this.getLogger().debug("Skipping " + f + " as it is up-to-date");
                    return;
                }
                this.getLogger().debug("expanding " + entryName + " to " + f);
                File dirF = f.getParentFile();
                if (dirF != null) {
                    dirF.mkdirs();
                }
                if (isDirectory) {
                    f.mkdirs();
                } else {
                    byte[] buffer = new byte[1024];
                    FileOutputStream fos = null;
                    try {
                        int length;
                        fos = new FileOutputStream(f);
                        while ((length = compressedInputStream.read(buffer)) >= 0) {
                            fos.write(buffer, 0, length);
                        }
                        fos.close();
                        fos = null;
                        Object var13_13 = null;
                        if (fos == null) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        if (fos == null) throw throwable;
                        try {
                            fos.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException e) {}
                    fos.close();
                }
            }
            f.setLastModified(entryDate.getTime());
            return;
        }
        catch (FileNotFoundException ex) {
            this.getLogger().warn("Unable to expand to file " + f.getPath());
        }
    }

    public void setArchiveFinalizers(List archiveFinalizers) {
        this.finalizers = archiveFinalizers;
    }

    protected void runArchiveFinalizers() throws ArchiverException {
        if (this.finalizers != null) {
            Iterator it = this.finalizers.iterator();
            while (it.hasNext()) {
                ArchiveFinalizer finalizer = (ArchiveFinalizer)it.next();
                finalizer.finalizeArchiveExtraction(this);
            }
        }
    }
}

