/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.internal;

import aQute.lib.osgi.Analyzer;
import java.util.Map;
import org.apache.aries.util.VersionRange;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.felix.utils.version.VersionTable;
import org.fusesource.fabric.fab.DependencyTree;
import org.fusesource.fabric.fab.util.Strings;
import org.osgi.framework.Version;

public class Versions {
    public static String toVersionRange(String versionOrRange, int digitChanges) {
        Version version;
        if (Versions.isRange(versionOrRange)) {
            return versionOrRange;
        }
        Version nextVersion = version = VersionTable.getVersion(versionOrRange);
        switch (digitChanges) {
            case 1: {
                return "[" + version + "," + version.getMajor() + "." + version.getMinor() + "." + (version.getMicro() + 1) + ")";
            }
            case 2: {
                return "[" + version + "," + version.getMajor() + "." + (version.getMinor() + 1) + ")";
            }
            case 3: {
                return "[" + version + "," + (version.getMajor() + 1) + ")";
            }
            case 4: {
                return "[" + version + ",)";
            }
        }
        return "[" + version + "," + version + "]";
    }

    public static boolean isRange(String versionOrRange) {
        return versionOrRange.contains("[") || versionOrRange.contains("(");
    }

    public static boolean inRange(String versionText, String range) {
        VersionRange versionRange = VersionRange.parseVersionRange(range);
        Version version = VersionTable.getVersion(versionText);
        if (version != null && versionRange != null) {
            return versionRange.matches(version);
        }
        return false;
    }

    public static boolean isMavenVersionOlder(String version1, String version2) {
        return Versions.isVersionOlder(Versions.fromMavenVersion(version1), Versions.fromMavenVersion(version2));
    }

    public static boolean isVersionOlder(String version1, String version2) {
        return Versions.isVersionOlder(new Version(version1), new Version(version2));
    }

    public static boolean isVersionOlder(Version version1, Version version2) {
        int value = version1.compareTo(version2);
        return value < 0;
    }

    public static Version fromMavenVersion(String version) {
        return new Version(VersionCleaner.clean(version));
    }

    public static String getOSGiPackageVersion(DependencyTree dependency, String packageName) {
        String version;
        Map<String, Map<String, String>> values;
        Map<String, String> map;
        String exportPackages;
        if (dependency.isBundle() && Strings.notEmpty(exportPackages = dependency.getManifestEntry("Export-Package")) && (map = (values = new Analyzer().parseHeader(exportPackages)).get(packageName)) != null && (version = map.get("version")) != null) {
            return version;
        }
        String version2 = dependency.getVersion();
        if (version2 != null) {
            return VersionCleaner.clean(version2);
        }
        return null;
    }
}

