/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.connector.wagon;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.sonatype.aether.ConfigurationProperties;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonTransferListenerAdapter;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.connector.ArtifactDownload;
import org.sonatype.aether.spi.connector.ArtifactTransfer;
import org.sonatype.aether.spi.connector.ArtifactUpload;
import org.sonatype.aether.spi.connector.MetadataDownload;
import org.sonatype.aether.spi.connector.MetadataTransfer;
import org.sonatype.aether.spi.connector.MetadataUpload;
import org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.spi.connector.Transfer;
import org.sonatype.aether.spi.io.FileProcessor;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.transfer.ArtifactNotFoundException;
import org.sonatype.aether.transfer.ArtifactTransferException;
import org.sonatype.aether.transfer.ChecksumFailureException;
import org.sonatype.aether.transfer.MetadataNotFoundException;
import org.sonatype.aether.transfer.MetadataTransferException;
import org.sonatype.aether.transfer.NoRepositoryConnectorException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.ChecksumUtils;
import org.sonatype.aether.util.StringUtils;
import org.sonatype.aether.util.layout.MavenDefaultLayout;
import org.sonatype.aether.util.layout.RepositoryLayout;
import org.sonatype.aether.util.listener.DefaultTransferEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WagonRepositoryConnector
implements RepositoryConnector {
    private final Logger logger;
    private final FileProcessor fileProcessor;
    private final RemoteRepository repository;
    private final RepositorySystemSession session;
    private final WagonProvider wagonProvider;
    private final String wagonHint;
    private final Repository wagonRepo;
    private final AuthenticationInfo wagonAuth;
    private final ProxyInfoProvider wagonProxy;
    private final RepositoryLayout layout = new MavenDefaultLayout();
    private final TransferListener listener;
    private final Queue<Wagon> wagons = new ConcurrentLinkedQueue<Wagon>();
    private final Executor executor;
    private boolean closed;
    private final Map<String, String> checksumAlgos;
    private static final ExceptionWrapper<MetadataTransfer> METADATA = new ExceptionWrapper<MetadataTransfer>(){

        @Override
        public void wrap(MetadataTransfer transfer, Exception e, RemoteRepository repository) {
            MetadataTransferException ex = null;
            if (e instanceof ResourceDoesNotExistException) {
                ex = new MetadataNotFoundException(transfer.getMetadata(), repository);
            } else if (e != null) {
                ex = new MetadataTransferException(transfer.getMetadata(), repository, e);
            }
            transfer.setException(ex);
        }
    };
    private static final ExceptionWrapper<ArtifactTransfer> ARTIFACT = new ExceptionWrapper<ArtifactTransfer>(){

        @Override
        public void wrap(ArtifactTransfer transfer, Exception e, RemoteRepository repository) {
            ArtifactTransferException ex = null;
            if (e instanceof ResourceDoesNotExistException) {
                ex = new ArtifactNotFoundException(transfer.getArtifact(), repository);
            } else if (e != null) {
                ex = new ArtifactTransferException(transfer.getArtifact(), repository, e);
            }
            transfer.setException(ex);
        }
    };

    public WagonRepositoryConnector(WagonProvider wagonProvider, RemoteRepository repository, RepositorySystemSession session, FileProcessor fileProcessor, Logger logger) throws NoRepositoryConnectorException {
        this.logger = logger;
        this.fileProcessor = fileProcessor;
        this.wagonProvider = wagonProvider;
        this.repository = repository;
        this.session = session;
        this.listener = session.getTransferListener();
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryConnectorException(repository);
        }
        this.wagonRepo = new Repository(repository.getId(), repository.getUrl());
        this.wagonHint = this.wagonRepo.getProtocol().toLowerCase(Locale.ENGLISH);
        try {
            this.wagons.add(this.lookupWagon());
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            throw new NoRepositoryConnectorException(repository);
        }
        this.wagonAuth = this.getAuthenticationInfo(repository);
        this.wagonProxy = this.getProxy(repository);
        int threads = ConfigurationProperties.get(session.getConfigProperties(), "aether.connector.wagon.threads", Integer.MIN_VALUE);
        if (threads == Integer.MIN_VALUE) {
            threads = ConfigurationProperties.get(session.getConfigProperties(), "maven.artifact.threads", 5);
        }
        this.executor = threads <= 1 ? new Executor(){

            public void execute(Runnable command) {
                command.run();
            }
        } : new ThreadPoolExecutor(threads, threads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.checksumAlgos = new LinkedHashMap<String, String>();
        this.checksumAlgos.put("SHA-1", ".sha1");
        this.checksumAlgos.put("MD5", ".md5");
    }

    private AuthenticationInfo getAuthenticationInfo(RemoteRepository repository) {
        AuthenticationInfo auth = null;
        Authentication a = repository.getAuthentication();
        if (a != null) {
            auth = new AuthenticationInfo();
            auth.setUserName(a.getUsername());
            auth.setPassword(a.getPassword());
            auth.setPrivateKey(a.getPrivateKeyFile());
            auth.setPassphrase(a.getPassphrase());
        }
        return auth;
    }

    private ProxyInfoProvider getProxy(RemoteRepository repository) {
        ProxyInfoProvider proxy = null;
        Proxy p = repository.getProxy();
        if (p != null) {
            final ProxyInfo prox = new ProxyInfo();
            prox.setType(p.getType());
            prox.setHost(p.getHost());
            prox.setPort(p.getPort());
            if (p.getAuthentication() != null) {
                prox.setUserName(p.getAuthentication().getUsername());
                prox.setPassword(p.getAuthentication().getPassword());
            }
            proxy = new ProxyInfoProvider(){

                public ProxyInfo getProxyInfo(String protocol) {
                    return prox;
                }
            };
        }
        return proxy;
    }

    private Wagon lookupWagon() throws Exception {
        return this.wagonProvider.lookup(this.wagonHint);
    }

    private void releaseWagon(Wagon wagon) {
        this.wagonProvider.release(wagon);
    }

    private void connectWagon(Wagon wagon) throws Exception {
        String userAgent = ConfigurationProperties.get(this.session.getConfigProperties(), "aether.connector.userAgent", "Aether");
        if (!StringUtils.isEmpty(userAgent)) {
            try {
                Method setHttpHeaders = wagon.getClass().getMethod("setHttpHeaders", Properties.class);
                Properties headers = new Properties();
                headers.setProperty("User-Agent", userAgent);
                setHttpHeaders.invoke((Object)wagon, headers);
            }
            catch (Exception e) {
                this.logger.debug("Could not set user agent for wagon " + wagon.getClass().getName() + ": " + e);
            }
        }
        int connectTimeout = ConfigurationProperties.get(this.session.getConfigProperties(), "aether.connector.connectTimeout", 10000);
        wagon.setTimeout(Math.max(connectTimeout, 0));
        wagon.setInteractive(ConfigurationProperties.get(this.session.getConfigProperties(), "aether.interactive", false));
        wagon.connect(this.wagonRepo, this.wagonAuth, this.wagonProxy);
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            if (wagon != null) {
                wagon.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Wagon pollWagon() throws Exception {
        Wagon wagon = this.wagons.poll();
        if (wagon == null) {
            try {
                wagon = this.lookupWagon();
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.releaseWagon(wagon);
                throw e;
            }
        }
        if (wagon.getRepository() == null) {
            try {
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.wagons.add(wagon);
                throw e;
            }
        }
        return wagon;
    }

    private <T> Collection<T> safe(Collection<T> items) {
        return items != null ? items : Collections.emptyList();
    }

    @Override
    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        GetTask task;
        String resource;
        if (this.closed) {
            throw new IllegalStateException("connector closed");
        }
        artifactDownloads = this.safe(artifactDownloads);
        metadataDownloads = this.safe(metadataDownloads);
        CountDownLatch latch = new CountDownLatch(artifactDownloads.size() + metadataDownloads.size());
        ArrayList<GetTask> tasks = new ArrayList<GetTask>();
        for (MetadataDownload metadataDownload : metadataDownloads) {
            resource = this.layout.getPath(metadataDownload.getMetadata()).getPath();
            task = new GetTask(this, resource, metadataDownload.getFile(), metadataDownload.getChecksumPolicy(), latch, (Transfer)metadataDownload, METADATA);
            tasks.add(task);
            this.executor.execute(task);
        }
        for (ArtifactDownload artifactDownload : artifactDownloads) {
            resource = this.layout.getPath(artifactDownload.getArtifact()).getPath();
            task = new GetTask(this, resource, artifactDownload.isExistenceCheck() ? null : artifactDownload.getFile(), artifactDownload.getChecksumPolicy(), latch, (Transfer)artifactDownload, ARTIFACT);
            tasks.add(task);
            this.executor.execute(task);
        }
        try {
            latch.await();
            for (GetTask getTask : tasks) {
                getTask.flush();
            }
        }
        catch (InterruptedException e) {
            for (GetTask task3 : tasks) {
                task3.flush(e);
            }
        }
    }

    @Override
    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        PutTask task;
        String path;
        if (this.closed) {
            throw new IllegalStateException("connector closed");
        }
        artifactUploads = this.safe(artifactUploads);
        metadataUploads = this.safe(metadataUploads);
        for (ArtifactUpload artifactUpload : artifactUploads) {
            path = this.layout.getPath(artifactUpload.getArtifact()).getPath();
            task = new PutTask(this, path, artifactUpload.getFile(), (Transfer)artifactUpload, ARTIFACT);
            task.run();
            task.flush();
        }
        for (MetadataUpload metadataUpload : metadataUploads) {
            path = this.layout.getPath(metadataUpload.getMetadata()).getPath();
            task = new PutTask(this, path, metadataUpload.getFile(), (Transfer)metadataUpload, METADATA);
            task.run();
            task.flush();
        }
    }

    @Override
    public void close() {
        this.closed = true;
        Wagon wagon = this.wagons.poll();
        while (wagon != null) {
            this.disconnectWagon(wagon);
            this.releaseWagon(wagon);
            wagon = this.wagons.poll();
        }
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }

    public String toString() {
        return String.valueOf(this.repository);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ExceptionWrapper<T> {
        public void wrap(T var1, Exception var2, RemoteRepository var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PutTask<T extends Transfer>
    implements Runnable {
        private final T upload;
        private final ExceptionWrapper<T> wrapper;
        private final String path;
        private final File file;
        private volatile Exception exception;
        final /* synthetic */ WagonRepositoryConnector this$0;

        public PutTask(String path, File file, T upload, ExceptionWrapper<T> wrapper) {
            this.this$0 = var1_1;
            this.path = path;
            this.file = file;
            this.upload = upload;
            this.wrapper = wrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                ((Transfer)this.upload).setState(Transfer.State.ACTIVE);
                WagonTransferListenerAdapter wagonListener = null;
                if (this.this$0.listener != null) {
                    wagonListener = new WagonTransferListenerAdapter(this.this$0.listener, this.this$0.wagonRepo.getUrl(), this.path, this.file);
                }
                try {
                    if (this.this$0.listener != null) {
                        DefaultTransferEvent event = wagonListener.newEvent();
                        event.setRequestType(TransferEvent.RequestType.PUT);
                        event.setType(TransferEvent.EventType.INITIATED);
                        this.this$0.listener.transferInitiated(event);
                    }
                    Wagon wagon = this.this$0.pollWagon();
                    try {
                        try {
                            wagon.addTransferListener(wagonListener);
                            wagon.put(this.file, this.path);
                        }
                        finally {
                            wagon.removeTransferListener(wagonListener);
                        }
                        this.uploadChecksums(wagon, this.file, this.path);
                        if (this.this$0.listener != null) {
                            DefaultTransferEvent event = wagonListener.newEvent();
                            event.setRequestType(TransferEvent.RequestType.PUT);
                            event.setType(TransferEvent.EventType.SUCCEEDED);
                            this.this$0.listener.transferSucceeded(event);
                        }
                    }
                    finally {
                        this.this$0.wagons.add(wagon);
                    }
                }
                catch (Exception e) {
                    this.exception = e;
                    if (this.this$0.listener == null) break block12;
                    DefaultTransferEvent event = wagonListener.newEvent();
                    event.setRequestType(TransferEvent.RequestType.PUT);
                    event.setType(TransferEvent.EventType.FAILED);
                    event.setException(e);
                    this.this$0.listener.transferFailed(event);
                }
            }
        }

        public void flush() {
            this.wrapper.wrap(this.upload, this.exception, this.this$0.repository);
            ((Transfer)this.upload).setState(Transfer.State.DONE);
        }

        private void uploadChecksums(Wagon wagon, File file, String path) {
            try {
                Map<String, Object> checksums = ChecksumUtils.calc(file, this.this$0.checksumAlgos.keySet());
                for (Map.Entry<String, Object> entry : checksums.entrySet()) {
                    this.uploadChecksum(wagon, file, path, entry.getKey(), entry.getValue());
                }
            }
            catch (IOException e) {
                this.this$0.logger.debug("Failed to upload checksums for " + file + ": " + e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uploadChecksum(Wagon wagon, File file, String path, String algo, Object checksum) {
            try {
                if (checksum instanceof Exception) {
                    throw (Exception)checksum;
                }
                String ext = (String)this.this$0.checksumAlgos.get(algo);
                File tmpFile = File.createTempFile("checksum", ext);
                try {
                    this.this$0.fileProcessor.write(tmpFile, String.valueOf(checksum));
                    wagon.put(tmpFile, path + ext);
                }
                finally {
                    tmpFile.delete();
                }
            }
            catch (Exception e) {
                this.this$0.logger.debug("Failed to upload " + algo + " checksum for " + file + ": " + e.getMessage(), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetTask<T extends Transfer>
    implements Runnable {
        private final T download;
        private final String path;
        private final File file;
        private final String checksumPolicy;
        private final CountDownLatch latch;
        private volatile Exception exception;
        private final ExceptionWrapper<T> wrapper;
        final /* synthetic */ WagonRepositoryConnector this$0;

        public GetTask(String path, File file, String checksumPolicy, CountDownLatch latch, T download, ExceptionWrapper<T> wrapper) {
            this.this$0 = var1_1;
            this.path = path;
            this.file = file;
            this.checksumPolicy = checksumPolicy;
            this.latch = latch;
            this.download = download;
            this.wrapper = wrapper;
        }

        public T getDownload() {
            return this.download;
        }

        public Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ((Transfer)this.download).setState(Transfer.State.ACTIVE);
            WagonTransferListenerAdapter wagonListener = null;
            if (this.this$0.listener != null) {
                wagonListener = new WagonTransferListenerAdapter(this.this$0.listener, this.this$0.wagonRepo.getUrl(), this.path, this.file);
            }
            try {
                if (this.this$0.listener != null) {
                    DefaultTransferEvent event = wagonListener.newEvent();
                    event.setRequestType(TransferEvent.RequestType.GET);
                    event.setType(TransferEvent.EventType.INITIATED);
                    this.this$0.listener.transferInitiated(event);
                }
                File tmp = this.file != null ? new File(this.file.getPath() + ".tmp" + System.currentTimeMillis()) : null;
                Wagon wagon = this.this$0.pollWagon();
                try {
                    if (this.file == null) {
                        if (!wagon.resourceExists(this.path)) {
                            throw new ResourceDoesNotExistException("Could not find " + this.path + " in " + this.this$0.wagonRepo.getUrl());
                        }
                    } else {
                        for (int trial = 1; trial >= 0; --trial) {
                            ChecksumObserver sha1 = new ChecksumObserver("SHA-1");
                            ChecksumObserver md5 = new ChecksumObserver("MD5");
                            try {
                                wagon.addTransferListener(wagonListener);
                                wagon.addTransferListener(md5);
                                wagon.addTransferListener(sha1);
                                this.this$0.fileProcessor.mkdirs(tmp.getParentFile());
                                wagon.get(this.path, tmp);
                            }
                            finally {
                                wagon.removeTransferListener(wagonListener);
                                wagon.removeTransferListener(md5);
                                wagon.removeTransferListener(sha1);
                            }
                            if ("ignore".equals(this.checksumPolicy)) break;
                            try {
                                if (!this.verifyChecksum(wagon, sha1.getActualChecksum(), ".sha1") && !this.verifyChecksum(wagon, md5.getActualChecksum(), ".md5")) {
                                    trial = 0;
                                    throw new ChecksumFailureException("Checksum validation failed, no checksums available from the repository");
                                }
                                break;
                            }
                            catch (ChecksumFailureException e) {
                                if (trial <= 0 && "fail".equals(this.checksumPolicy)) {
                                    throw e;
                                }
                                if (this.this$0.listener == null) continue;
                                DefaultTransferEvent event = wagonListener.newEvent();
                                event.setRequestType(TransferEvent.RequestType.GET);
                                event.setType(TransferEvent.EventType.CORRUPTED);
                                event.setException(e);
                                this.this$0.listener.transferCorrupted(event);
                                continue;
                            }
                        }
                        this.rename(tmp, this.file);
                    }
                    if (this.this$0.listener != null) {
                        DefaultTransferEvent event = wagonListener.newEvent();
                        event.setRequestType(TransferEvent.RequestType.GET);
                        event.setType(TransferEvent.EventType.SUCCEEDED);
                        this.this$0.listener.transferSucceeded(event);
                    }
                }
                finally {
                    if (tmp != null) {
                        tmp.delete();
                    }
                    this.this$0.wagons.add(wagon);
                }
            }
            catch (Exception e) {
                this.exception = e;
                if (this.this$0.listener != null) {
                    DefaultTransferEvent event = wagonListener.newEvent();
                    event.setRequestType(TransferEvent.RequestType.GET);
                    event.setType(TransferEvent.EventType.FAILED);
                    event.setException(e);
                    this.this$0.listener.transferFailed(event);
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        public void flush() {
            this.flush(null);
        }

        public void flush(Exception exception) {
            Exception e = this.exception;
            this.wrapper.wrap(this.download, e != null ? e : exception, this.this$0.repository);
            ((Transfer)this.download).setState(Transfer.State.DONE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private boolean verifyChecksum(Wagon wagon, String actual, String ext) throws ChecksumFailureException {
            tmp = new File(this.file.getPath() + ext + ".tmp" + System.currentTimeMillis());
            try {
                wagon.get(this.path + ext, tmp);
            }
            catch (ResourceDoesNotExistException e) {
                var6_8 = false;
                tmp.delete();
                return var6_8;
            }
            catch (WagonException e) {
                throw new ChecksumFailureException(e);
            }
            ** try [egrp 3[TRYBLOCK] [2 : 102->112)] { 
lbl-1000:
            // 1 sources

            {
                expected = ChecksumUtils.read(tmp);
            }
lbl16:
            // 1 sources

            catch (IOException e) {
                throw new ChecksumFailureException(e);
            }
            if (expected.equalsIgnoreCase(actual)) {
                try {
                    this.rename(tmp, new File(this.file.getPath() + ext));
                }
                catch (IOException e) {}
            } else {
                throw new ChecksumFailureException(expected, actual);
                finally {
                    tmp.delete();
                }
            }
            return true;
        }

        private void rename(File from, File to) throws IOException {
            if (!from.renameTo(to)) {
                if (!from.exists()) {
                    this.this$0.fileProcessor.write(to, "");
                } else {
                    this.this$0.fileProcessor.copy(from, to, null);
                }
            }
        }
    }
}

