/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.GregorianCalendar;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.Bundle;

@Command(scope="osgi", name="shutdown", description="Shuts the framework down.")
public class Shutdown
extends OsgiCommandSupport {
    @Option(name="-f", aliases={"--force"}, description="Force the shutdown without confirmation message.", required=false, multiValued=false)
    boolean force = false;
    @Argument(name="time", index=0, description="Shutdown after a specified delay. The time argument can have different formats. First, it can be an abolute time in the format hh:mm, in which hh is the hour (1 or 2 digits) and mm is the minute of the hour. The absolute time is in 24 hours. Second, it can be in the format +m, in which m is the number of minutes to wait. The word now is an alias for +0.", required=false, multiValued=false)
    String time;

    protected Object doExecute() throws Exception {
        long sleep = 0L;
        if (this.time != null && !this.time.equals("now")) {
            if (this.time.startsWith("+")) {
                this.time = this.time.substring(1);
                try {
                    sleep = Long.parseLong(this.time) * 60L * 1000L;
                }
                catch (Exception e) {
                    System.err.println("Invalid time argument.");
                    return null;
                }
            } else {
                String[] strings = this.time.split(":");
                if (strings.length != 2) {
                    System.err.println("Invalid time argument.");
                    return null;
                }
                GregorianCalendar currentDate = new GregorianCalendar();
                GregorianCalendar shutdownDate = new GregorianCalendar(currentDate.get(1), currentDate.get(2), currentDate.get(5), Integer.parseInt(strings[0]), Integer.parseInt(strings[1]));
                if (shutdownDate.before(currentDate)) {
                    shutdownDate.set(5, shutdownDate.get(5) + 1);
                }
                sleep = shutdownDate.getTimeInMillis() - currentDate.getTimeInMillis();
            }
        }
        if (this.force) {
            this.shutdown(sleep);
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String karafName = System.getProperty("karaf.name");
        System.err.println(String.format("Confirm: shutdown instance %s (yes/no): ", karafName));
        System.err.flush();
        while (true) {
            int c;
            if ((c = this.session.getKeyboard().read()) < 0) {
                return null;
            }
            System.err.print((char)c);
            System.err.flush();
            if (c == 13 || c == 10) break;
            sb.append((char)c);
        }
        String str = sb.toString();
        if (str.equals("yes")) {
            this.shutdown(sleep);
        }
        return null;
    }

    private void shutdown(final long sleep) {
        new Thread(){

            public void run() {
                try {
                    if (sleep > 0L) {
                        System.err.println("Shutdown in " + sleep / 1000L / 60L + " minute(s).");
                    }
                    Thread.sleep(sleep);
                    Bundle bundle = Shutdown.this.getBundleContext().getBundle(0L);
                    bundle.stop();
                }
                catch (Exception e) {
                    Shutdown.this.log.error("Error when shutting down", (Throwable)e);
                }
            }
        }.start();
    }
}

