/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.namespace;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.container.NamespaceHandlerRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceHandlerRegistryImpl
implements NamespaceHandlerRegistry,
ServiceTrackerCustomizer {
    public static final URI BLUEPRINT_NAMESPACE = URI.create("http://www.osgi.org/xmlns/blueprint/v1.0.0");
    public static final String NAMESPACE = "osgi.service.blueprint.namespace";
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceHandlerRegistryImpl.class);
    private final BundleContext bundleContext;
    private final Map<URI, Set<NamespaceHandler>> handlers;
    private final ServiceTracker tracker;
    private final Map<Map<URI, NamespaceHandler>, Reference<Schema>> schemas = new LRUMap<Map<URI, NamespaceHandler>, Reference<Schema>>(10);
    private SchemaFactory schemaFactory;
    private List<NamespaceHandlerSetImpl> sets;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public NamespaceHandlerRegistryImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.handlers = new HashMap<URI, Set<NamespaceHandler>>();
        this.sets = new ArrayList<NamespaceHandlerSetImpl>();
        this.tracker = new ServiceTracker(bundleContext, NamespaceHandler.class.getName(), (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public Object addingService(ServiceReference reference) {
        LOGGER.debug("Adding NamespaceHandler " + reference.toString());
        NamespaceHandler handler = (NamespaceHandler)this.bundleContext.getService(reference);
        if (handler != null) {
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (String name : reference.getPropertyKeys()) {
                    props.put(name, reference.getProperty(name));
                }
                this.registerHandler(handler, props);
            }
            catch (Exception e) {
                LOGGER.warn("Error registering NamespaceHandler", (Throwable)e);
            }
        } else {
            LOGGER.warn("Error resolving NamespaceHandler, null Service obtained from tracked ServiceReference {} for bundle {}, ver {}", new Object[]{reference.toString(), reference.getBundle().getSymbolicName(), reference.getBundle().getVersion()});
        }
        return handler;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        try {
            NamespaceHandler handler = (NamespaceHandler)service;
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String name : reference.getPropertyKeys()) {
                props.put(name, reference.getProperty(name));
            }
            this.unregisterHandler(handler, props);
        }
        catch (Exception e) {
            LOGGER.warn("Error unregistering NamespaceHandler", (Throwable)e);
        }
    }

    public synchronized void registerHandler(NamespaceHandler handler, Map properties) {
        List<URI> namespaces = NamespaceHandlerRegistryImpl.getNamespaces(properties);
        for (URI uri : namespaces) {
            Set<NamespaceHandler> h = this.handlers.get(uri);
            if (h == null) {
                h = new HashSet<NamespaceHandler>();
                this.handlers.put(uri, h);
            }
            if (!h.add(handler)) continue;
            for (NamespaceHandlerSetImpl s : this.sets) {
                s.registerHandler(uri, handler);
            }
        }
    }

    public synchronized void unregisterHandler(NamespaceHandler handler, Map properties) {
        List<URI> namespaces = NamespaceHandlerRegistryImpl.getNamespaces(properties);
        for (URI uri : namespaces) {
            Set<NamespaceHandler> h = this.handlers.get(uri);
            if (h == null || !h.remove(handler)) continue;
            for (NamespaceHandlerSetImpl s : this.sets) {
                s.unregisterHandler(uri, handler);
            }
        }
        this.removeSchemasFor(handler);
    }

    private static List<URI> getNamespaces(Map properties) {
        Object ns;
        Object v0 = ns = properties != null ? properties.get(NAMESPACE) : null;
        if (ns == null) {
            throw new IllegalArgumentException("NamespaceHandler service does not have an associated osgi.service.blueprint.namespace property defined");
        }
        if (ns instanceof URI[]) {
            return Arrays.asList(ns);
        }
        if (ns instanceof URI) {
            return Collections.singletonList(ns);
        }
        if (ns instanceof String) {
            return Collections.singletonList(URI.create(ns));
        }
        if (ns instanceof String[]) {
            String[] strings = ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(strings.length);
            for (String string : strings) {
                namespaces.add(URI.create(string));
            }
            return namespaces;
        }
        if (ns instanceof Collection) {
            Collection col = ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(col.size());
            for (Object o : col) {
                namespaces.add(NamespaceHandlerRegistryImpl.toURI(o));
            }
            return namespaces;
        }
        if (ns instanceof Object[]) {
            Object[] array = ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(array.length);
            for (Object o : array) {
                namespaces.add(NamespaceHandlerRegistryImpl.toURI(o));
            }
            return namespaces;
        }
        throw new IllegalArgumentException("NamespaceHandler service has an associated osgi.service.blueprint.namespace property defined which can not be converted to an array of URI");
    }

    private static URI toURI(Object o) {
        if (o instanceof URI) {
            return (URI)o;
        }
        if (o instanceof String) {
            return URI.create((String)o);
        }
        throw new IllegalArgumentException("NamespaceHandler service has an associated osgi.service.blueprint.namespace property defined which can not be converted to an array of URI");
    }

    @Override
    public synchronized NamespaceHandlerRegistry.NamespaceHandlerSet getNamespaceHandlers(Set<URI> uris, Bundle bundle) {
        NamespaceHandlerSetImpl s = new NamespaceHandlerSetImpl(uris, bundle);
        this.sets.add(s);
        return s;
    }

    @Override
    public void destroy() {
        this.tracker.close();
    }

    public Schema getSchema(Map<URI, NamespaceHandler> handlers) throws IOException, SAXException {
        return this.getSchema(handlers, null, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema getSchema(Map<URI, NamespaceHandler> handlers, final Bundle bundle, final Properties schemaMap) throws IOException, SAXException {
        if (schemaMap == null || schemaMap.isEmpty()) {
            try {
                this.lock.readLock().lock();
                for (Map<URI, NamespaceHandler> key : this.schemas.keySet()) {
                    boolean found = true;
                    for (URI uri : handlers.keySet()) {
                        if (handlers.get(uri).equals(key.get(uri))) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    Schema i$ = this.schemas.get(key).get();
                    return i$;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        try {
            Schema schema;
            this.lock.writeLock().lock();
            final ArrayList<StreamSource> schemaSources = new ArrayList<StreamSource>();
            try {
                URL url;
                schemaSources.add(new StreamSource(this.getClass().getResourceAsStream("/org/apache/aries/blueprint/blueprint.xsd")));
                for (URI ns : handlers.keySet()) {
                    url = handlers.get(ns).getSchemaLocation(ns.toString());
                    if (url == null) {
                        LOGGER.warn("No URL is defined for schema " + ns + ". This schema will not be validated");
                        continue;
                    }
                    schemaSources.add(new StreamSource(url.openStream(), url.toExternalForm()));
                }
                for (Object ns : schemaMap.values()) {
                    url = bundle.getResource(ns.toString());
                    if (url == null) {
                        LOGGER.warn("No URL is defined for schema " + ns + ". This schema will not be validated");
                        continue;
                    }
                    schemaSources.add(new StreamSource(url.openStream(), url.toExternalForm()));
                }
                SchemaFactory factory = this.getSchemaFactory();
                factory.setResourceResolver(new LSResourceResolver(){

                    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                        URL url;
                        String loc = null;
                        if (namespaceURI != null) {
                            loc = schemaMap.getProperty(namespaceURI);
                        }
                        if (loc == null && publicId != null) {
                            loc = schemaMap.getProperty(publicId);
                        }
                        if (loc == null && systemId != null) {
                            loc = schemaMap.getProperty(systemId);
                        }
                        if (loc != null && (url = bundle.getResource(loc)) != null) {
                            try {
                                StreamSource source = new StreamSource(url.openStream(), url.toExternalForm());
                                schemaSources.add(source);
                                return new SourceLSInput(source, publicId, url);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        URI uri = URI.create(namespaceURI);
                        Set hs = (Set)NamespaceHandlerRegistryImpl.this.handlers.get(uri);
                        if (hs == null) {
                            return null;
                        }
                        for (NamespaceHandler h : hs) {
                            URL url2 = h.getSchemaLocation(namespaceURI);
                            if (url2 == null) continue;
                            if (systemId != null && !systemId.matches("^[a-z][-+.0-9a-z]*:.*")) {
                                try {
                                    url2 = new URL(url2, systemId);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            try {
                                StreamSource source = new StreamSource(url2.openStream(), url2.toExternalForm());
                                schemaSources.add(source);
                                return new SourceLSInput(source, publicId, url2);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return null;
                    }
                });
                Schema schema2 = factory.newSchema(schemaSources.toArray(new Source[schemaSources.size()]));
                Iterator<Map<URI, NamespaceHandler>> iterator = this.schemas.keySet().iterator();
                while (iterator.hasNext()) {
                    Map<URI, NamespaceHandler> key = iterator.next();
                    boolean found = true;
                    for (URI uri : key.keySet()) {
                        if (key.get(uri).equals(handlers.get(uri))) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    iterator.remove();
                    break;
                }
                if (schemaMap.isEmpty()) {
                    this.schemas.put(handlers, new SoftReference<Schema>(schema2));
                }
                schema = schema2;
            }
            catch (Throwable throwable) {
                for (StreamSource s : schemaSources) {
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            for (StreamSource s : schemaSources) {
                try {
                    s.getInputStream().close();
                }
                catch (IOException e) {}
            }
            return schema;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeSchemasFor(NamespaceHandler handler) {
        ArrayList<Map<URI, NamespaceHandler>> keys = new ArrayList<Map<URI, NamespaceHandler>>();
        this.lock.readLock().lock();
        try {
            for (Map<URI, NamespaceHandler> key : this.schemas.keySet()) {
                if (!key.values().contains(handler)) continue;
                keys.add(key);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!keys.isEmpty()) {
            this.lock.writeLock().lock();
            try {
                for (Map<URI, NamespaceHandler> key : keys) {
                    this.schemas.remove(key);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private SchemaFactory getSchemaFactory() {
        if (this.schemaFactory == null) {
            this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
        return this.schemaFactory;
    }

    protected static Map<URI, NamespaceHandler> findHandlers(Map<URI, Set<NamespaceHandler>> allHandlers, Set<URI> namespaces, Bundle bundle) {
        Set h;
        HashMap<URI, NamespaceHandler> handlers = new HashMap<URI, NamespaceHandler>();
        HashMap candidates = new HashMap();
        for (URI ns : namespaces) {
            h = new HashSet();
            if (allHandlers.get(ns) != null) {
                h.addAll(allHandlers.get(ns));
            }
            candidates.put(ns, h);
        }
        for (URI ns : namespaces) {
            Iterator it = ((Set)candidates.get(ns)).iterator();
            while (it.hasNext()) {
                NamespaceHandler h2 = (NamespaceHandler)it.next();
                Set<Class> classes = h2.getManagedClasses();
                boolean compat = true;
                if (classes != null) {
                    HashSet allClasses = new HashSet();
                    Iterator<Class<Object>> i$ = classes.iterator();
                    while (i$.hasNext()) {
                        Class clazz;
                        for (Class c = clazz = i$.next(); c != null; c = c.getSuperclass()) {
                            allClasses.add(c);
                            for (Class<?> i : c.getInterfaces()) {
                                allClasses.add(i);
                            }
                        }
                    }
                    for (Class<Object> clazz : allClasses) {
                        Class clb;
                        try {
                            clb = bundle.loadClass(clazz.getName());
                        }
                        catch (Throwable t) {
                            clb = null;
                        }
                        if (clb == clazz) continue;
                        compat = false;
                        break;
                    }
                }
                if (compat) continue;
                it.remove();
            }
        }
        for (URI ns : namespaces) {
            h = (Set)candidates.get(ns);
            if (h.isEmpty()) continue;
            handlers.put(ns, (NamespaceHandler)h.iterator().next());
        }
        return handlers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LRUMap<K, V>
    extends AbstractMap<K, V> {
        private final int bound;
        private final LinkedList<Map.Entry<K, V>> entries = new LinkedList();

        private LRUMap(int bound) {
            this.bound = bound;
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            for (Map.Entry entry : this.entries) {
                if (!entry.getKey().equals(key)) continue;
                this.entries.remove(entry);
                this.entries.addFirst(entry);
                return entry.getValue();
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            if (key == null) {
                throw new NullPointerException();
            }
            V old = null;
            for (Map.Entry entry : this.entries) {
                if (!entry.getKey().equals(key)) continue;
                this.entries.remove(entry);
                old = entry.getValue();
                break;
            }
            if (value != null) {
                this.entries.addFirst(new LRUEntry(key, value));
                while (this.entries.size() > this.bound) {
                    this.entries.removeLast();
                }
            }
            return old;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return LRUMap.this.entries.iterator();
                }

                @Override
                public int size() {
                    return LRUMap.this.entries.size();
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class LRUEntry<K, V>
        implements Map.Entry<K, V> {
            private final K key;
            private final V value;

            private LRUEntry(K key, V value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NamespaceHandlerSetImpl
    implements NamespaceHandlerRegistry.NamespaceHandlerSet {
        private final Map<NamespaceHandlerRegistry.Listener, Boolean> listeners;
        private final Bundle bundle;
        private final Set<URI> namespaces;
        private final Map<URI, NamespaceHandler> handlers;
        private final Properties schemaMap = new Properties();
        private Schema schema;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NamespaceHandlerSetImpl(Set<URI> namespaces, Bundle bundle) {
            this.listeners = new HashMap<NamespaceHandlerRegistry.Listener, Boolean>();
            this.namespaces = namespaces;
            this.bundle = bundle;
            this.handlers = new HashMap<URI, NamespaceHandler>();
            for (URI ns : namespaces) {
                this.findCompatibleNamespaceHandler(ns);
            }
            URL url = bundle.getResource("OSGI-INF/blueprint/schema.map");
            if (url != null) {
                InputStream ins = null;
                try {
                    ins = url.openStream();
                    this.schemaMap.load(ins);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (ins != null) {
                        try {
                            ins.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            for (Object ns : this.schemaMap.keySet()) {
                try {
                    this.namespaces.remove(new URI(ns.toString()));
                }
                catch (URISyntaxException e) {}
            }
        }

        @Override
        public boolean isComplete() {
            return this.handlers.size() == this.namespaces.size();
        }

        @Override
        public Set<URI> getNamespaces() {
            return this.namespaces;
        }

        @Override
        public NamespaceHandler getNamespaceHandler(URI namespace) {
            return this.handlers.get(namespace);
        }

        @Override
        public Schema getSchema() throws SAXException, IOException {
            if (!this.isComplete()) {
                throw new IllegalStateException("NamespaceHandlerSet is not complete");
            }
            if (this.schema == null) {
                this.schema = NamespaceHandlerRegistryImpl.this.getSchema(this.handlers, this.bundle, this.schemaMap);
            }
            return this.schema;
        }

        @Override
        public synchronized void addListener(NamespaceHandlerRegistry.Listener listener) {
            this.listeners.put(listener, Boolean.TRUE);
        }

        @Override
        public synchronized void removeListener(NamespaceHandlerRegistry.Listener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void destroy() {
            NamespaceHandlerRegistryImpl.this.sets.remove(this);
        }

        public void registerHandler(URI uri, NamespaceHandler handler) {
            if (this.namespaces.contains(uri) && this.handlers.get(uri) == null && this.findCompatibleNamespaceHandler(uri) != null) {
                for (NamespaceHandlerRegistry.Listener listener : this.listeners.keySet()) {
                    try {
                        listener.namespaceHandlerRegistered(uri);
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Unexpected exception when notifying a NamespaceHandler listener", t);
                    }
                }
            }
        }

        public void unregisterHandler(URI uri, NamespaceHandler handler) {
            if (this.handlers.get(uri) == handler) {
                this.handlers.remove(uri);
                for (NamespaceHandlerRegistry.Listener listener : this.listeners.keySet()) {
                    try {
                        listener.namespaceHandlerUnregistered(uri);
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Unexpected exception when notifying a NamespaceHandler listener", t);
                    }
                }
            }
        }

        private NamespaceHandler findCompatibleNamespaceHandler(URI ns) {
            Set candidates = (Set)NamespaceHandlerRegistryImpl.this.handlers.get(ns);
            if (candidates != null) {
                for (NamespaceHandler h : candidates) {
                    Set<Class> classes = h.getManagedClasses();
                    boolean compat = true;
                    if (classes != null) {
                        HashSet allClasses = new HashSet();
                        Iterator<Class<Object>> i$ = classes.iterator();
                        while (i$.hasNext()) {
                            Class clazz;
                            for (Class c = clazz = i$.next(); c != null; c = c.getSuperclass()) {
                                allClasses.add(c);
                                for (Class<?> i : c.getInterfaces()) {
                                    allClasses.add(i);
                                }
                            }
                        }
                        for (Class<Object> clazz : allClasses) {
                            try {
                                Class clb = this.bundle.loadClass(clazz.getName());
                                if (clb == clazz) continue;
                                compat = false;
                                break;
                            }
                            catch (ClassNotFoundException e) {
                            }
                            catch (NoClassDefFoundError e) {
                            }
                        }
                    }
                    if (!compat) continue;
                    this.handlers.put(ns, h);
                    return h;
                }
            }
            return null;
        }
    }

    private class SourceLSInput
    implements LSInput {
        StreamSource source;
        URL systemId;
        String publicId;

        public SourceLSInput(StreamSource src, String pid, URL sys) {
            this.source = src;
            this.publicId = pid;
            this.systemId = sys;
        }

        public Reader getCharacterStream() {
            return null;
        }

        public void setCharacterStream(Reader characterStream) {
        }

        public InputStream getByteStream() {
            return this.source.getInputStream();
        }

        public void setByteStream(InputStream byteStream) {
        }

        public String getStringData() {
            return null;
        }

        public void setStringData(String stringData) {
        }

        public String getSystemId() {
            return this.systemId.toExternalForm();
        }

        public void setSystemId(String systemId) {
        }

        public String getPublicId() {
            return this.publicId;
        }

        public void setPublicId(String publicId) {
        }

        public String getBaseURI() {
            return null;
        }

        public void setBaseURI(String baseURI) {
        }

        public String getEncoding() {
            return null;
        }

        public void setEncoding(String encoding) {
        }

        public boolean getCertifiedText() {
            return false;
        }

        public void setCertifiedText(boolean certifiedText) {
        }
    }
}

