/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

@Command(name="profile-change-parents", scope="fabric", description="Replace the profile's parents with the specified list of parents (where the parents are specified as a space-separated list)")
public class ProfileChangeParents
extends FabricCommand {
    @Option(name="--version", description="The profile version. Defaults to the current default version.")
    private String version;
    @Argument(index=0, required=true, name="profile", description="Name of the profile.")
    private String name;
    @Argument(index=1, name="parents", description="The list of new parent profiles.", required=true, multiValued=true)
    private List<String> parents;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        Profile prof = this.getProfile(ver, this.name);
        Profile[] profs = this.getProfiles(ver, this.parents);
        prof.setParents(profs);
        return null;
    }
}

