/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.completer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.gogo.runtime.Closure;
import org.apache.felix.gogo.runtime.CommandProxy;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.AggregateCompleter;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.console.jline.CommandSessionHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandsCompleter
implements Completer {
    private CommandSession session;
    private final List<Completer> completers = new ArrayList<Completer>();
    private final Set<String> commands = new HashSet<String>();
    private CommandTracker tracker;

    public CommandsCompleter() {
        this(CommandSessionHolder.getSession());
    }

    public CommandsCompleter(CommandSession session) {
        this.session = session;
        try {
            this.tracker = new CommandTracker();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.tracker != null) {
            this.tracker.dispose();
        }
    }

    @Override
    public int complete(String buffer, int cursor, List<String> candidates) {
        if (this.session == null) {
            this.session = CommandSessionHolder.getSession();
        }
        this.checkData();
        int res = new AggregateCompleter(this.completers).complete(buffer, cursor, (List)candidates);
        Collections.sort(candidates);
        return res;
    }

    protected synchronized void checkData() {
        HashSet names = new HashSet((Set)this.session.get(".commands"));
        if (!((Object)names).equals(this.commands)) {
            this.commands.clear();
            this.completers.clear();
            Set<String> aliases = this.getAliases();
            this.completers.add(new StringsCompleter(aliases));
            for (String command : names) {
                Function function = (Function)this.session.get(command);
                if ((function = this.unProxy(function)) instanceof AbstractCommand) {
                    this.completers.add(new ArgumentCompleter(this.session, (AbstractCommand)function, command));
                }
                this.commands.add(command);
            }
        }
    }

    private Set<String> getAliases() {
        Set vars = (Set)this.session.get(null);
        HashSet<String> aliases = new HashSet<String>();
        for (String var : vars) {
            Object content = this.session.get(var);
            if (!(content instanceof Closure)) continue;
            aliases.add(var);
        }
        return aliases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Function unProxy(Function function) {
        block6: {
            try {
                if (!(function instanceof CommandProxy)) break block6;
                Field contextField = function.getClass().getDeclaredField("context");
                Field referenceField = function.getClass().getDeclaredField("reference");
                contextField.setAccessible(true);
                referenceField.setAccessible(true);
                BundleContext context = (BundleContext)contextField.get(function);
                ServiceReference reference = (ServiceReference)referenceField.get(function);
                Object target = context.getService(reference);
                try {
                    if (target instanceof Function) {
                        function = (Function)target;
                    }
                }
                finally {
                    context.ungetService(reference);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return function;
    }

    private class CommandTracker {
        private final ServiceListener listener;

        public CommandTracker() throws Exception {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            this.listener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    CommandsCompleter.this.commands.clear();
                }
            };
            context.addServiceListener(this.listener, String.format("(&(%s=*)(%s=*))", "osgi.command.scope", "osgi.command.function"));
        }

        public void dispose() {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            context.removeServiceListener(this.listener);
        }
    }
}

