/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.api.data.BundleInfo;
import org.fusesource.fabric.api.data.ServiceInfo;
import org.fusesource.fabric.internal.BundleInfoComparator;
import org.fusesource.fabric.internal.JmxBundleInfo;
import org.fusesource.fabric.internal.JmxServiceInfo;
import org.fusesource.fabric.internal.ProfileImpl;
import org.fusesource.fabric.internal.ServiceInfoComparator;
import org.fusesource.fabric.internal.VersionImpl;
import org.fusesource.fabric.service.ContainerTemplate;
import org.fusesource.fabric.service.FabricServiceImpl;
import org.fusesource.fabric.utils.Base64Encoder;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.ServiceStateMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerImpl
implements Container {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Container parent;
    private final String id;
    private final FabricServiceImpl service;
    private CreateContainerMetadata<?> metadata;

    public ContainerImpl(Container parent, String id, FabricServiceImpl service) {
        this.parent = parent;
        this.id = id;
        this.service = service;
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isAlive() {
        try {
            return this.service.getZooKeeper().exists(ZkPath.CONTAINER_ALIVE.getPath(new String[]{this.id})) != null;
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isEnsembleServer() {
        try {
            String version = this.getVersion().getName();
            String clusterId = this.service.getZooKeeper().getStringData("/fabric/configs/versions/" + version + "/general/fabric-ensemble");
            String containers = this.service.getZooKeeper().getStringData("/fabric/configs/versions/" + version + "/general/fabric-ensemble/" + clusterId);
            for (String name : containers.split(",")) {
                if (!this.id.equals(name)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public boolean isProvisioningComplete() {
        String result = this.getProvisionResult();
        return "success".equals(result) || "error".equals(result);
    }

    @Override
    public boolean isProvisioningPending() {
        String result = this.getProvisionResult();
        if (result == null) {
            return false;
        }
        return !this.isProvisioningComplete();
    }

    @Override
    public String getProvisionStatus() {
        String provisioned = this.getProvisionResult();
        String provisionException = this.getProvisionException();
        String result = "not provisioned";
        if (provisioned != null && (result = provisioned).equals("error") && provisionException != null) {
            result = result + " - " + provisionException.split(System.getProperty("line.separator"))[0];
        }
        return result;
    }

    @Override
    public String getSshUrl() {
        try {
            return ZooKeeperUtils.getSubstitutedPath((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_SSH.getPath(new String[]{this.id}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public String getJmxUrl() {
        try {
            return ZooKeeperUtils.getSubstitutedPath((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_JMX.getPath(new String[]{this.id}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    private String getZkData(ZkPath path) {
        try {
            return this.service.getZooKeeper().getStringData(path.getPath(new String[]{this.id}));
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public boolean isManaged() {
        return this.getProvisionResult() != null;
    }

    @Override
    public Version getVersion() {
        try {
            String version = this.getZkData(ZkPath.CONFIG_CONTAINER);
            if (version == null) {
                return null;
            }
            return new VersionImpl(version, this.service);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setVersion(Version version) {
        try {
            Version curretVersion = this.getVersion();
            if (this.requiresUpgrade(version) && this.isManaged()) {
                if (version.compareTo(curretVersion) > 0) {
                    ZooKeeperUtils.set((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{this.getId()}), (String)"upgrading");
                } else {
                    ZooKeeperUtils.set((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{this.getId()}), (String)"downgrading");
                }
            }
            ZooKeeperUtils.set((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{this.id}), (String)version.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Profile[] getProfiles() {
        try {
            String version = this.service.getZooKeeper().getStringData(ZkPath.CONFIG_CONTAINER.getPath(new String[]{this.id}));
            String node = ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{version, this.id});
            String str = this.service.getZooKeeper().getStringData(node);
            if (str == null) {
                return new Profile[0];
            }
            ArrayList<ProfileImpl> profiles = new ArrayList<ProfileImpl>();
            for (String p : str.split(" ")) {
                profiles.add(new ProfileImpl(p, version, this.service));
            }
            return profiles.toArray(new Profile[profiles.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setProfiles(Profile[] profiles) {
        try {
            String version = this.service.getZooKeeper().getStringData(ZkPath.CONFIG_CONTAINER.getPath(new String[]{this.id}));
            String node = ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{version, this.id});
            String str = "";
            for (Profile parent : profiles) {
                if (!version.equals(parent.getVersion())) {
                    throw new IllegalArgumentException("Version mismatch setting profile " + parent + " with version " + parent.getVersion() + " expected version " + version);
                }
                if (!str.isEmpty()) {
                    str = str + " ";
                }
                str = str + parent.getId();
            }
            this.service.getZooKeeper().setData(node, str);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public String getLocation() {
        try {
            String path = ZkPath.CONTAINER_LOCATION.getPath(new String[]{this.id});
            if (this.service.getZooKeeper().exists(path) != null) {
                return this.service.getZooKeeper().getStringData(path);
            }
            return "";
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setLocation(String location) {
        try {
            String path = ZkPath.CONTAINER_LOCATION.getPath(new String[]{this.id});
            ZooKeeperUtils.set((IZKClient)this.service.getZooKeeper(), (String)path, (String)location);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public String getResolver() {
        try {
            return this.service.getZooKeeper().getStringData(ZkPath.CONTAINER_RESOLVER.getPath(new String[]{this.id}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setResolver(String resolver) {
        try {
            ZooKeeperUtils.set((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_IP.getPath(new String[]{this.id}), (String)("${zk:" + this.id + "/" + resolver + "}"));
            ZooKeeperUtils.set((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{this.id}), (String)resolver);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public String getIp() {
        try {
            return ZooKeeperUtils.getSubstitutedPath((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_IP.getPath(new String[]{this.id}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public String getLocalIp() {
        try {
            if (this.service.getZooKeeper().exists(ZkPath.CONTAINER_LOCAL_IP.getPath(new String[]{this.id})) == null) {
                return null;
            }
            return this.service.getZooKeeper().getStringData(ZkPath.CONTAINER_LOCAL_IP.getPath(new String[]{this.id}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setLocalIp(String localIp) {
        try {
            ZooKeeperUtils.set((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_LOCAL_IP.getPath(new String[]{this.id}), (String)localIp);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public String getLocalHostname() {
        try {
            if (this.service.getZooKeeper().exists(ZkPath.CONTAINER_LOCAL_HOSTNAME.getPath(new String[]{this.id})) == null) {
                return null;
            }
            return this.service.getZooKeeper().getStringData(ZkPath.CONTAINER_LOCAL_HOSTNAME.getPath(new String[]{this.id}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setLocalHostname(String localHostname) {
        try {
            ZooKeeperUtils.set((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_LOCAL_HOSTNAME.getPath(new String[]{this.id}), (String)localHostname);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public String getPublicIp() {
        try {
            if (this.service.getZooKeeper().exists(ZkPath.CONTAINER_PUBLIC_IP.getPath(new String[]{this.id})) == null) {
                return null;
            }
            return this.service.getZooKeeper().getStringData(ZkPath.CONTAINER_PUBLIC_IP.getPath(new String[]{this.id}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setPublicIp(String publicIp) {
        try {
            ZooKeeperUtils.set((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_PUBLIC_IP.getPath(new String[]{this.id}), (String)publicIp);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public String getPublicHostname() {
        try {
            if (this.service.getZooKeeper().exists(ZkPath.CONTAINER_PUBLIC_HOSTNAME.getPath(new String[]{this.id})) == null) {
                return null;
            }
            return this.service.getZooKeeper().getStringData(ZkPath.CONTAINER_PUBLIC_HOSTNAME.getPath(new String[]{this.id}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setPublicHostname(String publicHostname) {
        try {
            ZooKeeperUtils.set((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_PUBLIC_HOSTNAME.getPath(new String[]{this.id}), (String)publicHostname);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public String getManulIp() {
        try {
            if (this.service.getZooKeeper().exists(ZkPath.CONTAINER_MANUAL_IP.getPath(new String[]{this.id})) == null) {
                return null;
            }
            return this.service.getZooKeeper().getStringData(ZkPath.CONTAINER_MANUAL_IP.getPath(new String[]{this.id}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setManualIp(String manualIp) {
        try {
            ZooKeeperUtils.set((IZKClient)this.service.getZooKeeper(), (String)ZkPath.CONTAINER_MANUAL_IP.getPath(new String[]{this.id}), (String)manualIp);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public BundleInfo[] getBundles(ContainerTemplate containerTemplate) {
        try {
            return containerTemplate.execute(new ContainerTemplate.BundleStateCallback<BundleInfo[]>(){

                @Override
                public BundleInfo[] doWithBundleState(BundleStateMBean bundleState) throws Exception {
                    TabularData bundles = bundleState.listBundles();
                    BundleInfo[] info = new BundleInfo[bundles.size()];
                    int i = 0;
                    for (Object data : bundles.values().toArray()) {
                        info[i++] = new JmxBundleInfo((CompositeData)data);
                    }
                    Arrays.sort(info, new BundleInfoComparator());
                    return info;
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("Error while retrieving bundles. This exception will be ignored.", (Throwable)e);
            return new BundleInfo[0];
        }
    }

    @Override
    public ServiceInfo[] getServices(ContainerTemplate containerTemplate) {
        try {
            return containerTemplate.execute(new ContainerTemplate.ServiceStateCallback<ServiceInfo[]>(){

                @Override
                public ServiceInfo[] doWithServiceState(ServiceStateMBean serviceState) throws Exception {
                    TabularData services = serviceState.listServices();
                    ServiceInfo[] info = new ServiceInfo[services.size()];
                    int i = 0;
                    for (Object data : services.values().toArray()) {
                        CompositeData svc = (CompositeData)data;
                        info[i++] = new JmxServiceInfo(svc, serviceState.getProperties(((Long)svc.get("Identifier")).longValue()));
                    }
                    Arrays.sort(info, new ServiceInfoComparator());
                    return info;
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("Error while retrieving services. This exception will be ignored.", (Throwable)e);
            return new ServiceInfo[0];
        }
    }

    @Override
    public List<String> getJmxDomains() {
        try {
            List list = this.service.getZooKeeper().getChildren(ZkPath.CONTAINER_DOMAINS.getPath(new String[]{this.getId()}));
            Collections.sort(list);
            return Collections.unmodifiableList(list);
        }
        catch (Exception e) {
            this.logger.warn("Error while retrieving jmx domains. This exception will be ignored.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void start() {
        this.service.startContainer(this);
    }

    @Override
    public void stop() {
        this.service.stopContainer(this);
    }

    @Override
    public void destroy() {
        if (this.hasAliveChildren()) {
            throw new IllegalStateException("Container " + this.id + " has one or more child containers alive and cannot be destroyed.");
        }
        this.service.destroyContainer(this);
    }

    @Override
    public Container[] getChildren() {
        ArrayList<Container> children = new ArrayList<Container>();
        for (Container container : this.service.getContainers()) {
            if (container.getParent() == null || !this.getId().equals(container.getParent().getId())) continue;
            children.add(container);
        }
        return children.toArray(new Container[0]);
    }

    @Override
    public String getType() {
        return "karaf";
    }

    @Override
    public String getProvisionResult() {
        return this.getZkData(ZkPath.CONTAINER_PROVISION_RESULT);
    }

    @Override
    public String getProvisionException() {
        return this.getZkData(ZkPath.CONTAINER_PROVISION_EXCEPTION);
    }

    @Override
    public List<String> getProvisionList() {
        String str = this.getZkData(ZkPath.CONTAINER_PROVISION_LIST);
        return str != null ? Arrays.asList(str.split("\n")) : null;
    }

    @Override
    public CreateContainerMetadata<?> getMetadata() {
        try {
            if (this.metadata == null && this.service.getZooKeeper().exists(ZkPath.CONTAINER_METADATA.getPath(new String[]{this.id})) != null) {
                String encoded = this.service.getZooKeeper().getStringData(ZkPath.CONTAINER_METADATA.getPath(new String[]{this.id}));
                byte[] decoded = Base64Encoder.decode(encoded).getBytes(Base64Encoder.base64CharSet);
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decoded));
                this.metadata = (CreateContainerMetadata)ois.readObject();
            }
            return this.metadata;
        }
        catch (Exception e) {
            this.logger.warn("Error while retrieving services. This exception will be ignored.", (Throwable)e);
            return null;
        }
    }

    public void setMetadata(CreateContainerMetadata<?> metadata) {
        this.metadata = metadata;
    }

    private boolean requiresUpgrade(Version version) {
        Boolean requiresUpgrade = false;
        Profile[] oldProfiles = this.getProfiles();
        if (version.compareTo(this.getVersion()) == 0) {
            return false;
        }
        for (int i = 0; i < oldProfiles.length; ++i) {
            Profile newProfile = version.getProfile(oldProfiles[i].getId());
            if (oldProfiles[i].configurationEquals(newProfile)) continue;
            requiresUpgrade = true;
        }
        return requiresUpgrade;
    }

    public boolean hasAliveChildren() {
        for (Container child : this.getChildren()) {
            if (!child.isAlive()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerImpl container = (ContainerImpl)o;
        return !(this.id != null ? !this.id.equals(container.id) : container.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "Container[id=" + this.id + (this.parent != null ? ", parent=" + this.parent.getId() : "") + ']';
    }

    @Override
    public boolean isAliveAndOK() {
        String status = this.getProvisionStatus();
        return this.isAlive() && (status == null || status.length() == 0 || status.toLowerCase().startsWith("success"));
    }
}

