/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.io.Closeable;
import java.io.InputStream;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.language.LanguageEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class LanguageProducer
extends DefaultProducer {
    public LanguageProducer(LanguageEndpoint endpoint) {
        super(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        String script;
        Expression exp = exchange.getIn().getHeader("CamelLanguageScript", Expression.class);
        if (exp == null && (script = exchange.getIn().getHeader("CamelLanguageScript", String.class)) != null) {
            script = this.getEndpoint().resolveScript(script);
            exp = this.getEndpoint().getLanguage().createExpression(script);
        }
        if (exp == null) {
            exp = this.getEndpoint().getExpression();
        }
        if (exp == null) {
            if (this.getEndpoint().getResourceUri() != null) {
                InputStream is = this.getEndpoint().getResourceAsInputStream();
                try {
                    script = this.getEndpoint().getCamelContext().getTypeConverter().convertTo(String.class, is);
                }
                finally {
                    IOHelper.close((Closeable)is);
                }
                exp = this.getEndpoint().getLanguage().createExpression(script);
                if (this.getEndpoint().isContentCache()) {
                    this.getEndpoint().setExpression(exp);
                }
            } else {
                throw new CamelExchangeException("No script to evaluate", exchange);
            }
        }
        ObjectHelper.notNull(exp, "expression");
        Object result = exp.evaluate(exchange, Object.class);
        this.log.debug("Evaluated expression as: {} with: {}", result, (Object)exchange);
        if (this.getEndpoint().isTransform()) {
            if (exchange.hasOut()) {
                exchange.getOut().setBody(result);
            } else {
                exchange.getIn().setBody(result);
            }
        }
    }

    @Override
    public LanguageEndpoint getEndpoint() {
        return (LanguageEndpoint)super.getEndpoint();
    }
}

