/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.NoOutputExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.EvaluateExpressionProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;

@XmlRootElement(name="recipientList")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RecipientListDefinition<Type extends ProcessorDefinition>
extends NoOutputExpressionNode
implements ExecutorServiceAwareDefinition<RecipientListDefinition> {
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String delimiter;
    @XmlAttribute
    private Boolean parallelProcessing;
    @XmlAttribute
    private String strategyRef;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private Boolean stopOnException;
    @XmlAttribute
    private Boolean ignoreInvalidEndpoints;
    @XmlAttribute
    private Boolean streaming;
    @XmlAttribute
    private Long timeout;
    @XmlAttribute
    private String onPrepareRef;
    @XmlTransient
    private Processor onPrepare;
    @XmlAttribute
    private Boolean shareUnitOfWork;

    public RecipientListDefinition() {
    }

    public RecipientListDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    public RecipientListDefinition(Expression expression) {
        super(expression);
    }

    public String toString() {
        return "RecipientList[" + this.getExpression() + "]";
    }

    @Override
    public String getShortName() {
        return "recipientList";
    }

    @Override
    public String getLabel() {
        return "recipientList[" + this.getExpression() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        long timeout;
        final Expression expression = this.getExpression().createExpression(routeContext);
        RecipientList answer = this.delimiter != null ? new RecipientList(routeContext.getCamelContext(), expression, this.delimiter) : new RecipientList(routeContext.getCamelContext(), expression);
        answer.setAggregationStrategy(this.createAggregationStrategy(routeContext));
        answer.setParallelProcessing(this.isParallelProcessing());
        answer.setStreaming(this.isStreaming());
        answer.setShareUnitOfWork(this.isShareUnitOfWork());
        if (this.onPrepareRef != null) {
            this.onPrepare = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.onPrepareRef, Processor.class);
        }
        if (this.onPrepare != null) {
            answer.setOnPrepare(this.onPrepare);
        }
        if (this.stopOnException != null) {
            answer.setStopOnException(this.isStopOnException());
        }
        if (this.ignoreInvalidEndpoints != null) {
            answer.setIgnoreInvalidEndpoints(this.ignoreInvalidEndpoints);
        }
        if (this.getTimeout() != null) {
            answer.setTimeout(this.getTimeout());
        }
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, this, this.isParallelProcessing());
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "RecipientList", this, this.isParallelProcessing());
        answer.setExecutorService(threadPool);
        answer.setShutdownExecutorService(shutdownThreadPool);
        long l = timeout = this.getTimeout() != null ? this.getTimeout() : 0L;
        if (timeout > 0L && !this.isParallelProcessing()) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        ArrayList<AsyncProcessor> pipe = new ArrayList<AsyncProcessor>(2);
        Processor evalProcessor = new EvaluateExpressionProcessor(expression);
        evalProcessor = super.wrapInErrorHandler(routeContext, evalProcessor);
        pipe.add((AsyncProcessor)evalProcessor);
        pipe.add(answer);
        return new Pipeline(routeContext.getCamelContext(), pipe){

            @Override
            public String toString() {
                return "RecipientList[" + expression + "]";
            }
        };
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        if (this.aggregationStrategy == null && this.strategyRef != null) {
            this.aggregationStrategy = routeContext.lookup(this.strategyRef, AggregationStrategy.class);
        }
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = new UseLatestAggregationStrategy();
        }
        return this.aggregationStrategy;
    }

    public Type end() {
        return (Type)super.end();
    }

    public RecipientListDefinition<Type> aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public RecipientListDefinition<Type> aggregationStrategyRef(String aggregationStrategyRef) {
        this.setStrategyRef(aggregationStrategyRef);
        return this;
    }

    public RecipientListDefinition<Type> ignoreInvalidEndpoints() {
        this.setIgnoreInvalidEndpoints(true);
        return this;
    }

    public RecipientListDefinition<Type> parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public RecipientListDefinition<Type> streaming() {
        this.setStreaming(true);
        return this;
    }

    public RecipientListDefinition<Type> stopOnException() {
        this.setStopOnException(true);
        return this;
    }

    @Override
    public RecipientListDefinition<Type> executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public RecipientListDefinition<Type> executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public RecipientListDefinition<Type> onPrepare(Processor onPrepare) {
        this.setOnPrepare(onPrepare);
        return this;
    }

    public RecipientListDefinition<Type> onPrepareRef(String onPrepareRef) {
        this.setOnPrepareRef(onPrepareRef);
        return this;
    }

    public RecipientListDefinition<Type> timeout(long timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public RecipientListDefinition<Type> shareUnitOfWork() {
        this.setShareUnitOfWork(true);
        return this;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Boolean getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(Boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing != null && this.parallelProcessing != false;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean getIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(Boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints != null && this.ignoreInvalidEndpoints != false;
    }

    public Boolean getStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(Boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    public boolean isStopOnException() {
        return this.stopOnException != null && this.stopOnException != false;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Boolean getStreaming() {
        return this.streaming;
    }

    public void setStreaming(Boolean streaming) {
        this.streaming = streaming;
    }

    public boolean isStreaming() {
        return this.streaming != null && this.streaming != false;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String getOnPrepareRef() {
        return this.onPrepareRef;
    }

    public void setOnPrepareRef(String onPrepareRef) {
        this.onPrepareRef = onPrepareRef;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public Boolean getShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(Boolean shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }

    public boolean isShareUnitOfWork() {
        return this.shareUnitOfWork != null && this.shareUnitOfWork != false;
    }
}

