/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;

public class RouteContextProcessor
extends DelegateAsyncProcessor {
    private final RouteContext routeContext;

    public RouteContextProcessor(RouteContext routeContext, Processor processor) {
        super(processor);
        this.routeContext = routeContext;
    }

    @Override
    protected boolean processNext(final Exchange exchange, final AsyncCallback callback) {
        if (exchange.getUnitOfWork() != null) {
            exchange.getUnitOfWork().pushRouteContext(this.routeContext);
        }
        boolean sync = this.processor.process(exchange, new AsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done(boolean doneSync) {
                try {
                    UnitOfWork uow = exchange.getUnitOfWork();
                    if (uow != null) {
                        uow.popRouteContext();
                    }
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
                finally {
                    callback.done(doneSync);
                }
            }
        });
        return sync;
    }

    @Override
    public String toString() {
        return "RouteContextProcessor[" + this.processor + "]";
    }
}

