/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.aries.transaction.TransactionManagerService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ManagedService {
    public static final String PID = "org.apache.aries.transaction";
    private static final Logger log = LoggerFactory.getLogger((String)"org.apache.aries.transaction");
    private BundleContext bundleContext;
    private TransactionManagerService manager;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", PID);
        this.updated(props);
        bundleContext.registerService(ManagedService.class.getName(), (Object)this, props);
    }

    public void stop(BundleContext context) throws Exception {
        this.deleted();
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        this.deleted();
        if (properties != null) {
            this.manager = new TransactionManagerService(PID, properties, this.bundleContext);
            try {
                this.manager.start();
            }
            catch (Exception e) {
                log.error("Error starting transaction manager", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleted() {
        if (this.manager != null) {
            try {
                this.manager.close();
            }
            catch (Exception e) {
                log.error("Error stopping transaction manager", (Throwable)e);
            }
            finally {
                this.manager = null;
            }
        }
    }
}

