/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompoundWordTokenFilterBase
extends TokenFilter {
    public static final int DEFAULT_MIN_WORD_SIZE = 5;
    public static final int DEFAULT_MIN_SUBWORD_SIZE = 2;
    public static final int DEFAULT_MAX_SUBWORD_SIZE = 15;
    protected final CharArraySet dictionary;
    protected final LinkedList<Token> tokens;
    protected final int minWordSize;
    protected final int minSubwordSize;
    protected final int maxSubwordSize;
    protected final boolean onlyLongestMatch;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final FlagsAttribute flagsAtt = this.addAttribute(FlagsAttribute.class);
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final PayloadAttribute payloadAtt = this.addAttribute(PayloadAttribute.class);
    private final Token wrapper = new Token();

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, String[] dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        this(Version.LUCENE_30, input, CompoundWordTokenFilterBase.makeDictionary(dictionary), minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, String[] dictionary, boolean onlyLongestMatch) {
        this(Version.LUCENE_30, input, CompoundWordTokenFilterBase.makeDictionary(dictionary), 5, 2, 15, onlyLongestMatch);
    }

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, Set<?> dictionary, boolean onlyLongestMatch) {
        this(Version.LUCENE_30, input, dictionary, 5, 2, 15, onlyLongestMatch);
    }

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, String[] dictionary) {
        this(Version.LUCENE_30, input, CompoundWordTokenFilterBase.makeDictionary(dictionary), 5, 2, 15, false);
    }

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, Set<?> dictionary) {
        this(Version.LUCENE_30, input, dictionary, 5, 2, 15, false);
    }

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, Set<?> dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        this(Version.LUCENE_30, input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, String[] dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        this(matchVersion, input, CompoundWordTokenFilterBase.makeDictionary(dictionary), minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, String[] dictionary, boolean onlyLongestMatch) {
        this(matchVersion, input, CompoundWordTokenFilterBase.makeDictionary(dictionary), 5, 2, 15, onlyLongestMatch);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, Set<?> dictionary, boolean onlyLongestMatch) {
        this(matchVersion, input, dictionary, 5, 2, 15, onlyLongestMatch);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, String[] dictionary) {
        this(matchVersion, input, CompoundWordTokenFilterBase.makeDictionary(dictionary), 5, 2, 15, false);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, Set<?> dictionary) {
        this(matchVersion, input, dictionary, 5, 2, 15, false);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, Set<?> dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(input);
        this.tokens = new LinkedList();
        this.minWordSize = minWordSize;
        this.minSubwordSize = minSubwordSize;
        this.maxSubwordSize = maxSubwordSize;
        this.onlyLongestMatch = onlyLongestMatch;
        if (dictionary == null || dictionary instanceof CharArraySet) {
            this.dictionary = (CharArraySet)dictionary;
        } else {
            this.dictionary = new CharArraySet(matchVersion, dictionary.size(), false);
            CompoundWordTokenFilterBase.addAllLowerCase(this.dictionary, dictionary);
        }
    }

    public static final Set<?> makeDictionary(String[] dictionary) {
        return CompoundWordTokenFilterBase.makeDictionary(Version.LUCENE_30, dictionary);
    }

    public static final Set<?> makeDictionary(Version matchVersion, String[] dictionary) {
        if (dictionary == null) {
            return null;
        }
        CharArraySet dict = new CharArraySet(matchVersion, dictionary.length, false);
        CompoundWordTokenFilterBase.addAllLowerCase(dict, Arrays.asList(dictionary));
        return dict;
    }

    private final void setToken(Token token) throws IOException {
        this.clearAttributes();
        this.termAtt.copyBuffer(token.buffer(), 0, token.length());
        this.flagsAtt.setFlags(token.getFlags());
        this.typeAtt.setType(token.type());
        this.offsetAtt.setOffset(token.startOffset(), token.endOffset());
        this.posIncAtt.setPositionIncrement(token.getPositionIncrement());
        this.payloadAtt.setPayload(token.getPayload());
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.tokens.size() > 0) {
            this.setToken(this.tokens.removeFirst());
            return true;
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        this.wrapper.copyBuffer(this.termAtt.buffer(), 0, this.termAtt.length());
        this.wrapper.setStartOffset(this.offsetAtt.startOffset());
        this.wrapper.setEndOffset(this.offsetAtt.endOffset());
        this.wrapper.setFlags(this.flagsAtt.getFlags());
        this.wrapper.setType(this.typeAtt.type());
        this.wrapper.setPositionIncrement(this.posIncAtt.getPositionIncrement());
        this.wrapper.setPayload(this.payloadAtt.getPayload());
        this.decompose(this.wrapper);
        if (this.tokens.size() > 0) {
            this.setToken(this.tokens.removeFirst());
            return true;
        }
        return false;
    }

    protected static final void addAllLowerCase(CharArraySet target, Collection<?> col) {
        for (Object obj : col) {
            String string = (String)obj;
            target.add(string.toLowerCase(Locale.ENGLISH));
        }
    }

    protected static char[] makeLowerCaseCopy(char[] buffer) {
        char[] result = new char[buffer.length];
        System.arraycopy(buffer, 0, result, 0, buffer.length);
        for (int i = 0; i < buffer.length; ++i) {
            result[i] = Character.toLowerCase(buffer[i]);
        }
        return result;
    }

    protected final Token createToken(int offset, int length, Token prototype) {
        int newStart = prototype.startOffset() + offset;
        Token t = prototype.clone(prototype.buffer(), offset, length, newStart, newStart + length);
        t.setPositionIncrement(0);
        return t;
    }

    protected void decompose(Token token) {
        this.tokens.add((Token)token.clone());
        if (token.length() < this.minWordSize) {
            return;
        }
        this.decomposeInternal(token);
    }

    protected abstract void decomposeInternal(Token var1);

    @Override
    public void reset() throws IOException {
        super.reset();
        this.tokens.clear();
    }
}

