/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.path;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public class PathHierarchyTokenizer
extends Tokenizer {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final char DEFAULT_DELIMITER = '/';
    private final char delimiter;
    private final char replacement;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posAtt = this.addAttribute(PositionIncrementAttribute.class);
    private int finalOffset = 0;
    private boolean endDelimiter;
    private StringBuilder resultToken;

    public PathHierarchyTokenizer(Reader input) {
        this(input, 1024, '/');
    }

    public PathHierarchyTokenizer(Reader input, int bufferSize, char delimiter) {
        this(input, bufferSize, delimiter, delimiter);
    }

    public PathHierarchyTokenizer(Reader input, char delimiter, char replacement) {
        this(input, 1024, delimiter, replacement);
    }

    public PathHierarchyTokenizer(Reader input, int bufferSize, char delimiter, char replacement) {
        super(input);
        this.termAtt.resizeBuffer(bufferSize);
        this.delimiter = delimiter;
        this.replacement = replacement;
        this.endDelimiter = false;
        this.resultToken = new StringBuilder(bufferSize);
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        this.termAtt.append(this.resultToken);
        if (this.resultToken.length() == 0) {
            this.posAtt.setPositionIncrement(1);
        } else {
            this.posAtt.setPositionIncrement(0);
        }
        int length = 0;
        boolean added = false;
        if (this.endDelimiter) {
            this.termAtt.append(this.replacement);
            ++length;
            this.endDelimiter = false;
            added = true;
        }
        while (true) {
            int c;
            if ((c = this.input.read()) < 0) {
                this.termAtt.setLength(length += this.resultToken.length());
                this.finalOffset = this.correctOffset(length);
                this.offsetAtt.setOffset(this.correctOffset(0), this.finalOffset);
                if (added) {
                    this.resultToken.setLength(0);
                    this.resultToken.append(this.termAtt.buffer(), 0, length);
                }
                return added;
            }
            added = true;
            if (c == this.delimiter) {
                if (length > 0) break;
                this.termAtt.append(this.replacement);
                ++length;
                continue;
            }
            this.termAtt.append((char)c);
            ++length;
        }
        this.endDelimiter = true;
        this.termAtt.setLength(length += this.resultToken.length());
        this.finalOffset = this.correctOffset(length);
        this.offsetAtt.setOffset(this.correctOffset(0), this.finalOffset);
        this.resultToken.setLength(0);
        this.resultToken.append(this.termAtt.buffer(), 0, length);
        return true;
    }

    public final void end() {
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.resultToken.setLength(0);
        this.finalOffset = 0;
        this.endDelimiter = false;
    }
}

