/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.util.ArrayList;
import org.apache.lucene.queryParser.MapperQueryParser;
import org.apache.lucene.queryParser.MultiFieldQueryParserSettings;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.query.xcontent.QueryParseContext;

public class MultiFieldMapperQueryParser
extends MapperQueryParser {
    private MultiFieldQueryParserSettings settings;

    public MultiFieldMapperQueryParser(QueryParseContext parseContext) {
        super(parseContext);
    }

    public MultiFieldMapperQueryParser(MultiFieldQueryParserSettings settings, QueryParseContext parseContext) {
        super(settings, parseContext);
        this.settings = settings;
    }

    public void reset(MultiFieldQueryParserSettings settings) {
        super.reset(settings);
        this.settings = settings;
    }

    @Override
    public Query getFieldQuery(String xField, String queryText, boolean quoted) throws ParseException {
        if (xField != null) {
            return super.getFieldQuery(xField, queryText, quoted);
        }
        if (this.settings.useDisMax()) {
            DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
            boolean added = false;
            for (String field : this.settings.fields()) {
                Query q = super.getFieldQuery(field, queryText, quoted);
                if (q == null) continue;
                added = true;
                this.applyBoost(field, q);
                disMaxQuery.add(q);
            }
            if (!added) {
                return null;
            }
            return disMaxQuery;
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        for (String field : this.settings.fields()) {
            Query q = super.getFieldQuery(field, queryText, true);
            if (q == null) continue;
            this.applyBoost(field, q);
            clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
        }
        if (clauses.size() == 0) {
            return null;
        }
        return this.getBooleanQuery(clauses, true);
    }

    @Override
    public Query getFieldQuery(String xField, String queryText, int slop) throws ParseException {
        if (xField != null) {
            Query q = super.getFieldQuery(xField, queryText, true);
            this.applySlop(q, slop);
            return q;
        }
        if (this.settings.useDisMax()) {
            DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
            boolean added = false;
            for (String field : this.settings.fields()) {
                Query q = super.getFieldQuery(field, queryText, true);
                if (q == null) continue;
                added = true;
                this.applyBoost(field, q);
                this.applySlop(q, slop);
                disMaxQuery.add(q);
            }
            if (!added) {
                return null;
            }
            return disMaxQuery;
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        for (String field : this.settings.fields()) {
            Query q = super.getFieldQuery(field, queryText, true);
            if (q == null) continue;
            this.applyBoost(field, q);
            this.applySlop(q, slop);
            clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
        }
        if (clauses.size() == 0) {
            return null;
        }
        return this.getBooleanQuery(clauses, true);
    }

    @Override
    protected Query getRangeQuery(String xField, String part1, String part2, boolean inclusive) throws ParseException {
        if (xField != null) {
            return super.getRangeQuery(xField, part1, part2, inclusive);
        }
        if (this.settings.useDisMax()) {
            DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
            boolean added = false;
            for (String field : this.settings.fields()) {
                Query q = super.getRangeQuery(field, part1, part2, inclusive);
                if (q == null) continue;
                added = true;
                this.applyBoost(field, q);
                disMaxQuery.add(q);
            }
            if (!added) {
                return null;
            }
            return disMaxQuery;
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        for (String field : this.settings.fields()) {
            Query q = super.getRangeQuery(field, part1, part2, inclusive);
            if (q == null) continue;
            this.applyBoost(field, q);
            clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
        }
        if (clauses.size() == 0) {
            return null;
        }
        return this.getBooleanQuery(clauses, true);
    }

    @Override
    protected Query getPrefixQuery(String xField, String termStr) throws ParseException {
        if (xField != null) {
            return super.getPrefixQuery(xField, termStr);
        }
        if (this.settings.useDisMax()) {
            DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
            boolean added = false;
            for (String field : this.settings.fields()) {
                Query q = super.getPrefixQuery(field, termStr);
                if (q == null) continue;
                added = true;
                this.applyBoost(field, q);
                disMaxQuery.add(q);
            }
            if (!added) {
                return null;
            }
            return disMaxQuery;
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        for (String field : this.settings.fields()) {
            Query q = super.getPrefixQuery(field, termStr);
            if (q == null) continue;
            this.applyBoost(field, q);
            clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
        }
        if (clauses.size() == 0) {
            return null;
        }
        return this.getBooleanQuery(clauses, true);
    }

    @Override
    protected Query getWildcardQuery(String xField, String termStr) throws ParseException {
        if (xField != null) {
            return super.getWildcardQuery(xField, termStr);
        }
        if (this.settings.useDisMax()) {
            DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
            boolean added = false;
            for (String field : this.settings.fields()) {
                Query q = super.getWildcardQuery(field, termStr);
                if (q == null) continue;
                added = true;
                this.applyBoost(field, q);
                disMaxQuery.add(q);
            }
            if (!added) {
                return null;
            }
            return disMaxQuery;
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        for (String field : this.settings.fields()) {
            Query q = super.getWildcardQuery(field, termStr);
            if (q == null) continue;
            this.applyBoost(field, q);
            clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
        }
        if (clauses.size() == 0) {
            return null;
        }
        return this.getBooleanQuery(clauses, true);
    }

    @Override
    protected Query getFuzzyQuery(String xField, String termStr, float minSimilarity) throws ParseException {
        if (xField != null) {
            return super.getFuzzyQuery(xField, termStr, minSimilarity);
        }
        if (this.settings.useDisMax()) {
            DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
            boolean added = false;
            for (String field : this.settings.fields()) {
                Query q = super.getFuzzyQuery(field, termStr, minSimilarity);
                if (q == null) continue;
                added = true;
                this.applyBoost(field, q);
                disMaxQuery.add(q);
            }
            if (!added) {
                return null;
            }
            return disMaxQuery;
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        for (String field : this.settings.fields()) {
            Query q = super.getFuzzyQuery(field, termStr, minSimilarity);
            this.applyBoost(field, q);
            clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
        }
        return this.getBooleanQuery(clauses, true);
    }

    private void applyBoost(String field, Query q) {
        if (this.settings.boosts() != null) {
            float boost = this.settings.boosts().get(field);
            q.setBoost(boost);
        }
    }

    private void applySlop(Query q, int slop) {
        if (q instanceof PhraseQuery) {
            ((PhraseQuery)q).setSlop(slop);
        } else if (q instanceof MultiPhraseQuery) {
            ((MultiPhraseQuery)q).setSlop(slop);
        }
    }
}

