/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.flush;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class ShardFlushRequest
extends BroadcastShardOperationRequest {
    private boolean refresh;
    private boolean full;

    ShardFlushRequest() {
    }

    public ShardFlushRequest(String index, int shardId, FlushRequest request) {
        super(index, shardId);
        this.refresh = request.refresh();
        this.full = request.full();
    }

    public boolean refresh() {
        return this.refresh;
    }

    public boolean full() {
        return this.full;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.refresh = in.readBoolean();
        this.full = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.refresh);
        out.writeBoolean(this.full);
    }
}

