/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.type.TransportSearchCache;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchQueryAndFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchQueryAndFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportSearchCache transportSearchCache, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool, clusterService, transportSearchCache, searchService, searchPhaseController);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<QueryFetchSearchResult> {
        private final Map<SearchShardTarget, QueryFetchSearchResult> queryFetchResults;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(TransportSearchQueryAndFetchAction.this, request, listener);
            this.queryFetchResults = TransportSearchQueryAndFetchAction.this.searchCache.obtainQueryFetchResults();
        }

        @Override
        protected String firstPhaseName() {
            return "query_fetch";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, InternalSearchRequest request, SearchServiceListener<QueryFetchSearchResult> listener) {
            TransportSearchQueryAndFetchAction.this.searchService.sendExecuteFetch(node, request, listener);
        }

        @Override
        protected void processFirstPhaseResult(ShardRouting shard, QueryFetchSearchResult result) {
            this.queryFetchResults.put(result.shardTarget(), result);
        }

        @Override
        protected void moveToSecondPhase() throws Exception {
            this.sortedShardList = TransportSearchQueryAndFetchAction.this.searchPhaseController.sortDocs(this.queryFetchResults.values());
            InternalSearchResponse internalResponse = TransportSearchQueryAndFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.queryFetchResults, this.queryFetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), this.queryFetchResults.values(), null);
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
            TransportSearchQueryAndFetchAction.this.searchCache.releaseQueryFetchResults(this.queryFetchResults);
        }
    }
}

