/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.action.bulk;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.action.delete.DeleteRequestBuilder;
import org.elasticsearch.client.action.index.IndexRequestBuilder;
import org.elasticsearch.client.action.support.BaseRequestBuilder;

public class BulkRequestBuilder
extends BaseRequestBuilder<BulkRequest, BulkResponse> {
    public BulkRequestBuilder(Client client) {
        super(client, new BulkRequest());
    }

    public BulkRequestBuilder add(IndexRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(IndexRequestBuilder request) {
        ((BulkRequest)this.request).add((IndexRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(DeleteRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(DeleteRequestBuilder request) {
        ((BulkRequest)this.request).add((DeleteRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(byte[] data, int from, int length, boolean contentUnsafe) throws Exception {
        ((BulkRequest)this.request).add(data, from, length, contentUnsafe);
        return this;
    }

    public BulkRequestBuilder setReplicationType(ReplicationType replicationType) {
        ((BulkRequest)this.request).replicationType(replicationType);
        return this;
    }

    public BulkRequestBuilder setConsistencyLevel(WriteConsistencyLevel consistencyLevel) {
        ((BulkRequest)this.request).consistencyLevel(consistencyLevel);
        return this;
    }

    public BulkRequestBuilder setRefresh(boolean refresh) {
        ((BulkRequest)this.request).refresh(refresh);
        return this;
    }

    public int numberOfActions() {
        return ((BulkRequest)this.request).numberOfActions();
    }

    @Override
    protected void doExecute(ActionListener<BulkResponse> listener) {
        this.client.bulk((BulkRequest)this.request, listener);
    }
}

