/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class Streamables {
    public static Map<String, Object> readMap(StreamInput in) throws IOException {
        int size = in.readVInt();
        HashMap<String, Object> map = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            map.put(in.readUTF(), Streamables.readMapValue(in));
        }
        return map;
    }

    public static Object readMapValue(StreamInput in) throws IOException {
        byte type = in.readByte();
        if (type == -1) {
            return null;
        }
        if (type == 0) {
            return in.readUTF();
        }
        if (type == 1) {
            return in.readInt();
        }
        if (type == 2) {
            return in.readLong();
        }
        if (type == 3) {
            return Float.valueOf(in.readFloat());
        }
        if (type == 4) {
            return in.readDouble();
        }
        if (type == 5) {
            return in.readBoolean();
        }
        if (type == 6) {
            int bytesSize = in.readVInt();
            byte[] value = new byte[bytesSize];
            in.readFully(value);
            return value;
        }
        if (type == 7) {
            int size = in.readVInt();
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                list.add(Streamables.readMapValue(in));
            }
            return list;
        }
        if (type == 8) {
            int size = in.readVInt();
            Object[] list = new Object[size];
            for (int i = 0; i < size; ++i) {
                list[i] = Streamables.readMapValue(in);
            }
            return list;
        }
        if (type == 9) {
            int size = in.readVInt();
            HashMap<String, Object> map = new HashMap<String, Object>(size);
            for (int i = 0; i < size; ++i) {
                map.put(in.readUTF(), Streamables.readMapValue(in));
            }
            return map;
        }
        throw new IOException("Can't read unknown type [" + type + "]");
    }

    public static void writeMap(StreamOutput out, Map<String, Object> map) throws IOException {
        out.writeVInt(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            out.writeUTF(entry.getKey());
            Streamables.writeMapValue(out, entry.getValue());
        }
    }

    private static void writeMapValue(StreamOutput out, Object value) throws IOException {
        if (value == null) {
            out.writeByte((byte)-1);
            return;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            out.writeByte((byte)0);
            out.writeUTF((String)value);
        } else if (type == Integer.class) {
            out.writeByte((byte)1);
            out.writeInt((Integer)value);
        } else if (type == Long.class) {
            out.writeByte((byte)2);
            out.writeLong((Long)value);
        } else if (type == Float.class) {
            out.writeByte((byte)3);
            out.writeFloat(((Float)value).floatValue());
        } else if (type == Double.class) {
            out.writeByte((byte)4);
            out.writeDouble((Double)value);
        } else if (type == Boolean.class) {
            out.writeByte((byte)5);
            out.writeBoolean((Boolean)value);
        } else if (type == byte[].class) {
            out.writeByte((byte)6);
            out.writeVInt(((byte[])value).length);
            out.writeBytes((byte[])value);
        } else if (value instanceof List) {
            out.writeByte((byte)7);
            List list = (List)value;
            out.writeVInt(list.size());
            for (Object o : list) {
                Streamables.writeMapValue(out, o);
            }
        } else if (value instanceof Object[]) {
            out.writeByte((byte)8);
            Object[] list = (Object[])value;
            out.writeVInt(list.length);
            for (Object o : list) {
                Streamables.writeMapValue(out, o);
            }
        } else if (value instanceof Map) {
            out.writeByte((byte)9);
            Map map = (Map)value;
            out.writeVInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                out.writeUTF((String)entry.getKey());
                Streamables.writeMapValue(out, entry.getValue());
            }
        } else {
            throw new IOException("Can't write type [" + type + "]");
        }
    }
}

