/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.versioned;

import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.common.lucene.versioned.VersionedMap;
import org.elasticsearch.common.util.concurrent.ThreadSafe;

@ThreadSafe
public class ConcurrentVersionedMap
implements VersionedMap {
    private final ConcurrentHashMap<Integer, Integer> map = new ConcurrentHashMap();

    @Override
    public boolean beforeVersion(int key, int versionToCheck) {
        Integer result = this.map.get(key);
        return result == null || versionToCheck < result;
    }

    @Override
    public void putVersion(int key, int version) {
        this.map.put(key, version);
    }

    @Override
    public void putVersionIfAbsent(int key, int version) {
        this.map.putIfAbsent(key, version);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

