/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.templates.res;

import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.templates.TemplateRuntime;
import org.elasticsearch.common.mvel2.templates.res.ExpressionNode;
import org.elasticsearch.common.mvel2.templates.res.Node;
import org.elasticsearch.common.mvel2.templates.util.TemplateOutputStream;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class IfNode
extends Node {
    protected Node trueNode;
    protected Node elseNode;

    public IfNode(int begin, String name, char[] template, int start, int end) {
        super(begin, name, template, start, end);
        while (this.cEnd > this.cStart && ParseTools.isWhitespace(template[this.cEnd])) {
            --this.cEnd;
        }
    }

    public Node getTrueNode() {
        return this.trueNode;
    }

    public void setTrueNode(ExpressionNode trueNode) {
        this.trueNode = trueNode;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public void setElseNode(ExpressionNode elseNode) {
        this.elseNode = elseNode;
    }

    public boolean demarcate(Node terminatingNode, char[] template) {
        this.trueNode = this.next;
        this.next = this.terminus;
        return true;
    }

    public Object eval(TemplateRuntime runtime, TemplateOutputStream appender, Object ctx, VariableResolverFactory factory) {
        if (this.cEnd == this.cStart || MVEL.eval(this.contents, this.cStart, this.cEnd - this.cStart, ctx, factory, Boolean.class).booleanValue()) {
            return this.trueNode.eval(runtime, appender, ctx, factory);
        }
        return this.next != null ? this.next.eval(runtime, appender, ctx, factory) : null;
    }
}

