/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.search.UidFilter;
import org.elasticsearch.index.settings.IndexSettings;

public class IdsQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "ids";

    @Inject
    public IdsQueryParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        ArrayList<String> ids = new ArrayList<String>();
        String type = null;
        String currentFieldName = null;
        float boost = 1.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!"values".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    String value = parser.textOrNull();
                    if (value == null) {
                        throw new QueryParsingException(this.index, "No value specified for term filter");
                    }
                    ids.add(value);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("type".equals(currentFieldName) || "_type".equals(currentFieldName)) {
                type = parser.text();
                continue;
            }
            if (!"boost".equals(currentFieldName)) continue;
            boost = parser.floatValue();
        }
        if (type == null) {
            throw new QueryParsingException(this.index, "[ids] query, no type provided");
        }
        if (ids.size() == 0) {
            throw new QueryParsingException(this.index, "[ids] query, no ids values provided");
        }
        UidFilter filter = new UidFilter(type, ids, parseContext.indexCache().bloomCache());
        ConstantScoreQuery query = new ConstantScoreQuery(filter);
        query.setBoost(boost);
        return query;
    }
}

