/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.iterator.TLongLongIterator;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalDateHistogramFacet;

public class InternalCountDateHistogramFacet
extends InternalDateHistogramFacet {
    private static final String STREAM_TYPE = "cdHistogram";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type, StreamInput in) throws IOException {
            return InternalCountDateHistogramFacet.readHistogramFacet(in);
        }
    };
    private String name;
    private DateHistogramFacet.ComparatorType comparatorType;
    TLongLongHashMap counts;
    boolean cachedCounts;
    CountEntry[] entries = null;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    private InternalCountDateHistogramFacet() {
    }

    public InternalCountDateHistogramFacet(String name, DateHistogramFacet.ComparatorType comparatorType, TLongLongHashMap counts, boolean cachedCounts) {
        this.name = name;
        this.comparatorType = comparatorType;
        this.counts = counts;
        this.cachedCounts = cachedCounts;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String type() {
        return "date_histogram";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<CountEntry> entries() {
        return Arrays.asList(this.computeEntries());
    }

    public List<CountEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<DateHistogramFacet.Entry> iterator() {
        return this.entries().iterator();
    }

    void releaseCache() {
        if (this.cachedCounts) {
            CacheRecycler.pushLongLongMap(this.counts);
            this.cachedCounts = false;
            this.counts = null;
        }
    }

    private CountEntry[] computeEntries() {
        if (this.entries != null) {
            return this.entries;
        }
        this.entries = new CountEntry[this.counts.size()];
        int i = 0;
        TLongLongIterator it = this.counts.iterator();
        while (it.hasNext()) {
            it.advance();
            this.entries[i++] = new CountEntry(it.key(), it.value());
        }
        this.releaseCache();
        Arrays.sort(this.entries, this.comparatorType.comparator());
        return this.entries;
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        TLongLongHashMap counts = CacheRecycler.popLongLongMap();
        for (Facet facet : facets) {
            InternalCountDateHistogramFacet histoFacet = (InternalCountDateHistogramFacet)facet;
            TLongLongIterator it = histoFacet.counts.iterator();
            while (it.hasNext()) {
                it.advance();
                counts.adjustOrPutValue(it.key(), it.value(), it.value());
            }
            histoFacet.releaseCache();
        }
        return new InternalCountDateHistogramFacet(name, this.comparatorType, counts, true);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "histogram");
        builder.startArray(Fields.ENTRIES);
        for (CountEntry entry : this.computeEntries()) {
            builder.startObject();
            builder.field(Fields.TIME, entry.time());
            builder.field(Fields.COUNT, entry.count());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalCountDateHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalCountDateHistogramFacet facet = new InternalCountDateHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = DateHistogramFacet.ComparatorType.fromId(in.readByte());
        int size = in.readVInt();
        this.counts = CacheRecycler.popLongLongMap();
        this.cachedCounts = true;
        for (int i = 0; i < size; ++i) {
            long key = in.readLong();
            this.counts.put(key, in.readVLong());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.counts.size());
        TLongLongIterator it = this.counts.iterator();
        while (it.hasNext()) {
            it.advance();
            out.writeLong(it.key());
            out.writeVLong(it.value());
        }
        this.releaseCache();
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class CountEntry
    implements DateHistogramFacet.Entry {
        private final long time;
        private final long count;

        public CountEntry(long time, long count) {
            this.time = time;
            this.count = count;
        }

        @Override
        public long time() {
            return this.time;
        }

        @Override
        public long getTime() {
            return this.time();
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public long getCount() {
            return this.count();
        }

        @Override
        public long totalCount() {
            return 0L;
        }

        @Override
        public long getTotalCount() {
            return 0L;
        }

        @Override
        public double total() {
            return Double.NaN;
        }

        @Override
        public double getTotal() {
            return this.total();
        }

        @Override
        public double mean() {
            return Double.NaN;
        }

        @Override
        public double getMean() {
            return this.mean();
        }

        @Override
        public double min() {
            return Double.NaN;
        }

        @Override
        public double getMin() {
            return Double.NaN;
        }

        @Override
        public double max() {
            return Double.NaN;
        }

        @Override
        public double getMax() {
            return Double.NaN;
        }
    }
}

