/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.File;
import org.apache.karaf.shell.ssh.KarafSshFile;
import org.apache.sshd.server.FileSystemView;
import org.apache.sshd.server.SshFile;
import org.apache.sshd.server.filesystem.NativeSshFile;

public class KarafFileSystemView
implements FileSystemView {
    private String location = System.getProperty("karaf.base");

    public SshFile getFile(String file) {
        return this.getFile(this.location, file);
    }

    public SshFile getFile(SshFile baseDir, String file) {
        return this.getFile(baseDir.getAbsolutePath(), file);
    }

    protected SshFile getFile(String dir, String file) {
        String physicalName = NativeSshFile.getPhysicalName((String)"/", (String)dir, (String)file, (boolean)false);
        if (!physicalName.startsWith(this.location)) {
            throw new IllegalArgumentException("The path is not relative to KARAF_BASE. For security reason, it's not allowed.");
        }
        File fileObj = new File(physicalName);
        String karafFileName = physicalName.substring("/".length() - 1);
        return new KarafSshFile(karafFileName, fileObj);
    }
}

