/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.security.auth.Subject;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.FilePersistenceManager;
import org.apache.felix.cm.impl.CachingPersistenceManagerProxy;
import org.apache.felix.cm.impl.ConfigurationAdminFactory;
import org.apache.felix.cm.impl.ConfigurationAdminImpl;
import org.apache.felix.cm.impl.ConfigurationBase;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.apache.felix.cm.impl.DynamicBindings;
import org.apache.felix.cm.impl.Factory;
import org.apache.felix.cm.impl.RankingComparator;
import org.apache.felix.cm.impl.UpdateThread;
import org.apache.felix.cm.impl.helper.BaseTracker;
import org.apache.felix.cm.impl.helper.ManagedServiceFactoryTracker;
import org.apache.felix.cm.impl.helper.ManagedServiceTracker;
import org.apache.felix.cm.impl.helper.TargetedPID;
import org.apache.felix.framework.monitor.MonitoringService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPermission;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.cm.SynchronousConfigurationListener;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager
implements BundleActivator,
BundleListener {
    public static final String CM_CONFIG_DIR = "felix.cm.dir";
    public static final String CM_LOG_LEVEL = "felix.cm.loglevel";
    private static final String LOG_SERVICE_NAME = "org.osgi.service.log.LogService";
    private static final int CM_LOG_LEVEL_DEFAULT = 2;
    private static Random numberGenerator;
    BundleContext bundleContext;
    private volatile ServiceRegistration configurationAdminRegistration;
    private ServiceTracker logTracker;
    private ServiceTracker configurationListenerTracker;
    private ServiceTracker syncConfigurationListenerTracker;
    private ManagedServiceTracker managedServiceTracker;
    private ManagedServiceFactoryTracker managedServiceFactoryTracker;
    private ServiceTracker persistenceManagerTracker;
    private UpdateThread updateThread;
    private UpdateThread eventThread;
    private ExecutorServiceFinder executorServiceFinder;
    private PersistenceManager[] persistenceManagers;
    private int pmtCount;
    private final HashMap<String, Factory> factories = new HashMap();
    private final HashMap<String, ConfigurationImpl> configurations = new HashMap();
    private DynamicBindings dynamicBindings;
    private int logLevel = 2;
    private volatile boolean handleBundleEvents;
    private volatile boolean isActive;

    public void start(BundleContext bundleContext) {
        Hashtable<String, Object> props;
        this.logTracker = new ServiceTracker(bundleContext, LOG_SERVICE_NAME, null);
        this.logTracker.open();
        String logLevelProp = bundleContext.getProperty(CM_LOG_LEVEL);
        if (logLevelProp == null) {
            this.logLevel = 2;
        } else {
            try {
                this.logLevel = Integer.parseInt(logLevelProp);
            }
            catch (NumberFormatException nfe) {
                this.logLevel = 2;
            }
        }
        this.bundleContext = bundleContext;
        FelixExecutorServiceFinder finder = null;
        try {
            finder = new FelixExecutorServiceFinder();
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.executorServiceFinder = finder;
        this.configurationListenerTracker = new ServiceTracker(bundleContext, ConfigurationListener.class.getName(), null);
        this.configurationListenerTracker.open();
        this.syncConfigurationListenerTracker = new ServiceTracker(bundleContext, SynchronousConfigurationListener.class.getName(), null);
        this.syncConfigurationListenerTracker.open();
        ThreadGroup tg = this.getThreadGroup();
        this.updateThread = new UpdateThread(this, tg, "CM Configuration Updater");
        this.eventThread = new UpdateThread(this, tg, "CM Event Dispatcher");
        try {
            FilePersistenceManager fpm = new FilePersistenceManager(bundleContext, bundleContext.getProperty(CM_CONFIG_DIR));
            props = new Hashtable<String, Object>();
            props.put("service.pid", fpm.getClass().getName());
            props.put("service.description", "Platform Filesystem Persistence Manager");
            props.put("service.vendor", "Apache Software Foundation");
            props.put("service.ranking", new Integer(Integer.MIN_VALUE));
            bundleContext.registerService(PersistenceManager.class.getName(), (Object)fpm, props);
            this.dynamicBindings = new DynamicBindings(bundleContext, fpm);
        }
        catch (IOException ioe) {
            this.log(1, "Failure setting up dynamic configuration bindings", ioe);
        }
        catch (IllegalArgumentException iae) {
            this.log(1, "Cannot create the FilePersistenceManager", iae);
        }
        this.handleBundleEvents = true;
        bundleContext.addBundleListener((BundleListener)this);
        this.pmtCount = 1;
        this.persistenceManagerTracker = new ServiceTracker(bundleContext, PersistenceManager.class.getName(), null);
        this.persistenceManagerTracker.open();
        this.isActive = true;
        ConfigurationAdminFactory caf = new ConfigurationAdminFactory(this);
        props = new Hashtable();
        props.put("service.pid", "org.apache.felix.cm.ConfigurationAdmin");
        props.put("service.description", "Configuration Admin Service Specification 1.2 Implementation");
        props.put("service.vendor", "Apache Software Foundation");
        this.configurationAdminRegistration = bundleContext.registerService(ConfigurationAdmin.class.getName(), (Object)caf, props);
        this.managedServiceTracker = new ManagedServiceTracker(this);
        this.managedServiceFactoryTracker = new ManagedServiceFactoryTracker(this);
        this.updateThread.start();
        this.eventThread.start();
    }

    private ThreadGroup getThreadGroup() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        if (this.bundleContext.getBundle() == null || !tg.getName().contains(this.bundleContext.getBundle().getSymbolicName())) {
            tg = new ThreadGroup("Configuration Admin Service");
            tg.setDaemon(true);
        }
        return tg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) {
        this.handleBundleEvents = false;
        this.managedServiceFactoryTracker.close();
        this.managedServiceTracker.close();
        if (this.updateThread != null) {
            this.updateThread.terminate();
        }
        if (this.eventThread != null) {
            this.eventThread.terminate();
        }
        if (this.configurationAdminRegistration != null) {
            ServiceRegistration reg = this.configurationAdminRegistration;
            this.configurationAdminRegistration = null;
            reg.unregister();
        }
        this.isActive = false;
        this.persistenceManagerTracker.close();
        bundleContext.removeBundleListener((BundleListener)this);
        if (this.configurationListenerTracker != null) {
            this.configurationListenerTracker.close();
        }
        if (this.syncConfigurationListenerTracker != null) {
            this.syncConfigurationListenerTracker.close();
        }
        if (this.logTracker != null) {
            this.logTracker.close();
        }
        HashMap<String, ConfigurationBase> hashMap = this.configurations;
        synchronized (hashMap) {
            this.configurations.clear();
        }
        hashMap = this.factories;
        synchronized (hashMap) {
            this.factories.clear();
        }
        this.bundleContext = null;
    }

    boolean isActive() {
        return this.isActive;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl getCachedConfiguration(String pid) {
        HashMap<String, ConfigurationImpl> hashMap = this.configurations;
        synchronized (hashMap) {
            return this.configurations.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl[] getCachedConfigurations() {
        HashMap<String, ConfigurationImpl> hashMap = this.configurations;
        synchronized (hashMap) {
            return this.configurations.values().toArray(new ConfigurationImpl[this.configurations.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl cacheConfiguration(ConfigurationImpl configuration) {
        HashMap<String, ConfigurationImpl> hashMap = this.configurations;
        synchronized (hashMap) {
            String pid = configuration.getPidString();
            ConfigurationImpl existing = this.configurations.get(pid);
            if (existing != null) {
                return existing;
            }
            this.configurations.put(pid, configuration);
            return configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConfiguration(ConfigurationImpl configuration) {
        HashMap<String, ConfigurationImpl> hashMap = this.configurations;
        synchronized (hashMap) {
            this.configurations.remove(configuration.getPidString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory getCachedFactory(String factoryPid) {
        HashMap<String, Factory> hashMap = this.factories;
        synchronized (hashMap) {
            return this.factories.get(factoryPid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory[] getCachedFactories() {
        HashMap<String, Factory> hashMap = this.factories;
        synchronized (hashMap) {
            return this.factories.values().toArray(new Factory[this.factories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheFactory(Factory factory) {
        HashMap<String, Factory> hashMap = this.factories;
        synchronized (hashMap) {
            this.factories.put(factory.getFactoryPidString(), factory);
        }
    }

    void setDynamicBundleLocation(String pid, String location) {
        if (this.dynamicBindings != null) {
            try {
                this.dynamicBindings.putLocation(pid, location);
            }
            catch (IOException ioe) {
                this.log(1, "Failed storing dynamic configuration binding for {0} to {1}", new Object[]{pid, location, ioe});
            }
        }
    }

    String getDynamicBundleLocation(String pid) {
        if (this.dynamicBindings != null) {
            return this.dynamicBindings.getLocation(pid);
        }
        return null;
    }

    ConfigurationImpl createFactoryConfiguration(String factoryPid, String location) throws IOException {
        return this.cacheConfiguration(this.createConfiguration(ConfigurationManager.createPid(factoryPid), factoryPid, location));
    }

    ConfigurationImpl getTargetedConfiguration(String rawPid, ServiceReference target) throws IOException {
        Bundle serviceBundle = target.getBundle();
        if (serviceBundle != null) {
            StringBuffer targetedPid = new StringBuffer(rawPid);
            int i = 3;
            String[] names = new String[4];
            names[i--] = targetedPid.toString();
            targetedPid.append('|').append(serviceBundle.getSymbolicName());
            names[i--] = targetedPid.toString();
            targetedPid.append('|').append(TargetedPID.getBundleVersion(serviceBundle));
            names[i--] = targetedPid.toString();
            targetedPid.append('|').append(serviceBundle.getLocation());
            names[i--] = targetedPid.toString();
            for (String candidate : names) {
                ConfigurationImpl config = this.getConfiguration(candidate);
                if (config == null || config.isDeleted()) continue;
                if (this.canReceive(serviceBundle, config.getBundleLocation())) {
                    config.tryBindLocation(serviceBundle.getLocation());
                    return config;
                }
                this.log(4, "Cannot use configuration {0} for {1}: No visibility to configuration bound to {2}; calling with null", new Object[]{config.getPid(), ConfigurationManager.toString(target), config.getBundleLocation()});
            }
        } else {
            this.log(3, "Service for PID {0} seems to already have been unregistered, not updating with configuration", new Object[]{rawPid});
        }
        return null;
    }

    ConfigurationImpl getConfiguration(String pid) throws IOException {
        ConfigurationImpl config = this.getCachedConfiguration(pid);
        if (config != null) {
            this.log(4, "Found cached configuration {0} bound to {1}", new Object[]{pid, config.getBundleLocation()});
            config.ensureFactoryConfigPersisted();
            return config;
        }
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            if (!pmList[i].exists(pid)) continue;
            Dictionary props = pmList[i].load(pid);
            config = new ConfigurationImpl(this, pmList[i], props);
            this.log(4, "Found existing configuration {0} bound to {1}", new Object[]{pid, config.getBundleLocation()});
            return this.cacheConfiguration(config);
        }
        return null;
    }

    ConfigurationImpl createConfiguration(String pid, String bundleLocation) throws IOException {
        ConfigurationImpl config = this.getConfiguration(pid);
        if (config != null) {
            return config;
        }
        config = this.createConfiguration(pid, null, bundleLocation);
        return this.cacheConfiguration(config);
    }

    ConfigurationImpl[] listConfigurations(ConfigurationAdminImpl configurationAdmin, String filterString) throws IOException, InvalidSyntaxException {
        Filter filter = null;
        if (filterString != null) {
            filter = this.bundleContext.createFilter(filterString);
        }
        this.log(4, "Listing configurations matching {0}", new Object[]{filterString});
        ArrayList<ConfigurationImpl> configList = new ArrayList<ConfigurationImpl>();
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            Enumeration configs = pmList[i].getDictionaries();
            while (configs.hasMoreElements()) {
                Dictionary config = (Dictionary)configs.nextElement();
                String pid = (String)config.get("service.pid");
                if (pid == null) continue;
                if (!configurationAdmin.hasPermission((String)config.get("service.bundleLocation"))) {
                    this.log(4, "Omitting configuration {0}: No permission for bundle {1} on configuration bound to {2}", new Object[]{pid, configurationAdmin.getBundle().getLocation(), config.get("service.bundleLocation")});
                    continue;
                }
                if (filter == null || filter.match(config)) {
                    ConfigurationImpl cfg = this.getCachedConfiguration(pid);
                    if (cfg == null) {
                        cfg = new ConfigurationImpl(this, pmList[i], config);
                    }
                    if (!cfg.isNew()) {
                        this.log(4, "Adding configuration {0}", new Object[]{pid});
                        configList.add(cfg);
                        continue;
                    }
                    this.log(4, "Omitting configuration {0}: Is new", new Object[]{pid});
                    continue;
                }
                this.log(4, "Omitting configuration {0}: Does not match filter", new Object[]{pid});
            }
        }
        return configList.toArray(new ConfigurationImpl[configList.size()]);
    }

    void deleted(ConfigurationImpl config) {
        this.removeConfiguration(config);
        this.fireConfigurationEvent(2, config.getPidString(), config.getFactoryPidString());
        this.updateThread.schedule(new DeleteConfiguration(config));
        this.log(4, "DeleteConfiguration({0}) scheduled", new Object[]{config.getPid()});
    }

    void updated(ConfigurationImpl config, boolean fireEvent) {
        if (fireEvent) {
            this.fireConfigurationEvent(1, config.getPidString(), config.getFactoryPidString());
        }
        this.updateThread.schedule(new UpdateConfiguration(config));
        this.log(4, "UpdateConfiguration({0}) scheduled", new Object[]{config.getPid()});
    }

    void locationChanged(ConfigurationImpl config, String oldLocation) {
        this.fireConfigurationEvent(3, config.getPidString(), config.getFactoryPidString());
        if (oldLocation != null && !config.isNew()) {
            this.updateThread.schedule(new LocationChanged(config, oldLocation));
            this.log(4, "LocationChanged({0}, {1}=>{2}) scheduled", new Object[]{config.getPid(), oldLocation, config.getBundleLocation()});
        } else {
            this.log(4, "LocationChanged not scheduled for {0} (old location is null or configuration is new)", new Object[]{config.getPid()});
        }
    }

    void fireConfigurationEvent(int type, String pid, String factoryPid) {
        FireConfigurationEvent asyncSender = new FireConfigurationEvent(this.configurationListenerTracker, type, pid, factoryPid);
        FireConfigurationEvent syncSender = new FireConfigurationEvent(this.syncConfigurationListenerTracker, type, pid, factoryPid);
        if (syncSender.hasConfigurationEventListeners()) {
            syncSender.run();
        } else {
            this.log(4, "No SynchronousConfigurationListeners to send {0} event to.", new Object[]{syncSender.getTypeName()});
        }
        if (asyncSender.hasConfigurationEventListeners()) {
            this.eventThread.schedule(asyncSender);
        } else {
            this.log(4, "No ConfigurationListeners to send {0} event to.", new Object[]{asyncSender.getTypeName()});
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16 && this.handleBundleEvents) {
            String location = event.getBundle().getLocation();
            ConfigurationImpl[] configs = this.getCachedConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                ConfigurationImpl cfg = configs[i];
                if (!location.equals(cfg.getDynamicBundleLocation())) continue;
                cfg.setDynamicBundleLocation(null, true);
            }
        }
    }

    private PersistenceManager[] getPersistenceManagers() {
        int currentPmtCount = this.persistenceManagerTracker.getTrackingCount();
        if (this.persistenceManagers == null || currentPmtCount > this.pmtCount) {
            PersistenceManager[] pm;
            ArrayList<CachingPersistenceManagerProxy> pmList = new ArrayList<CachingPersistenceManagerProxy>();
            ServiceReference<S>[] refs = this.persistenceManagerTracker.getServiceReferences();
            if (refs == null || refs.length == 0) {
                pm = new PersistenceManager[]{};
            } else {
                if (refs.length > 1) {
                    Arrays.sort(refs, RankingComparator.SRV_RANKING);
                }
                for (int i = 0; i < refs.length; ++i) {
                    Object service = this.persistenceManagerTracker.getService(refs[i]);
                    if (service == null) continue;
                    pmList.add(new CachingPersistenceManagerProxy((PersistenceManager)service));
                }
                pm = pmList.toArray(new PersistenceManager[pmList.size()]);
            }
            this.pmtCount = pm.length;
            this.persistenceManagers = pm;
        }
        return this.persistenceManagers;
    }

    private ServiceReference getServiceReference() {
        ServiceRegistration reg = this.configurationAdminRegistration;
        if (reg != null) {
            return reg.getReference();
        }
        BundleContext context = this.bundleContext;
        if (context != null) {
            try {
                ServiceReference[] refs = context.getServiceReferences(ConfigurationAdmin.class.getName(), null);
                if (refs != null) {
                    for (int i = 0; i < refs.length; ++i) {
                        if (refs[i].getBundle().getBundleId() != context.getBundle().getBundleId()) continue;
                        return refs[i];
                    }
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public void configure(String[] pid, ServiceReference sr, boolean factory) {
        if (this.isLogEnabled(4)) {
            this.log(4, "configure(ManagedService {0})", new Object[]{ConfigurationManager.toString(sr)});
        }
        Runnable r = factory ? new ManagedServiceFactoryUpdate(pid, sr) : new ManagedServiceUpdate(pid, sr);
        this.updateThread.schedule(r);
        this.log(4, "[{0}] scheduled", new Object[]{r});
    }

    ConfigurationImpl createConfiguration(String pid, String factoryPid, String bundleLocation) throws IOException {
        this.log(4, "createConfiguration({0}, {1}, {2})", new Object[]{pid, factoryPid, bundleLocation});
        return new ConfigurationImpl(this, this.getPersistenceManagers()[0], pid, factoryPid, bundleLocation);
    }

    List<Factory> getTargetedFactories(String rawFactoryPid, ServiceReference target) throws IOException {
        LinkedList<Factory> factories = new LinkedList<Factory>();
        Bundle serviceBundle = target.getBundle();
        if (serviceBundle != null) {
            StringBuffer targetedPid = new StringBuffer(rawFactoryPid);
            factories.add(this.getOrCreateFactory(targetedPid.toString()));
            targetedPid.append('|').append(serviceBundle.getSymbolicName());
            Factory f = this.getFactory(targetedPid.toString());
            if (f != null) {
                factories.add(0, f);
            }
            targetedPid.append('|').append(TargetedPID.getBundleVersion(serviceBundle));
            f = this.getFactory(targetedPid.toString());
            if (f != null) {
                factories.add(0, f);
            }
            targetedPid.append('|').append(serviceBundle.getLocation());
            f = this.getFactory(targetedPid.toString());
            if (f != null) {
                factories.add(0, f);
            }
        }
        return factories;
    }

    Factory getOrCreateFactory(String factoryPid) throws IOException {
        Factory factory = this.getFactory(factoryPid);
        if (factory != null) {
            return factory;
        }
        return this.createFactory(factoryPid);
    }

    Factory getFactory(String factoryPid) throws IOException {
        Factory factory = this.getCachedFactory(factoryPid);
        if (factory != null) {
            return factory;
        }
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            if (!Factory.exists(pmList[i], factoryPid)) continue;
            factory = Factory.load(this, pmList[i], factoryPid);
            this.cacheFactory(factory);
            return factory;
        }
        return null;
    }

    Factory createFactory(String factoryPid) {
        Factory factory = new Factory(this, this.getPersistenceManagers()[0], factoryPid);
        this.cacheFactory(factory);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callPlugins(Dictionary props, ServiceReference sr, String configPid, String factoryPid) {
        ServiceReference[] plugins = null;
        try {
            String targetPid = factoryPid == null ? configPid : factoryPid;
            String filter = "(|(!(cm.target=*))(cm.target=" + targetPid + "))";
            plugins = this.bundleContext.getServiceReferences(ConfigurationPlugin.class.getName(), filter);
        }
        catch (InvalidSyntaxException ise) {
            // empty catch block
        }
        if (plugins == null || plugins.length == 0) {
            return;
        }
        if (plugins.length > 1) {
            Arrays.sort(plugins, RankingComparator.CM_RANKING);
        }
        for (int i = 0; i < plugins.length; ++i) {
            void pluginRef = plugins[i];
            ConfigurationPlugin plugin = (ConfigurationPlugin)this.bundleContext.getService((ServiceReference)pluginRef);
            if (plugin == null) continue;
            try {
                plugin.modifyConfiguration(sr, props);
            }
            catch (Throwable t) {
                this.log(1, "Unexpected problem calling configuration plugin {0}", new Object[]{ConfigurationManager.toString((ServiceReference)pluginRef), t});
            }
            finally {
                this.bundleContext.ungetService((ServiceReference)pluginRef);
            }
            ConfigurationImpl.setAutoProperties(props, configPid, factoryPid);
        }
    }

    private static String createPid(String factoryPid) {
        Random ng = numberGenerator;
        if (ng == null) {
            try {
                ng = new SecureRandom();
            }
            catch (Throwable t) {
                ng = new Random();
            }
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        StringBuffer buf = new StringBuffer(factoryPid.length() + 1 + 36);
        buf.append(factoryPid).append(".");
        for (int i = 0; i < randomBytes.length; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                buf.append('-');
            }
            int val = randomBytes[i] & 0xFF;
            buf.append(Integer.toHexString(val >> 4));
            buf.append(Integer.toHexString(val & 0xF));
        }
        return buf.toString();
    }

    public boolean isLogEnabled(int level) {
        return level <= this.logLevel;
    }

    public void log(int level, String format, Object[] args) {
        if (this.isLogEnabled(level)) {
            Throwable throwable = null;
            String message = format;
            if (args != null && args.length > 0) {
                if (args[args.length - 1] instanceof Throwable) {
                    throwable = (Throwable)args[args.length - 1];
                }
                message = MessageFormat.format(format, args);
            }
            this.log(level, message, throwable);
        }
    }

    public void log(int level, String message, Throwable t) {
        Object log = this.logTracker.getService();
        if (log != null) {
            ((LogService)log).log(this.getServiceReference(), level, message, t);
            return;
        }
        if (this.isLogEnabled(level)) {
            String code;
            switch (level) {
                case 3: {
                    code = "*INFO *";
                    break;
                }
                case 2: {
                    code = "*WARN *";
                    break;
                }
                case 1: {
                    code = "*ERROR*";
                    break;
                }
                default: {
                    code = "*DEBUG*";
                }
            }
            System.err.println(code + " " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    public static String toString(ServiceReference ref) {
        String[] ocs = (String[])ref.getProperty("objectClass");
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < ocs.length; ++i) {
            buf.append(ocs[i]);
            if (i >= ocs.length - 1) continue;
            buf.append(", ");
        }
        buf.append(", id=").append(ref.getProperty("service.id"));
        Bundle provider = ref.getBundle();
        if (provider != null) {
            buf.append(", bundle=").append(provider.getBundleId());
            buf.append('/').append(provider.getLocation());
        } else {
            buf.append(", unregistered");
        }
        buf.append("]");
        return buf.toString();
    }

    boolean canReceive(Bundle bundle, String location) {
        if (location == null) {
            this.log(4, "canReceive=true; bundle={0}; configuration=(unbound)", new Object[]{bundle.getLocation()});
            return true;
        }
        if (location.startsWith("?")) {
            if (System.getSecurityManager() != null) {
                boolean hasPermission = bundle.hasPermission((Object)new ConfigurationPermission(location, "target"));
                this.log(4, "canReceive={0}: bundle={1}; configuration={2} (SecurityManager check)", new Object[]{new Boolean(hasPermission), bundle.getLocation(), location});
                return hasPermission;
            }
            this.log(4, "canReceive=true; bundle={0}; configuration={1} (no SecurityManager)", new Object[]{bundle.getLocation(), location});
            return true;
        }
        boolean hasPermission = location.equals(bundle.getLocation());
        this.log(4, "canReceive={0}: bundle={1}; configuration={2}", new Object[]{new Boolean(hasPermission), bundle.getLocation(), location});
        return hasPermission;
    }

    void callManagedService(Bundle bundle, final ManagedService srv, final Dictionary props) throws Exception {
        if (this.executorServiceFinder == null) {
            srv.updated(props);
        } else {
            this.executorServiceFinder.find(bundle).submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    srv.updated(props);
                    return null;
                }
            }).get();
        }
    }

    void callManagedServiceFactoryUpdated(Bundle bundle, final ManagedServiceFactory srv, final String pid, final Dictionary props) throws Exception {
        if (this.executorServiceFinder == null) {
            srv.updated(pid, props);
        } else {
            this.executorServiceFinder.find(bundle).submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    srv.updated(pid, props);
                    return null;
                }
            }).get();
        }
    }

    void callManagedServiceFactoryDeleted(Bundle bundle, final ManagedServiceFactory srv, final String pid) throws Exception {
        if (this.executorServiceFinder == null) {
            srv.deleted(pid);
        } else {
            this.executorServiceFinder.find(bundle).submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    srv.deleted(pid);
                    return null;
                }
            }).get();
        }
    }

    private class FireConfigurationEvent
    implements Runnable {
        private final int type;
        private final String pid;
        private final String factoryPid;
        private final ServiceReference[] listenerReferences;
        private final ConfigurationListener[] listeners;
        private final Bundle[] listenerProvider;
        private final Subject subject;
        private ConfigurationEvent event;

        private FireConfigurationEvent(ServiceTracker listenerTracker, int type, String pid, String factoryPid) {
            this.type = type;
            this.pid = pid;
            this.factoryPid = factoryPid;
            this.subject = Subject.getSubject(AccessController.getContext());
            ServiceReference<S>[] srs = listenerTracker.getServiceReferences();
            if (srs == null || srs.length == 0) {
                this.listenerReferences = null;
                this.listeners = null;
                this.listenerProvider = null;
            } else {
                this.listenerReferences = srs;
                this.listeners = new ConfigurationListener[srs.length];
                this.listenerProvider = new Bundle[srs.length];
                for (int i = 0; i < srs.length; ++i) {
                    this.listeners[i] = (ConfigurationListener)listenerTracker.getService(srs[i]);
                    this.listenerProvider[i] = srs[i].getBundle();
                }
            }
        }

        boolean hasConfigurationEventListeners() {
            return this.listenerReferences != null;
        }

        String getTypeName() {
            switch (this.type) {
                case 2: {
                    return "CM_DELETED";
                }
                case 1: {
                    return "CM_UPDATED";
                }
                case 3: {
                    return "CM_LOCATION_CHANGED";
                }
            }
            return "<UNKNOWN(" + this.type + ")>";
        }

        public void run() {
            if (this.subject != null) {
                Subject.doAs(this.subject, new PrivilegedAction(){

                    public Object run() {
                        FireConfigurationEvent.this.doRun();
                        return null;
                    }
                });
            } else {
                this.doRun();
            }
        }

        private void doRun() {
            String typeName = this.getTypeName();
            ConfigurationEvent event = new ConfigurationEvent((ServiceReference<ConfigurationAdmin>)ConfigurationManager.this.getServiceReference(), this.type, this.factoryPid, this.pid);
            for (int i = 0; i < this.listeners.length; ++i) {
                this.sendEvent(i);
            }
        }

        public String toString() {
            return "Fire ConfigurationEvent: pid=" + this.pid;
        }

        private ConfigurationEvent getConfigurationEvent() {
            if (this.event == null) {
                this.event = new ConfigurationEvent((ServiceReference<ConfigurationAdmin>)ConfigurationManager.this.getServiceReference(), this.type, this.factoryPid, this.pid);
            }
            return this.event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendEvent(int serviceIndex) {
            if (this.listenerProvider[serviceIndex].getState() == 32 && this.listeners[serviceIndex] != null) {
                ConfigurationManager.this.log(4, "Sending {0} event for {1} to {2}", new Object[]{this.getTypeName(), this.pid, ConfigurationManager.toString(this.listenerReferences[serviceIndex])});
                try {
                    this.listeners[serviceIndex].configurationEvent(this.getConfigurationEvent());
                }
                catch (Throwable t) {
                    ConfigurationManager.this.log(1, "Unexpected problem delivering configuration event to {0}", new Object[]{ConfigurationManager.toString(this.listenerReferences[serviceIndex]), t});
                }
                finally {
                    this.listeners[serviceIndex] = null;
                }
            }
        }
    }

    private class LocationChanged
    extends ConfigurationProvider {
        private final String oldLocation;

        LocationChanged(ConfigurationImpl config, String oldLocation) {
            super(config);
            this.oldLocation = oldLocation;
        }

        public void run() {
            List srList = this.helper.getServices(this.getTargetedServicePid());
            if (!srList.isEmpty()) {
                for (ServiceReference sr : srList) {
                    Bundle srBundle = sr.getBundle();
                    if (srBundle == null) {
                        ConfigurationManager.this.log(4, "Service {0} seems to be unregistered concurrently (not processing)", new Object[]{ConfigurationManager.toString(sr)});
                        continue;
                    }
                    boolean wasVisible = ConfigurationManager.this.canReceive(srBundle, this.oldLocation);
                    boolean isVisible = ConfigurationManager.this.canReceive(srBundle, this.config.getBundleLocation());
                    if (isVisible) {
                        this.config.tryBindLocation(srBundle.getLocation());
                    }
                    if (wasVisible && !isVisible) {
                        if (this.provideReplacement(sr)) continue;
                        this.helper.removeConfiguration(sr, this.config.getPid(), this.config.getFactoryPid());
                        ConfigurationManager.this.log(4, "Configuration {0} revoked from {1} (no more visibility)", new Object[]{this.config.getPid(), ConfigurationManager.toString(sr)});
                        continue;
                    }
                    if (!wasVisible && isVisible) {
                        this.helper.provideConfiguration(sr, this.config.getPid(), this.config.getFactoryPid(), this.properties, this.revision);
                        ConfigurationManager.this.log(4, "Configuration {0} provided to {1} (new visibility)", new Object[]{this.config.getPid(), ConfigurationManager.toString(sr)});
                        continue;
                    }
                    ConfigurationManager.this.log(4, "Unmodified visibility to configuration {0} for {1}", new Object[]{this.config.getPid(), ConfigurationManager.toString(sr)});
                }
            }
        }

        public String toString() {
            return "Location Changed (pid=" + this.config.getPid() + "): " + this.oldLocation + " ==> " + this.config.getBundleLocation();
        }
    }

    private class DeleteConfiguration
    extends ConfigurationProvider {
        private final String configLocation;

        DeleteConfiguration(ConfigurationImpl config) {
            super(config);
            this.configLocation = config.getBundleLocation();
        }

        public void run() {
            TargetedPID factoryPid;
            List srList = this.helper.getServices(this.getTargetedServicePid());
            if (!srList.isEmpty()) {
                for (ServiceReference sr : srList) {
                    Bundle srBundle = sr.getBundle();
                    if (srBundle == null) {
                        ConfigurationManager.this.log(4, "Service {0} seems to be unregistered concurrently (not removing configuration)", new Object[]{ConfigurationManager.toString(sr)});
                        continue;
                    }
                    if (ConfigurationManager.this.canReceive(srBundle, this.configLocation)) {
                        if (this.provideReplacement(sr)) continue;
                        this.helper.removeConfiguration(sr, this.config.getPid(), this.config.getFactoryPid());
                        continue;
                    }
                    ConfigurationManager.this.log(1, "Cannot remove configuration {0} for {1}: No visibility to configuration bound to {2}", new Object[]{this.config.getPid(), ConfigurationManager.toString(sr), this.configLocation});
                }
            }
            if ((factoryPid = this.config.getFactoryPid()) != null) {
                String pid = this.config.getPidString();
                try {
                    Factory factory = ConfigurationManager.this.getOrCreateFactory(factoryPid.toString());
                    factory.removePID(pid);
                    factory.store();
                }
                catch (IOException ioe) {
                    ConfigurationManager.this.log(1, "Failed removing {0} from the factory {1}", new Object[]{pid, factoryPid, ioe});
                }
            }
        }

        public String toString() {
            return "Delete: pid=" + this.config.getPid();
        }
    }

    class FelixExecutorServiceFinder
    implements ExecutorServiceFinder {
        ServiceReference sr;

        FelixExecutorServiceFinder() {
            this.sr = ConfigurationManager.this.bundleContext.getServiceReference(MonitoringService.class.getName());
            if (this.sr == null) {
                throw new UnsupportedOperationException();
            }
        }

        public ExecutorService find(Bundle bundle) {
            return ((MonitoringService)ConfigurationManager.this.bundleContext.getService(this.sr)).getExecutor(bundle);
        }
    }

    static interface ExecutorServiceFinder {
        public ExecutorService find(Bundle var1);
    }

    private class UpdateConfiguration
    extends ConfigurationProvider {
        UpdateConfiguration(ConfigurationImpl config) {
            super(config);
        }

        public void run() {
            ConfigurationManager.this.log(4, "Updating configuration {0} to revision #{1}", new Object[]{this.config.getPid(), new Long(this.revision)});
            List srList = this.helper.getServices(this.getTargetedServicePid());
            if (!srList.isEmpty()) {
                this.config.tryBindLocation(srList.get(0).getBundle().getLocation());
                String configBundleLocation = this.config.getBundleLocation();
                for (ServiceReference ref : srList) {
                    Bundle refBundle = ref.getBundle();
                    if (refBundle == null) {
                        ConfigurationManager.this.log(4, "Service {0} seems to be unregistered concurrently (not providing configuration)", new Object[]{ConfigurationManager.toString(ref)});
                        continue;
                    }
                    if (ConfigurationManager.this.canReceive(refBundle, configBundleLocation)) {
                        this.helper.provideConfiguration(ref, this.config.getPid(), this.config.getFactoryPid(), this.properties, this.revision);
                        continue;
                    }
                    ConfigurationManager.this.log(1, "Cannot use configuration {0} for {1}: No visibility to configuration bound to {2}", new Object[]{this.config.getPid(), ConfigurationManager.toString(ref), configBundleLocation});
                }
            } else if (ConfigurationManager.this.isLogEnabled(4)) {
                ConfigurationManager.this.log(4, "No ManagedService[Factory] registered for updates to configuration {0}", new Object[]{this.config.getPid()});
            }
        }

        public String toString() {
            return "Update: pid=" + this.config.getPid();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ConfigurationProvider<T>
    implements Runnable {
        protected final ConfigurationImpl config;
        protected final long revision;
        protected final Dictionary<String, ?> properties;
        protected final BaseTracker<T> helper;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ConfigurationProvider(ConfigurationImpl config) {
            ConfigurationImpl configurationImpl = config;
            synchronized (configurationImpl) {
                this.config = config;
                this.revision = config.getRevision();
                this.properties = config.getProperties(true);
            }
            this.helper = config.getFactoryPid() == null ? ConfigurationManager.this.managedServiceTracker : ConfigurationManager.this.managedServiceFactoryTracker;
        }

        protected TargetedPID getTargetedServicePid() {
            TargetedPID factoryPid = this.config.getFactoryPid();
            if (factoryPid != null) {
                return factoryPid;
            }
            return this.config.getPid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean provideReplacement(ServiceReference<T> sr) {
            block7: {
                if (this.config.getFactoryPid() == null) {
                    try {
                        long revision;
                        Dictionary properties;
                        TargetedPID configPid;
                        String configPidString = this.helper.getServicePid(sr, this.config.getPid());
                        ConfigurationImpl rc = ConfigurationManager.this.getTargetedConfiguration(configPidString, sr);
                        if (rc == null) break block7;
                        ConfigurationImpl configurationImpl = rc;
                        synchronized (configurationImpl) {
                            configPid = rc.getPid();
                            properties = rc.getProperties(true);
                            revision = rc.getRevision();
                        }
                        this.helper.provideConfiguration(sr, configPid, null, properties, -revision);
                        return true;
                    }
                    catch (IOException ioe) {
                        ConfigurationManager.this.log(1, "Error loading configuration for {0}", new Object[]{this.config.getPid(), ioe});
                    }
                    catch (Exception e) {
                        ConfigurationManager.this.log(1, "Unexpected problem providing configuration {0} to service {1}", new Object[]{this.config.getPid(), ConfigurationManager.toString(sr), e});
                    }
                }
            }
            return false;
        }
    }

    private class ManagedServiceFactoryUpdate
    implements Runnable {
        private final String[] factoryPids;
        private final ServiceReference sr;

        ManagedServiceFactoryUpdate(String[] factoryPids, ServiceReference sr) {
            this.factoryPids = factoryPids;
            this.sr = sr;
        }

        public void run() {
            for (String factoryPid : this.factoryPids) {
                List<Factory> factories = null;
                try {
                    factories = ConfigurationManager.this.getTargetedFactories(factoryPid, this.sr);
                    for (Factory factory : factories) {
                        for (String pid : factory.getPIDs()) {
                            ConfigurationImpl cfg;
                            try {
                                cfg = ConfigurationManager.this.getConfiguration(pid);
                            }
                            catch (IOException ioe) {
                                ConfigurationManager.this.log(1, "Error loading configuration for {0}", new Object[]{pid, ioe});
                                continue;
                            }
                            if (cfg == null) {
                                ConfigurationManager.this.log(1, "Configuration {0} referred to by factory {1} does not exist", new Object[]{pid, factoryPid});
                                factory.removePID(pid);
                                factory.storeSilently();
                                continue;
                            }
                            if (cfg.isNew()) {
                                ConfigurationManager.this.log(1, "Ignoring new configuration pid={0}", new Object[]{pid});
                                continue;
                            }
                            this.provide(factoryPid, cfg);
                        }
                    }
                }
                catch (IOException ioe) {
                    ConfigurationManager.this.log(1, "Cannot get factory mapping for factory PID {0}", new Object[]{factoryPid, ioe});
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void provide(String factoryPid, ConfigurationImpl config) {
            long revision;
            Dictionary rawProperties;
            ConfigurationImpl configurationImpl = config;
            synchronized (configurationImpl) {
                rawProperties = config.getProperties(true);
                revision = config.getRevision();
            }
            ConfigurationManager.this.log(4, "Updating service {0} with configuration {1}/{2}@{3}", new Object[]{factoryPid, config.getFactoryPid(), config.getPid(), new Long(revision)});
            Bundle serviceBundle = this.sr.getBundle();
            if (serviceBundle == null) {
                ConfigurationManager.this.log(3, "ManagedServiceFactory for factory PID {0} seems to already have been unregistered, not updating with factory", new Object[]{factoryPid});
                return;
            }
            if (!ConfigurationManager.this.canReceive(serviceBundle, config.getBundleLocation())) {
                ConfigurationManager.this.log(1, "Cannot use configuration {0} for {1}: No visibility to configuration bound to {2}", new Object[]{config.getPid(), ConfigurationManager.toString(this.sr), config.getBundleLocation()});
                return;
            }
            config.tryBindLocation(serviceBundle.getLocation());
            if (rawProperties != null) {
                ConfigurationManager.this.log(4, "{0}: Updating configuration pid={1}", new Object[]{ConfigurationManager.toString(this.sr), config.getPid()});
                ConfigurationManager.this.managedServiceFactoryTracker.provideConfiguration((ServiceReference<ManagedServiceFactory>)this.sr, config.getPid(), config.getFactoryPid(), (Dictionary<String, ?>)rawProperties, revision);
            }
        }

        public String toString() {
            return "ManagedServiceFactory Update: factoryPid=" + Arrays.asList(this.factoryPids);
        }
    }

    private class ManagedServiceUpdate
    implements Runnable {
        private final String[] pids;
        private final ServiceReference sr;

        ManagedServiceUpdate(String[] pids, ServiceReference sr) {
            this.pids = pids;
            this.sr = sr;
        }

        public void run() {
            for (String pid : this.pids) {
                try {
                    ConfigurationImpl config = ConfigurationManager.this.getTargetedConfiguration(pid, this.sr);
                    this.provide(pid, config);
                }
                catch (IOException ioe) {
                    ConfigurationManager.this.log(1, "Error loading configuration for {0}", new Object[]{pid, ioe});
                }
                catch (Exception e) {
                    ConfigurationManager.this.log(1, "Unexpected problem providing configuration {0} to service {1}", new Object[]{pid, ConfigurationManager.toString(this.sr), e});
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void provide(String servicePid, ConfigurationImpl config) {
            long revision;
            Dictionary properties;
            TargetedPID configPid;
            if (config != null) {
                ConfigurationImpl configurationImpl = config;
                synchronized (configurationImpl) {
                    configPid = config.getPid();
                    properties = config.getProperties(true);
                    revision = config.getRevision();
                }
            } else {
                configPid = new TargetedPID(servicePid);
                properties = null;
                revision = -1L;
            }
            ConfigurationManager.this.log(4, "Updating service {0} with configuration {1}@{2}", new Object[]{servicePid, configPid, new Long(revision)});
            ConfigurationManager.this.managedServiceTracker.provideConfiguration((ServiceReference<ManagedService>)this.sr, configPid, (TargetedPID)null, (Dictionary<String, ?>)properties, revision);
        }

        public String toString() {
            return "ManagedService Update: pid=" + Arrays.asList(this.pids);
        }
    }
}

