/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.helper;

import java.util.Dictionary;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.helper.BaseTracker;
import org.apache.felix.cm.impl.helper.ConfigurationMap;
import org.apache.felix.cm.impl.helper.ManagedServiceFactoryConfigurationMap;
import org.apache.felix.cm.impl.helper.TargetedPID;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedServiceFactoryTracker
extends BaseTracker<ManagedServiceFactory> {
    public ManagedServiceFactoryTracker(ConfigurationManager cm) {
        super(cm, true);
    }

    @Override
    protected ConfigurationMap<?> createConfigurationMap(String[] pids) {
        return new ManagedServiceFactoryConfigurationMap(pids);
    }

    @Override
    public String getServicePid(ServiceReference<ManagedServiceFactory> service, TargetedPID pid) {
        return pid.getRawPid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void provideConfiguration(ServiceReference<ManagedServiceFactory> reference, TargetedPID configPid, TargetedPID factoryPid, Dictionary<String, ?> properties, long revision) {
        ManagedServiceFactory service = this.getRealService(reference);
        ConfigurationMap configs = (ConfigurationMap)this.getService(reference);
        if (service != null && configs != null && configs.shallTake(configPid, factoryPid, revision)) {
            try {
                Dictionary props = this.getProperties(properties, reference, configPid.toString(), factoryPid.toString());
                service.updated(configPid.toString(), props);
                configs.record(configPid, factoryPid, revision);
            }
            catch (Throwable t) {
                this.handleCallBackError(t, reference, configPid);
            }
            finally {
                this.ungetRealService(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfiguration(ServiceReference<ManagedServiceFactory> reference, TargetedPID configPid, TargetedPID factoryPid) {
        ManagedServiceFactory service = this.getRealService(reference);
        ConfigurationMap configs = (ConfigurationMap)this.getService(reference);
        if (service != null && configs != null && configs.removeConfiguration(configPid, factoryPid)) {
            try {
                service.deleted(configPid.toString());
                configs.record(configPid, factoryPid, -1L);
            }
            catch (Throwable t) {
                this.handleCallBackError(t, reference, configPid);
            }
            finally {
                this.ungetRealService(reference);
            }
        }
    }
}

