/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.aries.proxy.InvocationListener;
import org.apache.aries.proxy.ProxyManager;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.AbstractProxyManager;
import org.apache.aries.proxy.impl.ProxyHandler;
import org.apache.aries.proxy.impl.gen.ProxySubclassGenerator;
import org.apache.aries.proxy.impl.interfaces.InterfaceProxyGenerator;
import org.apache.aries.proxy.weaving.WovenProxy;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsmProxyManager
extends AbstractProxyManager
implements ProxyManager {
    @Override
    public Object createNewProxy(Bundle clientBundle, Collection<Class<?>> classes, Callable<Object> dispatcher, InvocationListener listener) throws UnableToProxyException {
        Object proxyObject = null;
        HashSet notInterfaces = new HashSet();
        HashSet interfaces = new HashSet();
        for (Class<?> clazz : classes) {
            if (!clazz.isInterface()) {
                notInterfaces.add(clazz);
                continue;
            }
            interfaces.add(clazz);
        }
        if (notInterfaces.isEmpty()) {
            proxyObject = InterfaceProxyGenerator.getProxyInstance(clientBundle, null, interfaces, dispatcher, listener);
        } else {
            Class<?> classToProxy = this.getLowestSubclass(notInterfaces);
            if (WovenProxy.class.isAssignableFrom(classToProxy)) {
                if (this.isConcrete(classToProxy) && this.implementsAll(classToProxy, interfaces)) {
                    try {
                        Constructor<?> c = classToProxy.getDeclaredConstructor(Callable.class, InvocationListener.class);
                        c.setAccessible(true);
                        proxyObject = c.newInstance(dispatcher, listener);
                    }
                    catch (Exception e) {}
                } else {
                    if ((classToProxy.getModifiers() & 0x10) != 0) {
                        throw new UnableToProxyException(classToProxy, "The class " + classToProxy + " does not implement all of the interfaces " + interfaces + " and is final. This means that we cannot create a proxy for both the class and all of the requested interfaces.");
                    }
                    proxyObject = InterfaceProxyGenerator.getProxyInstance(clientBundle, classToProxy, interfaces, dispatcher, listener);
                }
            }
            if (proxyObject == null) {
                proxyObject = ProxySubclassGenerator.newProxySubclassInstance(classToProxy, new ProxyHandler(this, dispatcher, listener));
            }
        }
        return proxyObject;
    }

    private Class<?> getLowestSubclass(Set<Class<?>> notInterfaces) throws UnableToProxyException {
        Iterator<Class<?>> it = notInterfaces.iterator();
        Class<?> classToProxy = it.next();
        while (it.hasNext()) {
            Class<?> potential = it.next();
            if (classToProxy.isAssignableFrom(potential)) {
                classToProxy = potential;
                continue;
            }
            if (potential.isAssignableFrom(classToProxy)) continue;
            throw new UnableToProxyException(classToProxy, "The requested classes " + classToProxy + " and " + potential + " are not in the same type hierarchy");
        }
        return classToProxy;
    }

    private boolean isConcrete(Class<?> classToProxy) {
        return (classToProxy.getModifiers() & 0x400) == 0;
    }

    private boolean implementsAll(Class<?> classToProxy, Set<Class<?>> interfaces) {
        for (Class<?> iface : interfaces) {
            if (iface.isAssignableFrom(classToProxy)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isProxyClass(Class<?> clazz) {
        return WovenProxy.class.isAssignableFrom(clazz) || ProxySubclassGenerator.isProxySubclass(clazz) || Proxy.isProxyClass(clazz);
    }

    @Override
    protected InvocationHandler getInvocationHandler(Object proxy) {
        Class<?> type = proxy.getClass();
        InvocationHandler ih = null;
        if (ProxySubclassGenerator.isProxySubclass(type)) {
            ih = ProxySubclassGenerator.getInvocationHandler(proxy);
        } else if (Proxy.isProxyClass(type)) {
            ih = Proxy.getInvocationHandler(proxy);
        }
        return ih;
    }
}

