/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

public class ErrorHandlerBuilderRef
extends ErrorHandlerBuilderSupport {
    public static final String DEFAULT_ERROR_HANDLER_BUILDER = "CamelDefaultErrorHandlerBuilder";
    private final String ref;
    private ErrorHandlerBuilder handler;
    private boolean supportTransacted;

    public ErrorHandlerBuilderRef(String ref) {
        this.ref = ref;
    }

    @Override
    public void addErrorHandlers(OnExceptionDefinition exception) {
        if (this.handler != null) {
            this.handler.addErrorHandlers(exception);
        }
        super.addErrorHandlers(exception);
    }

    @Override
    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        if (this.handler == null) {
            this.handler = this.createErrorHandler(routeContext);
        }
        return this.handler.createErrorHandler(routeContext, processor);
    }

    @Override
    public boolean supportTransacted() {
        return this.supportTransacted;
    }

    public static ErrorHandlerFactory lookupErrorHandlerBuilder(RouteContext routeContext, String ref) {
        ErrorHandlerFactory answer;
        if (!ErrorHandlerBuilderRef.isErrorHandlerBuilderConfigured(ref)) {
            answer = routeContext.getRoute().getErrorHandlerBuilder();
            if (answer == null && routeContext.getRoute().getErrorHandlerRef() != null) {
                answer = routeContext.lookup(routeContext.getRoute().getErrorHandlerRef(), ErrorHandlerBuilder.class);
            }
            if (answer == null) {
                answer = new DefaultErrorHandlerBuilder();
            }
            if (answer instanceof ErrorHandlerBuilderRef) {
                ErrorHandlerBuilderRef other = (ErrorHandlerBuilderRef)answer;
                String otherRef = other.getRef();
                if (!ErrorHandlerBuilderRef.isErrorHandlerBuilderConfigured(otherRef)) {
                    answer = ErrorHandlerBuilderRef.lookupErrorHandlerBuilder((ModelCamelContext)routeContext.getCamelContext());
                }
                if (answer == null) {
                    answer = new DefaultErrorHandlerBuilder();
                }
                ((ErrorHandlerBuilder)answer).setErrorHandlers(other.getErrorHandlers());
            }
        } else {
            answer = routeContext.mandatoryLookup(ref, ErrorHandlerBuilder.class);
        }
        return answer;
    }

    protected static ErrorHandlerFactory lookupErrorHandlerBuilder(ModelCamelContext camelContext) {
        ErrorHandlerBuilderRef other;
        String otherRef;
        ErrorHandlerFactory answer = camelContext.getErrorHandlerBuilder();
        if (answer instanceof ErrorHandlerBuilderRef && ErrorHandlerBuilderRef.isErrorHandlerBuilderConfigured(otherRef = (other = (ErrorHandlerBuilderRef)answer).getRef()) && (answer = (ErrorHandlerFactory)camelContext.getRegistry().lookup(otherRef, ErrorHandlerBuilder.class)) == null) {
            throw new IllegalArgumentException("ErrorHandlerBuilder with id " + otherRef + " not found in registry.");
        }
        return answer;
    }

    public static boolean isErrorHandlerBuilderConfigured(String ref) {
        return !DEFAULT_ERROR_HANDLER_BUILDER.equals(ref);
    }

    public String getRef() {
        return this.ref;
    }

    public ErrorHandlerFactory getHandler() {
        return this.handler;
    }

    private ErrorHandlerBuilder createErrorHandler(RouteContext routeContext) {
        this.handler = (ErrorHandlerBuilder)ErrorHandlerBuilderRef.lookupErrorHandlerBuilder(routeContext, this.getRef());
        ObjectHelper.notNull(this.handler, "error handler '" + this.ref + "'");
        this.supportTransacted = this.handler.supportTransacted();
        List<OnExceptionDefinition> list = this.getErrorHandlers();
        for (OnExceptionDefinition exceptionType : list) {
            this.handler.addErrorHandlers(exceptionType);
        }
        return this.handler;
    }

    public String toString() {
        return "ErrorHandlerBuilderRef[" + this.ref + "]";
    }
}

