/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Locale;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.util.ObjectHelper;

public final class CamelContextHelper {
    private CamelContextHelper() {
    }

    public static Endpoint getMandatoryEndpoint(CamelContext camelContext, String uri) throws NoSuchEndpointException {
        Endpoint endpoint = camelContext.getEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public static <T extends Endpoint> T getMandatoryEndpoint(CamelContext camelContext, String uri, Class<T> type) {
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(camelContext, uri);
        return (T)((Endpoint)ObjectHelper.cast(type, endpoint));
    }

    public static <T> T convertTo(CamelContext context, Class<T> type, Object value) {
        ObjectHelper.notNull(context, "camelContext");
        return context.getTypeConverter().convertTo(type, value);
    }

    public static <T> T mandatoryConvertTo(CamelContext context, Class<T> type, Object value) {
        T answer = CamelContextHelper.convertTo(context, type, value);
        if (answer == null) {
            throw new IllegalArgumentException("Value " + value + " converted to " + type.getName() + " cannot be null");
        }
        return answer;
    }

    public static <T> T newInstance(CamelContext context, Class<T> beanType) {
        return context.getInjector().newInstance(beanType);
    }

    public static Object lookup(CamelContext context, String name) {
        return context.getRegistry().lookup(name);
    }

    public static <T> T lookup(CamelContext context, String name, Class<T> beanType) {
        return context.getRegistry().lookup(name, beanType);
    }

    public static Object mandatoryLookup(CamelContext context, String name) {
        Object answer = CamelContextHelper.lookup(context, name);
        if (answer == null) {
            throw new NoSuchBeanException(name);
        }
        return answer;
    }

    public static <T> T mandatoryLookup(CamelContext context, String name, Class<T> beanType) {
        T answer = CamelContextHelper.lookup(context, name, beanType);
        if (answer == null) {
            throw new NoSuchBeanException(name, beanType.getName());
        }
        return answer;
    }

    public static Endpoint getEndpointInjection(CamelContext camelContext, String uri, String ref, String injectionPointName, boolean mandatory) {
        Endpoint endpoint;
        if (ObjectHelper.isNotEmpty(uri) && ObjectHelper.isNotEmpty(ref)) {
            throw new IllegalArgumentException("Both uri and name is provided, only either one is allowed: uri=" + uri + ", ref=" + ref);
        }
        if (ObjectHelper.isNotEmpty(uri)) {
            endpoint = camelContext.getEndpoint(uri);
        } else if (ObjectHelper.isNotEmpty(ref)) {
            endpoint = CamelContextHelper.mandatoryLookup(camelContext, ref, Endpoint.class);
        } else {
            if (ObjectHelper.isEmpty(ref)) {
                ref = injectionPointName;
            }
            endpoint = mandatory ? CamelContextHelper.mandatoryLookup(camelContext, ref, Endpoint.class) : CamelContextHelper.lookup(camelContext, ref, Endpoint.class);
        }
        return endpoint;
    }

    public static int getMaximumCachePoolSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getProperties().get("CamelMaximumCachePoolSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumCachePoolSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumCachePoolSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumEndpointCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getProperties().get("CamelMaximumEndpointCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumEndpointCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumEndpointCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static String parseText(CamelContext camelContext, String text) throws Exception {
        return camelContext.resolvePropertyPlaceholders(text);
    }

    public static Integer parseInteger(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return camelContext.getTypeConverter().mandatoryConvertTo(Integer.class, s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as an Integer.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as an Integer.", e);
            }
        }
        return null;
    }

    public static Long parseLong(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return camelContext.getTypeConverter().mandatoryConvertTo(Long.class, s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as a Long.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as a Long.", e);
            }
        }
        return null;
    }

    public static Double parseDouble(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return camelContext.getTypeConverter().mandatoryConvertTo(Double.class, s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as an Integer.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as an Integer.", e);
            }
        }
        return null;
    }

    public static Boolean parseBoolean(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            if ((s = s.trim().toLowerCase(Locale.ENGLISH)).equals("true") || s.equals("false")) {
                return "true".equals(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (s.equals(text)) {
                throw new IllegalArgumentException("Error parsing [" + s + "] as a Boolean.");
            }
            throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as a Boolean.");
        }
        return null;
    }
}

