/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.parsing;

import java.lang.reflect.Method;
import org.apache.aries.blueprint.BeanProcessor;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.transaction.Constants;
import org.apache.aries.transaction.TxComponentMetaDataHelper;
import org.apache.aries.transaction.annotations.Transaction;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

public class AnnotationParser
implements BeanProcessor {
    private final ComponentDefinitionRegistry cdr;
    private final Interceptor interceptor;
    private final TxComponentMetaDataHelper helper;

    public AnnotationParser(ComponentDefinitionRegistry cdr, Interceptor i, TxComponentMetaDataHelper helper) {
        this.cdr = cdr;
        this.interceptor = i;
        this.helper = helper;
    }

    public void afterDestroy(Object arg0, String arg1) {
    }

    public Object afterInit(Object arg0, String arg1, BeanProcessor.BeanCreator arg2, BeanMetadata arg3) {
        return null;
    }

    public void beforeDestroy(Object arg0, String arg1) {
    }

    public Object beforeInit(Object arg0, String arg1, BeanProcessor.BeanCreator arg2, BeanMetadata arg3) {
        boolean interceptorAssigned = false;
        for (Class<?> c = arg0.getClass(); c != Object.class; c = c.getSuperclass()) {
            block1: for (Method m : c.getDeclaredMethods()) {
                int modifiers = m.getModifiers();
                if ((modifiers & 0xA) != 0) {
                    throw new IllegalArgumentException(Constants.MESSAGES.getMessage("private.or.static.method", new Object[]{m}));
                }
                Transaction t = m.getAnnotation(Transaction.class);
                if (t == null || this.helper.getComponentMethodTxAttribute((ComponentMetadata)arg3, m.getName()) != null) continue;
                this.helper.setComponentTransactionData(this.cdr, (ComponentMetadata)arg3, t.value().toString(), m.getName());
                if (interceptorAssigned) continue;
                for (Interceptor i : this.cdr.getInterceptors((ComponentMetadata)arg3)) {
                    if (i != this.interceptor) continue;
                    interceptorAssigned = true;
                    continue block1;
                }
                this.cdr.registerInterceptorWithComponent((ComponentMetadata)arg3, this.interceptor);
                interceptorAssigned = true;
            }
        }
        return arg0;
    }
}

