/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service;

import java.util.List;
import java.util.Set;
import org.apache.felix.utils.version.VersionTable;
import org.fusesource.fabric.api.Issue;
import org.fusesource.fabric.api.Patch;
import org.fusesource.fabric.service.PatchServiceImpl;
import org.osgi.framework.Version;

public class PatchImpl
implements Patch,
Comparable<PatchImpl> {
    private final String id;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Set<String> artifacts;
    private final List<Issue> issues;

    public PatchImpl(String id, String location, Set<String> artifacts, List<Issue> issues) {
        this.id = id;
        String[] mvn = location.split("\\|");
        this.groupId = mvn[1];
        this.artifactId = mvn[2];
        this.version = mvn[3];
        this.artifacts = artifacts;
        this.issues = issues;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<String> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(PatchImpl o) {
        int c = this.groupId.compareTo(o.groupId);
        if (c != 0) {
            return c;
        }
        c = this.artifactId.compareTo(o.artifactId);
        if (c != 0) {
            return c;
        }
        Version v1 = VersionTable.getVersion((String)this.version);
        Version v2 = VersionTable.getVersion((String)o.version);
        return PatchServiceImpl.compareFuseVersions(v1, v2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchImpl patch = (PatchImpl)o;
        return this.compareTo(patch) == 0;
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Patch[id='" + this.id + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ']';
    }
}

