/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.framework.monitor.MonitoringService;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.properties.Properties;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.FeatureValidationUtil;
import org.apache.karaf.features.internal.FeaturesServiceImpl;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.fusesource.fabric.agent.ObrResolver;
import org.fusesource.fabric.agent.download.DownloadFuture;
import org.fusesource.fabric.agent.download.DownloadManager;
import org.fusesource.fabric.agent.download.FutureListener;
import org.fusesource.fabric.agent.mvn.DictionaryPropertyResolver;
import org.fusesource.fabric.agent.mvn.MavenConfigurationImpl;
import org.fusesource.fabric.agent.mvn.MavenRepositoryURL;
import org.fusesource.fabric.agent.mvn.MavenSettingsImpl;
import org.fusesource.fabric.agent.mvn.Parser;
import org.fusesource.fabric.agent.mvn.PropertiesPropertyResolver;
import org.fusesource.fabric.agent.mvn.PropertyStore;
import org.fusesource.fabric.agent.utils.ChecksumUtils;
import org.fusesource.fabric.agent.utils.MultiException;
import org.fusesource.fabric.fab.MavenResolver;
import org.fusesource.fabric.fab.MavenResolverImpl;
import org.fusesource.fabric.fab.osgi.FabBundleInfo;
import org.fusesource.fabric.fab.osgi.FabResolver;
import org.fusesource.fabric.fab.osgi.FabResolverFactory;
import org.fusesource.fabric.fab.osgi.ServiceConstants;
import org.fusesource.fabric.fab.osgi.internal.Configuration;
import org.fusesource.fabric.fab.osgi.internal.FabResolverFactoryImpl;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentAgent
implements ManagedService,
FrameworkListener {
    public static final String FAB_PROTOCOL = "fab:";
    private static final String DEFAULT_VERSION = "0.0.0";
    private static final String FABRIC_ZOOKEEPER_PID = "fabric.zookeeper.id";
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentAgent.class);
    private BundleContext bundleContext;
    private BundleContext systemBundleContext;
    private PackageAdmin packageAdmin;
    private StartLevel startLevel;
    private ObrResolver obrResolver;
    private ServiceTracker zkClient;
    private final Object refreshLock = new Object();
    private long refreshTimeout = 5000L;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("fabric-agent"));
    private ExecutorService downloadExecutor;
    private volatile boolean shutdownDownloadExecutor;
    private DownloadManager manager;
    private ExecutorServiceFinder executorServiceFinder;
    private Properties checksums;

    public DeploymentAgent() throws MalformedURLException {
        MavenConfigurationImpl config = new MavenConfigurationImpl(new PropertiesPropertyResolver(System.getProperties()), "org.ops4j.pax.url.mvn");
        config.setSettings(new MavenSettingsImpl(config.getSettingsFileUrl(), config.useFallbackRepositories()));
        this.manager = new DownloadManager(config);
    }

    public StartLevel getStartLevel() {
        return this.startLevel;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public PackageAdmin getPackageAdmin() {
        return this.packageAdmin;
    }

    public ObrResolver getObrResolver() {
        return this.obrResolver;
    }

    public ServiceTracker getZkClient() {
        return this.zkClient;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    public void setStartLevel(StartLevel startLevel) {
        this.startLevel = startLevel;
    }

    public void setObrResolver(ObrResolver obrResolver) {
        this.obrResolver = obrResolver;
    }

    public void setZkClient(ServiceTracker zkClient) {
        this.zkClient = zkClient;
    }

    public void start() throws IOException {
        LOGGER.info("Starting DeploymentAgent");
        this.bundleContext.addFrameworkListener((FrameworkListener)this);
        this.systemBundleContext = this.bundleContext.getBundle(0L).getBundleContext();
        if (this.checksums == null) {
            File file = this.bundleContext.getDataFile("checksums.properties");
            this.checksums = new Properties(file);
        }
        for (Bundle bundle : this.systemBundleContext.getBundles()) {
            try {
                if (!bundle.getLocation().endsWith("SNAPSHOT")) continue;
                Parser parser = new Parser(bundle.getLocation());
                String path = System.getProperty("karaf.home") + File.separator + "system" + File.separator + parser.getArtifactPath().substring(4);
                long checksum = ChecksumUtils.checksum(new FileInputStream(path));
                this.checksums.put(bundle.getLocation(), Long.toString(checksum));
            }
            catch (Exception e) {
                LOGGER.debug("Error calculating checksum", (Throwable)e);
            }
        }
        this.checksums.save();
    }

    public void stop() throws InterruptedException {
        LOGGER.info("Stopping DeploymentAgent");
        this.executor.shutdown();
        if (this.shutdownDownloadExecutor && this.downloadExecutor != null) {
            this.downloadExecutor.shutdown();
            this.downloadExecutor = null;
        }
        this.bundleContext.removeFrameworkListener((FrameworkListener)this);
        this.manager.shutdown();
    }

    public void updated(final Dictionary props) throws ConfigurationException {
        if (this.executor.isShutdown() || props == null) {
            return;
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                Throwable result = null;
                boolean success = false;
                try {
                    success = DeploymentAgent.this.doUpdate(props);
                }
                catch (Throwable e) {
                    result = e;
                    LOGGER.error("Unable to update agent", e);
                }
                if (success || result != null) {
                    DeploymentAgent.this.updateStatus(success ? "success" : "error", result, null, true);
                }
            }
        });
    }

    private void updateStatus(String status, Throwable result) {
        this.updateStatus(status, result, null, false);
    }

    private void updateStatus(String status, Throwable result, List<Resource> resources, boolean force) {
        try {
            IZKClient zk = force ? (IZKClient)this.zkClient.waitForService(0L) : (IZKClient)this.zkClient.getService();
            if (zk != null) {
                StringWriter sw;
                String e;
                String name = System.getProperty("karaf.name");
                if (result == null) {
                    e = null;
                } else {
                    sw = new StringWriter();
                    result.printStackTrace(new PrintWriter(sw));
                    e = sw.toString();
                }
                if (resources != null) {
                    sw = new StringWriter();
                    for (Resource res : resources) {
                        sw.write(res.getURI() + "\n");
                    }
                    zk.createOrSetWithParents(ZkPath.CONTAINER_PROVISION_LIST.getPath(new String[]{name}), sw.toString(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                zk.createOrSetWithParents(ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{name}), status, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zk.createOrSetWithParents(ZkPath.CONTAINER_PROVISION_EXCEPTION.getPath(new String[]{name}), e, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            } else {
                LOGGER.info("ZooKeeper not available");
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to set provisioning result");
        }
    }

    public boolean doUpdate(Dictionary props) throws Exception {
        if (props == null) {
            return false;
        }
        this.addMavenProxies(props);
        this.updateStatus("analyzing", null);
        DictionaryPropertyResolver propertyResolver = new DictionaryPropertyResolver(props, new PropertiesPropertyResolver(System.getProperties()));
        MavenConfigurationImpl config = new MavenConfigurationImpl(new DictionaryPropertyResolver(props, new PropertiesPropertyResolver(System.getProperties())), "org.ops4j.pax.url.mvn");
        config.setSettings(new MavenSettingsImpl(config.getSettingsFileUrl(), config.useFallbackRepositories()));
        this.manager = new DownloadManager(config, this.getDownloadExecutor());
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = props.get(key);
            if ("service.pid".equals(key) || FABRIC_ZOOKEEPER_PID.equals(key)) continue;
            properties.put(key.toString(), val.toString());
        }
        boolean restart = false;
        Properties configProps = new Properties(new File(System.getProperty("karaf.base") + File.separator + "etc" + File.separator + "config.properties"));
        Properties systemProps = new Properties(new File(System.getProperty("karaf.base") + File.separator + "etc" + File.separator + "system.properties"));
        for (String key : properties.keySet()) {
            String v;
            String k;
            if (key.equals("framework")) {
                String url = (String)properties.get(key);
                restart |= this.updateFramework(configProps, url);
                continue;
            }
            if (key.startsWith("config.")) {
                k = key.substring("config.".length());
                v = (String)properties.get(key);
                if (v.equals(configProps.get(k))) continue;
                configProps.put(k, v);
                restart = true;
                continue;
            }
            if (!key.startsWith("system.")) continue;
            k = key.substring("system.".length());
            v = (String)properties.get(key);
            if (v.equals(systemProps.get(k))) continue;
            systemProps.put(k, v);
            restart = true;
        }
        if (restart) {
            this.updateStatus("restarting", null);
            configProps.save();
            systemProps.save();
            System.setProperty("karaf.restart", "true");
            this.bundleContext.getBundle(0L).stop();
            return false;
        }
        final HashMap<URI, Repository> repositories = new HashMap<URI, Repository>();
        for (String key : properties.keySet()) {
            if (!key.startsWith("repository.")) continue;
            String url = (String)properties.get(key);
            if (url == null || url.length() == 0) {
                url = key.substring("repository.".length());
            }
            if (url == null || url.length() <= 0) continue;
            URI uri = URI.create(url);
            this.addRepository(repositories, uri);
        }
        HashSet<Feature> features = new HashSet<Feature>();
        for (String key : properties.keySet()) {
            Feature feature;
            if (!key.startsWith("feature.")) continue;
            String name = (String)properties.get(key);
            if (name == null || name.length() == 0) {
                name = key.substring("feature.".length());
            }
            if ((feature = this.search(name, repositories.values())) == null) {
                throw new IllegalArgumentException("Unable to find feature " + name);
            }
            features.add(feature);
        }
        HashSet<String> fabs = new HashSet<String>();
        for (String key : properties.keySet()) {
            if (!key.startsWith("fab.")) continue;
            String url = (String)properties.get(key);
            if (url == null || url.length() == 0) {
                url = key.substring("fab.".length());
            }
            if (url == null || url.length() <= 0) continue;
            fabs.add(url);
        }
        HashSet<String> bundles = new HashSet<String>();
        for (String key : properties.keySet()) {
            if (!key.startsWith("fab.")) continue;
            String url = (String)properties.get(key);
            if (url == null || url.length() == 0) {
                url = key.substring("fab.".length());
            }
            if (url == null || url.length() <= 0) continue;
            if (url.startsWith(FAB_PROTOCOL)) {
                fabs.add(url.substring(FAB_PROTOCOL.length()));
                continue;
            }
            bundles.add(url);
        }
        HashSet<String> overrides = new HashSet<String>();
        for (String key : properties.keySet()) {
            if (!key.startsWith("override.")) continue;
            String url = (String)properties.get(key);
            if (url == null || url.length() == 0) {
                url = key.substring("override.".length());
            }
            if (url == null || url.length() <= 0) continue;
            overrides.add(url);
        }
        FabResolverFactoryImpl fabResolverFactory = new FabResolverFactoryImpl();
        fabResolverFactory.setConfiguration(new FabricFabConfiguration(config, propertyResolver));
        fabResolverFactory.setBundleContext(this.bundleContext);
        fabResolverFactory.setFeaturesService(new FeaturesServiceImpl(){

            @Override
            public Repository[] listRepositories() {
                return repositories.values().toArray(new Repository[repositories.size()]);
            }
        });
        this.updateDeployment(fabResolverFactory, repositories, features, bundles, fabs, overrides);
        return true;
    }

    private void addMavenProxies(Dictionary props) {
        try {
            IZKClient zooKeeper = (IZKClient)this.zkClient.waitForService(0L);
            if (zooKeeper.exists(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"})) != null) {
                StringBuffer sb = new StringBuffer();
                List proxies = zooKeeper.getChildren(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}));
                Collections.sort(proxies);
                for (String proxy : proxies) {
                    try {
                        String mavenRepo = ZooKeeperUtils.getSubstitutedPath((IZKClient)zooKeeper, (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}) + "/" + proxy));
                        if (mavenRepo == null || mavenRepo.length() <= 0) continue;
                        if (!mavenRepo.endsWith("/")) {
                            mavenRepo = mavenRepo + "/";
                        }
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(mavenRepo);
                        sb.append("@snapshots");
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Failed to resolve proxy: " + proxy + ". It will be ignored.");
                    }
                }
                String existingRepos = (String)props.get("org.ops4j.pax.url.mvn.repositories");
                if (existingRepos != null) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(existingRepos);
                }
                props.put("org.ops4j.pax.url.mvn.repositories", sb.toString());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to retrieve maven proxy urls: " + e.getMessage());
            LOGGER.debug("Unable to retrieve maven proxy urls: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addRepository(Map<URI, Repository> repositories, URI uri) throws Exception {
        if (!repositories.containsKey(uri)) {
            File file = ((DownloadFuture)this.manager.download(uri.toString()).await()).getFile();
            FeatureValidationUtil.validate(file.toURI());
            RepositoryImpl repo = new RepositoryImpl(uri);
            repositories.put(uri, repo);
            repo.load();
            for (URI ref : repo.getRepositories()) {
                this.addRepository(repositories, ref);
            }
        }
    }

    private Feature search(String key, Collection<Repository> repositories) {
        String[] split = key.split("/");
        String name = split[0].trim();
        String version = null;
        if (split.length == 2) {
            version = split[1].trim();
        }
        if (version == null || version.length() == 0) {
            version = DEFAULT_VERSION;
        }
        return this.search(name, version, repositories);
    }

    private Feature search(String name, String version, Collection<Repository> repositories) {
        VersionRange range = new VersionRange(version, false, true);
        Feature bestFeature = null;
        Version bestVersion = null;
        for (Repository repo : repositories) {
            Feature[] features;
            try {
                features = repo.getFeatures();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            for (Feature feature : features) {
                Version v;
                if (!name.equals(feature.getName()) || !range.contains(v = new Version(VersionCleaner.clean(feature.getVersion()))) || bestVersion != null && bestVersion.compareTo((Object)v) >= 0) continue;
                bestFeature = feature;
                bestVersion = v;
            }
        }
        return bestFeature;
    }

    private Set<Feature> addFeatures(Collection<Feature> features, Collection<Repository> repositories) {
        HashSet<Feature> set = new HashSet<Feature>();
        for (Feature feature : features) {
            this.addFeatures(set, feature, repositories);
        }
        return set;
    }

    private Set<Feature> addFeatures(Set<Feature> set, Feature feature, Collection<Repository> repositories) {
        set.add(feature);
        for (Feature dep : feature.getDependencies()) {
            Feature f = this.search(dep.getName(), dep.getVersion(), repositories);
            if (f == null) {
                throw new IllegalArgumentException("Unable to find feature " + dep.getName() + "/" + dep.getVersion());
            }
            this.addFeatures(set, f, repositories);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateDeployment(FabResolverFactory fabResolverFactory, Map<URI, Repository> repositories, Set<Feature> features, Set<String> bundles, Set<String> fabs, Set<String> overrides) throws Exception {
        Bundle bundle;
        void var21_25;
        HashMap<String, FabBundleInfo> infos = new HashMap<String, FabBundleInfo>();
        for (String fab : fabs) {
            FabResolver resolver = fabResolverFactory.getResolver(new URL(fab));
            FabBundleInfo info = resolver.getInfo();
            for (String name : info.getFeatures()) {
                Feature feature = this.search(name, repositories.values());
                if (feature == null) {
                    throw new IllegalArgumentException("Unable to find feature " + name);
                }
                features.add(feature);
            }
            LOGGER.info("Fab: " + info.getUrl());
            infos.put(FAB_PROTOCOL + info.getUrl(), info);
        }
        Set<Feature> allFeatures = this.addFeatures(features, repositories.values());
        LinkedHashSet<String> featureFabs = new LinkedHashSet<String>();
        for (Feature feature : allFeatures) {
            for (BundleInfo bundleInfo : feature.getBundles()) {
                String normalizedLocation;
                if (!bundleInfo.getLocation().startsWith(FAB_PROTOCOL) || fabs.contains(normalizedLocation = bundleInfo.getLocation().substring(FAB_PROTOCOL.length()))) continue;
                featureFabs.add(normalizedLocation);
            }
        }
        if (!featureFabs.isEmpty()) {
            fabs.addAll(featureFabs);
            this.updateDeployment(fabResolverFactory, repositories, features, bundles, fabs, overrides);
            return;
        }
        this.updateStatus("downloading", null);
        Map<String, File> downloads = this.downloadBundles(allFeatures, bundles, overrides);
        this.updateStatus("resolving", null);
        List<Resource> allResources = this.getObrResolver().resolve(allFeatures, bundles, infos, overrides, downloads);
        this.updateStatus("installing", null, allResources, true);
        HashMap<Object, Bundle> resToBnd = new HashMap<Object, Bundle>();
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration changed.  New bundles list:\n");
        for (Resource bundle2 : allResources) {
            sb.append("  ").append(bundle2.getURI()).append("\n");
        }
        LOGGER.info(sb.toString());
        HashMap<String, String> newCheckums = new HashMap<String, String>();
        ArrayList<Resource> toDeploy = new ArrayList<Resource>(allResources);
        ArrayList<Resource> toInstall = new ArrayList<Resource>();
        ArrayList<Bundle> toDelete = new ArrayList<Bundle>();
        HashMap<Bundle, Object> toUpdate = new HashMap<Bundle, Object>();
        if (this.checksums == null) {
            File file = this.bundleContext.getDataFile("checksums.properties");
            this.checksums = new Properties(file);
        }
        Bundle[] arr$ = this.systemBundleContext.getBundles();
        int len$ = arr$.length;
        boolean bl = false;
        while (var21_25 < len$) {
            Bundle bundle3 = arr$[var21_25];
            if (bundle3.getBundleId() != 0L) {
                void var23_33;
                Object var23_34 = null;
                boolean update = false;
                for (Resource res : toDeploy) {
                    if (!res.getSymbolicName().equals(bundle3.getSymbolicName()) || !res.getVersion().equals((Object)bundle3.getVersion())) continue;
                    if (res.getVersion().getQualifier().endsWith("SNAPSHOT")) {
                        InputStream is = null;
                        try {
                            long oldCrc;
                            is = DeploymentAgent.getBundleInputStream(res, downloads, infos);
                            long newCrc = ChecksumUtils.checksum(is);
                            long l = oldCrc = this.checksums.containsKey(bundle3.getLocation()) ? Long.parseLong((String)this.checksums.get(bundle3.getLocation())) : 0L;
                            if (newCrc != oldCrc) {
                                LOGGER.debug("New snapshot available for " + bundle3.getLocation());
                                update = true;
                                newCheckums.put(bundle3.getLocation(), Long.toString(newCrc));
                            }
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    Resource resource = res;
                    break;
                }
                if (var23_33 != null) {
                    toDeploy.remove(var23_33);
                    resToBnd.put(var23_33, bundle3);
                    if (update) {
                        toUpdate.put(bundle3, var23_33);
                    }
                } else {
                    toDelete.add(bundle3);
                }
            }
            ++var21_25;
        }
        for (Resource resource : toDeploy) {
            TreeMap<Version, Bundle> treeMap = new TreeMap<Version, Bundle>();
            VersionRange range = this.getMicroVersionRange(resource.getVersion());
            for (Bundle bundle4 : toDelete) {
                if (!bundle4.getSymbolicName().equals(resource.getSymbolicName()) || !range.contains(bundle4.getVersion())) continue;
                treeMap.put(bundle4.getVersion(), bundle4);
            }
            if (!treeMap.isEmpty()) {
                Bundle bundle2 = (Bundle)treeMap.lastEntry().getValue();
                toUpdate.put(bundle2, resource);
                toDelete.remove(bundle2);
                resToBnd.put(resource, bundle2);
                continue;
            }
            toInstall.add(resource);
        }
        Resource agentResource = (Resource)toUpdate.get(this.bundleContext.getBundle());
        if (agentResource != null) {
            LOGGER.info("Updating agent");
            LOGGER.info("  " + agentResource.getURI());
            InputStream is = DeploymentAgent.getBundleInputStream(agentResource, downloads, infos);
            Bundle bundle3 = this.bundleContext.getBundle();
            this.checksums.save();
            bundle3.update(is);
            if (newCheckums.containsKey(bundle3.getLocation())) {
                this.checksums.put(bundle3.getLocation(), (String)newCheckums.get(bundle3.getLocation()));
                this.checksums.save();
            }
            return;
        }
        LOGGER.info("Changes to perform:");
        LOGGER.info("  Bundles to uninstall:");
        for (Bundle bundle4 : toDelete) {
            LOGGER.info("    " + bundle4.getSymbolicName() + " / " + bundle4.getVersion());
        }
        LOGGER.info("  Bundles to update:");
        for (Map.Entry entry : toUpdate.entrySet()) {
            LOGGER.info("    " + ((Bundle)entry.getKey()).getSymbolicName() + " / " + ((Bundle)entry.getKey()).getVersion() + " with " + ((Resource)entry.getValue()).getURI());
        }
        LOGGER.info("  Bundles to install:");
        for (Resource resource : toInstall) {
            LOGGER.info("    " + resource.getURI());
        }
        HashSet<Bundle> toRefresh = new HashSet<Bundle>();
        LOGGER.info("Stopping bundles:");
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.addAll(toUpdate.keySet());
        arrayList.addAll(toDelete);
        while (!arrayList.isEmpty()) {
            List<Bundle> bs = this.getBundlesToDestroy(arrayList);
            for (Bundle bundle8 : bs) {
                String hostHeader = (String)bundle8.getHeaders().get("Fragment-Host");
                if (hostHeader == null && (bundle8.getState() == 32 || bundle8.getState() == 8)) {
                    LOGGER.info("  " + bundle8.getSymbolicName() + " / " + bundle8.getVersion());
                    bundle8.stop(1);
                }
                arrayList.remove(bundle8);
            }
        }
        LOGGER.info("Uninstalling bundles:");
        for (Bundle bundle5 : toDelete) {
            LOGGER.info("  " + bundle5.getSymbolicName() + " / " + bundle5.getVersion());
            bundle5.uninstall();
            toRefresh.add(bundle5);
        }
        LOGGER.info("Updating bundles:");
        for (Map.Entry entry : toUpdate.entrySet()) {
            Bundle bundle9 = (Bundle)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            LOGGER.info("  " + resource.getURI());
            InputStream is = DeploymentAgent.getBundleInputStream(resource, downloads, infos);
            bundle9.update(is);
            toRefresh.add(bundle9);
        }
        LOGGER.info("Installing bundles:");
        for (Resource resource : toInstall) {
            LOGGER.info("  " + resource.getURI());
            InputStream is = DeploymentAgent.getBundleInputStream(resource, downloads, infos);
            bundle = this.systemBundleContext.installBundle(resource.getURI(), is);
            toRefresh.add(bundle);
            resToBnd.put(resource, bundle);
            if (!bundle.getVersion().getQualifier().endsWith("SNAPSHOT") || newCheckums.containsKey(bundle.getLocation())) continue;
            newCheckums.put(bundle.getLocation(), Long.toString(ChecksumUtils.checksum(DeploymentAgent.getBundleInputStream(resource, downloads, infos))));
        }
        if (!newCheckums.isEmpty()) {
            for (String string : newCheckums.keySet()) {
                this.checksums.put(string, (String)newCheckums.get(string));
            }
            this.checksums.save();
        }
        this.findBundlesWithOptionalPackagesToRefresh(toRefresh);
        this.findBundlesWithFragmentsToRefresh(toRefresh);
        this.updateStatus("finalizing", null);
        LOGGER.info("Refreshing bundles:");
        for (Bundle bundle6 : toRefresh) {
            LOGGER.info("  " + bundle6.getSymbolicName() + " / " + bundle6.getVersion());
        }
        if (!toRefresh.isEmpty()) {
            this.refreshPackages(toRefresh.toArray(new Bundle[toRefresh.size()]));
        }
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        LOGGER.info("Starting bundles:");
        for (Resource resource : allResources) {
            bundle = (Bundle)resToBnd.get(resource);
            String hostHeader = (String)bundle.getHeaders().get("Fragment-Host");
            if (hostHeader != null || bundle.getState() == 32) continue;
            LOGGER.info("  " + bundle.getSymbolicName() + " / " + bundle.getVersion());
            try {
                bundle.start();
            }
            catch (BundleException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new MultiException("Error updating agent", exceptions);
        }
        LOGGER.info("Done.");
    }

    protected static InputStream getBundleInputStream(Resource resource, Map<String, File> downloads, Map<String, FabBundleInfo> infos) throws Exception {
        return DeploymentAgent.getBundleInputStream(resource.getURI(), downloads, infos);
    }

    protected static InputStream getBundleInputStream(String uri, Map<String, File> downloads, Map<String, FabBundleInfo> infos) throws Exception {
        InputStream is;
        File file = downloads.get(uri);
        if (file != null) {
            is = new FileInputStream(file);
        } else {
            FabBundleInfo info = infos.get(uri);
            if (info != null) {
                is = info.getInputStream();
            } else {
                LOGGER.warn("Bundle " + uri + " not found in the downloads, using direct input stream instead");
                is = new URL(uri).openStream();
            }
        }
        return is;
    }

    protected static InputStream getBundleInputStream(String uri, Map<String, File> downloads) throws IOException {
        InputStream is;
        File file = downloads.get(uri);
        if (file != null) {
            is = new FileInputStream(file);
        } else {
            LOGGER.warn("Bundle " + uri + " not found in the downloads, using direct input stream instead");
            is = new URL(uri).openStream();
        }
        return is;
    }

    private List<Bundle> getBundlesToDestroy(List<Bundle> bundles) {
        ArrayList<Bundle> bundlesToDestroy = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            ServiceReference[] references = bundle.getRegisteredServices();
            int usage = 0;
            if (references != null) {
                for (ServiceReference reference : references) {
                    usage += DeploymentAgent.getServiceUsage(reference, bundles);
                }
            }
            LOGGER.debug("Usage for bundle {} is {}", (Object)bundle, (Object)usage);
            if (usage != 0) continue;
            bundlesToDestroy.add(bundle);
        }
        if (!bundlesToDestroy.isEmpty()) {
            Collections.sort(bundlesToDestroy, new Comparator<Bundle>(){

                @Override
                public int compare(Bundle b1, Bundle b2) {
                    return (int)(b2.getLastModified() - b1.getLastModified());
                }
            });
            LOGGER.debug("Selected bundles {} for destroy (no services in use)", bundlesToDestroy);
        } else {
            ServiceReference ref = null;
            for (Bundle bundle : bundles) {
                ServiceReference[] references;
                for (ServiceReference reference : references = bundle.getRegisteredServices()) {
                    if (DeploymentAgent.getServiceUsage(reference, bundles) == 0 || ref != null && reference.compareTo(ref) >= 0) continue;
                    LOGGER.debug("Currently selecting bundle {} for destroy (with reference {})", (Object)bundle, (Object)reference);
                    ref = reference;
                }
            }
            if (ref != null) {
                bundlesToDestroy.add(ref.getBundle());
            }
            LOGGER.debug("Selected bundle {} for destroy (lowest ranking service)", bundlesToDestroy);
        }
        return bundlesToDestroy;
    }

    private static int getServiceUsage(ServiceReference ref, List<Bundle> bundles) {
        Bundle[] usingBundles = ref.getUsingBundles();
        int nb = 0;
        if (usingBundles != null) {
            for (Bundle bundle : usingBundles) {
                if (!bundles.contains(bundle)) continue;
                ++nb;
            }
        }
        return nb;
    }

    private VersionRange getMicroVersionRange(Version version) {
        Version floor = new Version(version.getMajor(), version.getMinor(), 0);
        Version ceil = new Version(version.getMajor(), version.getMinor() + 1, 0);
        return new VersionRange(false, floor, ceil, true);
    }

    protected void findBundlesWithFragmentsToRefresh(Set<Bundle> toRefresh) {
        HashSet<Bundle> fragments = new HashSet<Bundle>();
        for (Bundle b : toRefresh) {
            Clause[] clauses;
            String hostHeader;
            if (b.getState() == 1 || (hostHeader = (String)b.getHeaders().get("Fragment-Host")) == null || (clauses = org.apache.felix.utils.manifest.Parser.parseHeader(hostHeader)) == null || clauses.length <= 0) continue;
            Clause path = clauses[0];
            for (Bundle hostBundle : this.systemBundleContext.getBundles()) {
                if (!hostBundle.getSymbolicName().equals(path.getName())) continue;
                String ver = path.getAttribute("bundle-version");
                if (ver != null) {
                    VersionRange v = VersionRange.parseVersionRange(ver);
                    if (!v.contains(hostBundle.getVersion())) continue;
                    fragments.add(hostBundle);
                    continue;
                }
                fragments.add(hostBundle);
            }
        }
        toRefresh.addAll(fragments);
    }

    protected void findBundlesWithOptionalPackagesToRefresh(Set<Bundle> toRefresh) {
        List importsList;
        HashSet<Bundle> bundles = new HashSet<Bundle>(Arrays.asList(this.systemBundleContext.getBundles()));
        bundles.removeAll(toRefresh);
        if (bundles.isEmpty()) {
            return;
        }
        HashMap<Bundle, List> imports = new HashMap<Bundle, List>();
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            Bundle b = (Bundle)it.next();
            String importsStr = (String)b.getHeaders().get("Import-Package");
            importsList = this.getOptionalImports(importsStr);
            if (importsList.isEmpty()) {
                it.remove();
                continue;
            }
            imports.put(b, importsList);
        }
        if (bundles.isEmpty()) {
            return;
        }
        ArrayList<Clause> exports = new ArrayList<Clause>();
        for (Bundle b : toRefresh) {
            String exportsStr;
            if (b.getState() == 1 || (exportsStr = (String)b.getHeaders().get("Export-Package")) == null) continue;
            Clause[] exportsList = org.apache.felix.utils.manifest.Parser.parseHeader(exportsStr);
            exports.addAll(Arrays.asList(exportsList));
        }
        Iterator it2 = bundles.iterator();
        while (it2.hasNext()) {
            Bundle b;
            b = (Bundle)it2.next();
            importsList = (List)imports.get(b);
            Iterator itpi = importsList.iterator();
            while (itpi.hasNext()) {
                Clause pi = (Clause)itpi.next();
                boolean matching = false;
                for (Clause pe : exports) {
                    Version exported;
                    if (!pi.getName().equals(pe.getName())) continue;
                    String evStr = pe.getAttribute("version");
                    String ivStr = pi.getAttribute("version");
                    VersionRange imported = ivStr != null ? VersionRange.parseVersionRange(ivStr) : VersionRange.ANY_VERSION;
                    if (!imported.contains(exported = evStr != null ? Version.parseVersion((String)evStr) : Version.emptyVersion)) continue;
                    matching = true;
                    break;
                }
                if (matching) continue;
                itpi.remove();
            }
            if (!importsList.isEmpty()) continue;
            it2.remove();
        }
        toRefresh.addAll(bundles);
    }

    protected List<Clause> getOptionalImports(String importsStr) {
        Clause[] imports = org.apache.felix.utils.manifest.Parser.parseHeader(importsStr);
        LinkedList<Clause> result = new LinkedList<Clause>();
        for (int i = 0; i < imports.length; ++i) {
            String resolution = imports[i].getDirective("resolution");
            if (!"optional".equals(resolution)) continue;
            result.add(imports[i]);
        }
        return result;
    }

    protected boolean updateFramework(Properties properties, String url) throws Exception {
        if (!url.startsWith("mvn:")) {
            throw new IllegalArgumentException("Framework url must use the mvn: protocol");
        }
        File file = ((DownloadFuture)this.manager.download(url).await()).getFile();
        String path = file.getPath();
        if (path.startsWith(System.getProperty("karaf.home"))) {
            path = path.substring(System.getProperty("karaf.home").length() + 1);
        }
        if (!path.equals(properties.get("karaf.framework.felix"))) {
            properties.put("karaf.framework", "felix");
            properties.put("karaf.framework.felix", path);
            return true;
        }
        return false;
    }

    protected Map<String, File> downloadBundles(Set<Feature> features, Set<String> bundles, Set<String> overrides) throws Exception {
        HashSet<String> locations = new HashSet<String>();
        for (Feature feature : features) {
            for (BundleInfo bundle : feature.getBundles()) {
                locations.add(bundle.getLocation());
            }
        }
        for (String bundle : bundles) {
            locations.add(bundle);
        }
        for (String override : overrides) {
            locations.add(override);
        }
        final CountDownLatch latch = new CountDownLatch(locations.size());
        final ConcurrentHashMap<String, File> downloads = new ConcurrentHashMap<String, File>();
        final CopyOnWriteArrayList<Throwable> errors = new CopyOnWriteArrayList<Throwable>();
        for (final String location : locations) {
            if (!location.startsWith(FAB_PROTOCOL)) {
                this.manager.download(location).addListener(new FutureListener<DownloadFuture>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void operationComplete(DownloadFuture future) {
                        try {
                            downloads.put(location, future.getFile());
                        }
                        catch (Throwable e) {
                            errors.add(e);
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
                continue;
            }
            latch.countDown();
        }
        latch.await();
        if (!errors.isEmpty()) {
            throw new MultiException("Error while downloading bundles", errors);
        }
        return downloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent event) {
        Object object;
        if (event.getType() == 4) {
            object = this.refreshLock;
            synchronized (object) {
                this.refreshLock.notifyAll();
            }
        }
        if (event.getType() == 2) {
            LOGGER.error("Framework error", event.getThrowable());
            object = this.refreshLock;
            synchronized (object) {
                this.refreshLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshPackages(Bundle[] bundles) throws InterruptedException {
        if (this.getPackageAdmin() != null) {
            Object object = this.refreshLock;
            synchronized (object) {
                this.getPackageAdmin().refreshPackages(bundles);
                this.refreshLock.wait(this.refreshTimeout);
            }
        }
    }

    protected synchronized ExecutorService getDownloadExecutor() {
        if (this.downloadExecutor == null) {
            if (this.executorServiceFinder == null) {
                try {
                    this.executorServiceFinder = new FelixExecutorServiceFinder();
                    this.downloadExecutor = this.executorServiceFinder.find(this.bundleContext.getBundle());
                }
                catch (Throwable t) {
                    LOGGER.warn("Cannot find reference to MonitoringService. This exception will be ignored.", t);
                }
            }
            if (this.downloadExecutor == null) {
                LOGGER.info("Creating a new fixed thread pool for download manager.");
                this.downloadExecutor = Executors.newFixedThreadPool(5);
                this.shutdownDownloadExecutor = true;
            } else {
                LOGGER.info("Using Felix thread pool for download manager.");
                this.shutdownDownloadExecutor = false;
            }
        }
        return this.downloadExecutor;
    }

    class FabricFabConfiguration
    extends PropertyStore
    implements Configuration {
        final DictionaryPropertyResolver propertyResolver;
        final MavenConfigurationImpl config;

        FabricFabConfiguration(MavenConfigurationImpl config, DictionaryPropertyResolver propertyResolver) {
            this.propertyResolver = propertyResolver;
            this.config = config;
        }

        @Override
        public String[] getSharedResourcePaths() {
            if (!this.contains("org.fusesource.fabric.fab.osgi.url.sharedResourcePaths")) {
                String text = this.propertyResolver.get("org.fusesource.fabric.fab.osgi.url.sharedResourcePaths");
                String[] repositories = text == null || text.length() == 0 ? ServiceConstants.DEFAULT_PROPERTY_SHARED_RESOURCE_PATHS : this.toArray(text);
                return this.set("org.fusesource.fabric.fab.osgi.url.sharedResourcePaths", repositories);
            }
            return (String[])this.get("org.fusesource.fabric.fab.osgi.url.sharedResourcePaths");
        }

        @Override
        public boolean getCertificateCheck() {
            return this.config.getCertificateCheck();
        }

        @Override
        public boolean isInstallMissingDependencies() {
            return false;
        }

        @Override
        public MavenResolver getResolver() {
            try {
                MavenResolverImpl resolver = new MavenResolverImpl();
                ArrayList<String> repos = new ArrayList<String>();
                for (MavenRepositoryURL url : this.config.getRepositories()) {
                    repos.add(url.getURL().toURI().toString());
                }
                resolver.setRepositories(repos.toArray(new String[repos.size()]));
                resolver.setLocalRepo(new File(this.config.getLocalRepository().getURL().toURI()).getAbsolutePath());
                return resolver;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        protected String[] toArray(String text) {
            String[] answer = null;
            if (text != null) {
                answer = text.split(",");
            }
            return answer;
        }
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String prefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = prefix + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    class FelixExecutorServiceFinder
    implements ExecutorServiceFinder {
        ServiceReference sr;

        FelixExecutorServiceFinder() {
            this.sr = DeploymentAgent.this.bundleContext.getServiceReference(MonitoringService.class.getName());
            if (this.sr == null) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public ExecutorService find(Bundle bundle) {
            return ((MonitoringService)DeploymentAgent.this.bundleContext.getService(this.sr)).getExecutor(bundle);
        }
    }

    static interface ExecutorServiceFinder {
        public ExecutorService find(Bundle var1);
    }
}

