/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.commands.fab;

import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.fab.osgi.commands.fab.ProcessUnusedBundles;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="uninstall", scope="fab", description="Uninstalls the Fabric Bundle along with all of its transitive dependencies which are not being used by other bundles")
public class UninstallCommand
extends ProcessUnusedBundles {
    private static final transient Logger LOG = LoggerFactory.getLogger(UninstallCommand.class);

    @Override
    protected void processBundle(Bundle bundle) {
        this.stopBundle(bundle);
        if (bundle.getState() != 1) {
            LOG.debug("Uninstalling bundle %s version %s", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
            try {
                bundle.uninstall();
            }
            catch (BundleException e) {
                System.out.println("Failed to start " + bundle.getSymbolicName() + " " + bundle.getVersion() + ". " + (Object)((Object)e));
                e.printStackTrace();
            }
        }
    }
}

