/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import org.apache.commons.logging.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;

public class SingleImporterFastShutdown
implements ApplicationListener {
    private final Log log;

    public SingleImporterFastShutdown(Log log) {
        this.log = log;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent) {
            ApplicationContext context = ((ContextClosedEvent)event).getApplicationContext();
            System.out.println("Trying to get the bean names...");
            String[] beanNamesForType = context.getBeanNamesForType(OsgiServiceProxyFactoryBean.class, true, false);
            for (int i = 0; i < beanNamesForType.length; ++i) {
                String string = beanNamesForType[i];
                System.out.println("found importers ... " + string);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Resetting importers (on shutdown): " + beanNamesForType));
            }
        }
    }
}

