/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.karaf.commands;

import java.io.File;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="activemq", name="destroy-broker", description="Destory a broker instance.")
public class DestroyBrokerCommand
extends OsgiCommandSupport {
    @Option(name="-n", aliases={"--name"}, description="The name of the broker (defaults to localhost).")
    private String name = "localhost";

    protected Object doExecute() throws Exception {
        try {
            String name = this.getName();
            File base = new File(System.getProperty("karaf.base"));
            File deploy = new File(base, "deploy");
            File configFile = new File(deploy, name + "-broker.xml");
            configFile.delete();
            System.out.println("");
            System.out.println("Default ActiveMQ Broker (" + name + ") configuration file created at: " + configFile.getPath() + " removed.");
            System.out.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return 0;
    }

    public String getName() {
        if (this.name == null) {
            File base = new File(System.getProperty("karaf.base"));
            this.name = base.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

