/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.boot.commands;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateContainerOptionsBuilder;
import org.fusesource.fabric.api.CreateSshContainerOptions;
import org.fusesource.fabric.boot.commands.support.ContainerCreateSupport;

@Command(name="container-create-ssh", scope="fabric", description="Creates one or more new containers via SSH", detailedDescription="classpath:containerCreateSsh.txt")
public class ContainerCreateSsh
extends ContainerCreateSupport {
    @Option(name="--host", required=true, description="Host name to SSH into")
    private String host;
    @Option(name="--path", description="Path on the remote filesystem where the container is to be installed.")
    private String path;
    @Option(name="--user", description="User name for login.")
    private String user;
    @Option(name="--password", description="Password for login. If the password is omitted, private key authentication is used instead.")
    private String password;
    @Option(name="--port", description="The IP port number for the SSH connection.")
    private Integer port;
    @Option(name="--ssh-retries", description="Number of retries to connect on SSH")
    private Integer sshRetries;
    @Option(name="--proxy-uri", description="Maven proxy URL to use")
    private URI proxyUri;
    @Option(name="--private-key", description="The path to the private key on the filesystem. Default is ~/.ssh/id_rsa on *NIX platforms or C:\\Documents and Settings\\<UserName>\\.ssh\\id_rsa on Windows.")
    private String privateKeyFile;
    @Option(name="--pass-phrase", description="The pass phrase of the key. This is for use with private keys that require a pass phrase.")
    private String passPhrase;
    @Argument(index=0, required=true, description="The name of the container to be created. When creating multiple containers it serves as a prefix")
    protected String name;
    @Argument(index=1, required=false, description="The number of containers that should be created")
    protected int number = 1;

    protected Object doExecute() throws Exception {
        this.preCreateContainer(this.name);
        CreateSshContainerOptions options = (CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)CreateContainerOptionsBuilder.ssh().name(this.name)).resolver(this.resolver)).ensembleServer(this.isEnsembleServer.booleanValue())).number(this.number)).host(this.host).username(this.user).password(this.password).privateKeyFile(this.privateKeyFile != null ? this.privateKeyFile : CreateSshContainerOptions.DEFAULT_PRIVATE_KEY_FILE).passPhrase(this.passPhrase).path(this.path).port(this.port).sshRetries(this.sshRetries).password(this.password).proxyUri(this.proxyUri != null ? this.proxyUri : this.fabricService.getMavenRepoURI())).zookeeperUrl(this.fabricService.getZookeeperUrl())).jvmOpts(this.jvmOpts);
        CreateContainerMetadata[] metadatas = this.fabricService.createContainers((CreateContainerOptions)options);
        this.displayContainers(metadatas);
        this.postCreateContainers(metadatas);
        return null;
    }

    @Override
    protected void preCreateContainer(String name) {
        super.preCreateContainer(name);
        if (this.number < 1 || this.number > 99) {
            throw new IllegalArgumentException("The number of containers must be between 1 and 99.");
        }
        try {
            InetAddress[] localIps = InetAddress.getAllByName(InetAddress.getLocalHost().getCanonicalHostName());
            for (InetAddress address : InetAddress.getAllByName(this.host)) {
                if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
                    throw new IllegalArgumentException("Container creation not permitted locally");
                }
                for (InetAddress local : localIps) {
                    if (!local.equals(address)) continue;
                    throw new IllegalArgumentException("Container creation not permitted locally");
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to find host address: " + this.host, e);
        }
    }
}

