/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.apache.activemq.Service;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.region.AbstractRegion;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.NetworkBridgeFilter;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.network.DefaultNetworkBridgeFilterFactory;
import org.apache.activemq.network.DemandSubscription;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkBridgeFilterFactory;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.thread.DefaultThreadPools;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportDisposedIOException;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.tcp.SslTransport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.activemq.util.MarshallingSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DemandForwardingBridgeSupport
implements NetworkBridge,
BrokerServiceAware {
    private static final Logger LOG = LoggerFactory.getLogger(DemandForwardingBridgeSupport.class);
    private final TaskRunnerFactory asyncTaskRunner = DefaultThreadPools.getDefaultTaskRunnerFactory();
    protected static final String DURABLE_SUB_PREFIX = "NC-DS_";
    protected final Transport localBroker;
    protected final Transport remoteBroker;
    protected final IdGenerator idGenerator = new IdGenerator();
    protected final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    protected ConnectionInfo localConnectionInfo;
    protected ConnectionInfo remoteConnectionInfo;
    protected SessionInfo localSessionInfo;
    protected ProducerInfo producerInfo;
    protected String remoteBrokerName = "Unknown";
    protected String localClientId;
    protected ConsumerInfo demandConsumerInfo;
    protected int demandConsumerDispatched;
    protected final AtomicBoolean localBridgeStarted = new AtomicBoolean(false);
    protected final AtomicBoolean remoteBridgeStarted = new AtomicBoolean(false);
    protected AtomicBoolean disposed = new AtomicBoolean();
    protected BrokerId localBrokerId;
    protected ActiveMQDestination[] excludedDestinations;
    protected ActiveMQDestination[] dynamicallyIncludedDestinations;
    protected ActiveMQDestination[] staticallyIncludedDestinations;
    protected ActiveMQDestination[] durableDestinations;
    protected final ConcurrentHashMap<ConsumerId, DemandSubscription> subscriptionMapByLocalId = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ConsumerId, DemandSubscription> subscriptionMapByRemoteId = new ConcurrentHashMap();
    protected final BrokerId[] localBrokerPath = new BrokerId[]{null};
    protected CountDownLatch startedLatch = new CountDownLatch(2);
    protected CountDownLatch localStartedLatch = new CountDownLatch(1);
    protected final AtomicBoolean lastConnectSucceeded = new AtomicBoolean(false);
    protected NetworkBridgeConfiguration configuration;
    protected final NetworkBridgeFilterFactory defaultFilterFactory = new DefaultNetworkBridgeFilterFactory();
    protected final BrokerId[] remoteBrokerPath = new BrokerId[]{null};
    protected Object brokerInfoMutex = new Object();
    protected BrokerId remoteBrokerId;
    final AtomicLong enqueueCounter = new AtomicLong();
    final AtomicLong dequeueCounter = new AtomicLong();
    private NetworkBridgeListener networkBridgeListener;
    private boolean createdByDuplex;
    private BrokerInfo localBrokerInfo;
    private BrokerInfo remoteBrokerInfo;
    private final AtomicBoolean started = new AtomicBoolean();
    private TransportConnection duplexInitiatingConnection;
    private BrokerService brokerService = null;
    private ObjectName mbeanObjectName;

    public DemandForwardingBridgeSupport(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        this.configuration = configuration;
        this.localBroker = localBroker;
        this.remoteBroker = remoteBroker;
    }

    public void duplexStart(TransportConnection connection, BrokerInfo localBrokerInfo, BrokerInfo remoteBrokerInfo) throws Exception {
        this.localBrokerInfo = localBrokerInfo;
        this.remoteBrokerInfo = remoteBrokerInfo;
        this.duplexInitiatingConnection = connection;
        this.start();
        this.serviceRemoteCommand(remoteBrokerInfo);
    }

    @Override
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.localBroker.setTransportListener(new DefaultTransportListener(){

                @Override
                public void onCommand(Object o) {
                    Command command = (Command)o;
                    DemandForwardingBridgeSupport.this.serviceLocalCommand(command);
                }

                @Override
                public void onException(IOException error) {
                    DemandForwardingBridgeSupport.this.serviceLocalException(error);
                }
            });
            this.remoteBroker.setTransportListener(new DefaultTransportListener(){

                @Override
                public void onCommand(Object o) {
                    Command command = (Command)o;
                    DemandForwardingBridgeSupport.this.serviceRemoteCommand(command);
                }

                @Override
                public void onException(IOException error) {
                    DemandForwardingBridgeSupport.this.serviceRemoteException(error);
                }
            });
            this.localBroker.start();
            this.remoteBroker.start();
            if (!this.disposed.get()) {
                try {
                    this.triggerRemoteStartBridge();
                }
                catch (IOException e) {
                    LOG.warn("Caught exception from remote start", (Throwable)e);
                }
            } else {
                LOG.warn("Bridge was disposed before the start() method was fully executed.");
                throw new TransportDisposedIOException();
            }
        }
    }

    protected void triggerLocalStartBridge() throws IOException {
        this.asyncTaskRunner.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String originalName = Thread.currentThread().getName();
                Thread.currentThread().setName("StartLocalBridge: localBroker=" + DemandForwardingBridgeSupport.this.localBroker);
                try {
                    DemandForwardingBridgeSupport.this.startLocalBridge();
                }
                catch (Throwable e) {
                    DemandForwardingBridgeSupport.this.serviceLocalException(e);
                }
                finally {
                    Thread.currentThread().setName(originalName);
                }
            }
        });
    }

    protected void triggerRemoteStartBridge() throws IOException {
        this.asyncTaskRunner.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String originalName = Thread.currentThread().getName();
                Thread.currentThread().setName("StartRemoteBridge: remoteBroker=" + DemandForwardingBridgeSupport.this.remoteBroker);
                try {
                    DemandForwardingBridgeSupport.this.startRemoteBridge();
                }
                catch (Exception e) {
                    DemandForwardingBridgeSupport.this.serviceRemoteException(e);
                }
                finally {
                    Thread.currentThread().setName(originalName);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLocalBridge() throws Throwable {
        if (this.localBridgeStarted.compareAndSet(false, true)) {
            DemandForwardingBridgeSupport demandForwardingBridgeSupport = this;
            synchronized (demandForwardingBridgeSupport) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this.configuration.getBrokerName() + " starting local Bridge, localBroker=" + this.localBroker);
                }
                if (!this.disposed.get()) {
                    Object resp;
                    this.localConnectionInfo = new ConnectionInfo();
                    this.localConnectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
                    this.localClientId = this.configuration.getName() + "_" + this.remoteBrokerName + "_inbound_" + this.configuration.getBrokerName();
                    this.localConnectionInfo.setClientId(this.localClientId);
                    this.localConnectionInfo.setUserName(this.configuration.getUserName());
                    this.localConnectionInfo.setPassword(this.configuration.getPassword());
                    Transport originalTransport = this.remoteBroker;
                    while (originalTransport instanceof TransportFilter) {
                        originalTransport = ((TransportFilter)originalTransport).getNext();
                    }
                    if (originalTransport instanceof SslTransport) {
                        X509Certificate[] peerCerts = ((SslTransport)originalTransport).getPeerCertificates();
                        this.localConnectionInfo.setTransportContext(peerCerts);
                    }
                    if ((resp = this.localBroker.request(this.localConnectionInfo)) instanceof ExceptionResponse) {
                        throw ((ExceptionResponse)resp).getException();
                    }
                    this.localSessionInfo = new SessionInfo(this.localConnectionInfo, 1L);
                    this.localBroker.oneway(this.localSessionInfo);
                    this.brokerService.getBroker().networkBridgeStarted(this.remoteBrokerInfo, this.createdByDuplex, this.remoteBroker.toString());
                    NetworkBridgeListener l = this.networkBridgeListener;
                    if (l != null) {
                        l.onStart(this);
                    }
                    LOG.info("Network connection between " + this.localBroker + " and " + this.remoteBroker + "(" + this.remoteBrokerName + ") has been established.");
                } else {
                    LOG.warn("Bridge was disposed before the startLocalBridge() method was fully executed.");
                }
                this.startedLatch.countDown();
                this.localStartedLatch.countDown();
                this.safeWaitUntilStarted();
                if (!this.disposed.get()) {
                    this.setupStaticDestinations();
                } else {
                    LOG.warn("Network connection between " + this.localBroker + " and " + this.remoteBroker + "(" + this.remoteBrokerName + ") was interrupted during establishment.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRemoteBridge() throws Exception {
        if (this.remoteBridgeStarted.compareAndSet(false, true)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.configuration.getBrokerName() + " starting remote Bridge, remoteBroker=" + this.remoteBroker);
            }
            DemandForwardingBridgeSupport demandForwardingBridgeSupport = this;
            synchronized (demandForwardingBridgeSupport) {
                if (!this.isCreatedByDuplex()) {
                    BrokerInfo brokerInfo = new BrokerInfo();
                    brokerInfo.setBrokerName(this.configuration.getBrokerName());
                    brokerInfo.setBrokerURL(this.configuration.getBrokerURL());
                    brokerInfo.setNetworkConnection(true);
                    brokerInfo.setDuplexConnection(this.configuration.isDuplex());
                    Properties props = new Properties();
                    IntrospectionSupport.getProperties(this.configuration, props, null);
                    String str = MarshallingSupport.propertiesToString(props);
                    brokerInfo.setNetworkProperties(str);
                    brokerInfo.setBrokerId(this.localBrokerId);
                    this.remoteBroker.oneway(brokerInfo);
                }
                if (this.remoteConnectionInfo != null) {
                    this.remoteBroker.oneway(this.remoteConnectionInfo.createRemoveCommand());
                }
                this.remoteConnectionInfo = new ConnectionInfo();
                this.remoteConnectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
                this.remoteConnectionInfo.setClientId(this.configuration.getName() + "_" + this.configuration.getBrokerName() + "_outbound");
                this.remoteConnectionInfo.setUserName(this.configuration.getUserName());
                this.remoteConnectionInfo.setPassword(this.configuration.getPassword());
                this.remoteBroker.oneway(this.remoteConnectionInfo);
                SessionInfo remoteSessionInfo = new SessionInfo(this.remoteConnectionInfo, 1L);
                this.remoteBroker.oneway(remoteSessionInfo);
                this.producerInfo = new ProducerInfo(remoteSessionInfo, 1L);
                this.producerInfo.setResponseRequired(false);
                this.remoteBroker.oneway(this.producerInfo);
                if (!this.configuration.isStaticBridge()) {
                    this.demandConsumerInfo = new ConsumerInfo(remoteSessionInfo, 1L);
                    this.demandConsumerInfo.setDispatchAsync(this.configuration.isDispatchAsync());
                    String advisoryTopic = this.configuration.getDestinationFilter();
                    if (this.configuration.isBridgeTempDestinations()) {
                        advisoryTopic = advisoryTopic + "," + AdvisorySupport.TEMP_DESTINATION_COMPOSITE_ADVISORY_TOPIC;
                    }
                    this.demandConsumerInfo.setDestination(new ActiveMQTopic(advisoryTopic));
                    this.demandConsumerInfo.setPrefetchSize(this.configuration.getPrefetchSize());
                    this.remoteBroker.oneway(this.demandConsumerInfo);
                }
                this.startedLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            if (this.disposed.compareAndSet(false, true)) {
                LOG.debug(" stopping " + this.configuration.getBrokerName() + " bridge to " + this.remoteBrokerName);
                NetworkBridgeListener l = this.networkBridgeListener;
                if (l != null) {
                    l.onStop(this);
                }
                try {
                    this.remoteBridgeStarted.set(false);
                    final CountDownLatch sendShutdown = new CountDownLatch(1);
                    this.asyncTaskRunner.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                DemandForwardingBridgeSupport.this.localBroker.oneway(new ShutdownInfo());
                                sendShutdown.countDown();
                                DemandForwardingBridgeSupport.this.remoteBroker.oneway(new ShutdownInfo());
                            }
                            catch (Throwable e) {
                                LOG.debug("Caught exception sending shutdown", e);
                            }
                            finally {
                                sendShutdown.countDown();
                            }
                        }
                    });
                    if (!sendShutdown.await(10L, TimeUnit.SECONDS)) {
                        LOG.info("Network Could not shutdown in a timely manner");
                    }
                }
                finally {
                    ServiceStopper ss = new ServiceStopper();
                    ss.stop(this.remoteBroker);
                    ss.stop(this.localBroker);
                    this.startedLatch.countDown();
                    this.startedLatch.countDown();
                    this.localStartedLatch.countDown();
                    ss.throwFirstException();
                }
            }
            if (this.remoteBrokerInfo != null) {
                this.brokerService.getBroker().removeBroker(null, this.remoteBrokerInfo);
                this.brokerService.getBroker().networkBridgeStopped(this.remoteBrokerInfo);
                LOG.info(this.configuration.getBrokerName() + " bridge to " + this.remoteBrokerName + " stopped");
            }
        }
    }

    @Override
    public void serviceRemoteException(Throwable error) {
        if (!this.disposed.get()) {
            if (error instanceof SecurityException || error instanceof GeneralSecurityException) {
                LOG.error("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown due to a remote error: " + error);
            } else {
                LOG.warn("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown due to a remote error: " + error);
            }
            LOG.debug("The remote Exception was: " + error, error);
            this.asyncTaskRunner.execute(new Runnable(){

                @Override
                public void run() {
                    ServiceSupport.dispose(DemandForwardingBridgeSupport.this.getControllingService());
                }
            });
            this.fireBridgeFailed();
        }
    }

    protected void serviceRemoteCommand(Command command) {
        block35: {
            if (!this.disposed.get()) {
                try {
                    if (command.isMessageDispatch()) {
                        this.safeWaitUntilStarted();
                        MessageDispatch md = (MessageDispatch)command;
                        this.serviceRemoteConsumerAdvisory(md.getMessage().getDataStructure());
                        this.ackAdvisory(md.getMessage());
                        break block35;
                    }
                    if (command.isBrokerInfo()) {
                        this.lastConnectSucceeded.set(true);
                        this.remoteBrokerInfo = (BrokerInfo)command;
                        Properties props = MarshallingSupport.stringToProperties(this.remoteBrokerInfo.getNetworkProperties());
                        try {
                            IntrospectionSupport.getProperties(this.configuration, props, null);
                            if (this.configuration.getExcludedDestinations() != null) {
                                this.excludedDestinations = this.configuration.getExcludedDestinations().toArray(new ActiveMQDestination[this.configuration.getExcludedDestinations().size()]);
                            }
                            if (this.configuration.getStaticallyIncludedDestinations() != null) {
                                this.staticallyIncludedDestinations = this.configuration.getStaticallyIncludedDestinations().toArray(new ActiveMQDestination[this.configuration.getStaticallyIncludedDestinations().size()]);
                            }
                            if (this.configuration.getDynamicallyIncludedDestinations() != null) {
                                this.dynamicallyIncludedDestinations = this.configuration.getDynamicallyIncludedDestinations().toArray(new ActiveMQDestination[this.configuration.getDynamicallyIncludedDestinations().size()]);
                            }
                        }
                        catch (Throwable t) {
                            LOG.error("Error mapping remote destinations", t);
                        }
                        this.serviceRemoteBrokerInfo(command);
                        this.localBroker.oneway(command);
                        this.brokerService.getBroker().addBroker(null, this.remoteBrokerInfo);
                        break block35;
                    }
                    if (command.getClass() == ConnectionError.class) {
                        ConnectionError ce = (ConnectionError)command;
                        this.serviceRemoteException(ce.getException());
                        break block35;
                    }
                    if (this.isDuplex()) {
                        if (command.isMessage()) {
                            ActiveMQMessage message = (ActiveMQMessage)command;
                            if (AdvisorySupport.isConsumerAdvisoryTopic(message.getDestination()) || AdvisorySupport.isDestinationAdvisoryTopic(message.getDestination())) {
                                this.serviceRemoteConsumerAdvisory(message.getDataStructure());
                                this.ackAdvisory(message);
                            } else {
                                if (!this.isPermissableDestination(message.getDestination(), true)) {
                                    return;
                                }
                                if (message.isResponseRequired()) {
                                    Response reply = new Response();
                                    reply.setCorrelationId(message.getCommandId());
                                    this.localBroker.oneway(message);
                                    this.remoteBroker.oneway(reply);
                                } else {
                                    this.localBroker.oneway(message);
                                }
                            }
                            break block35;
                        }
                        switch (command.getDataStructureType()) {
                            case 3: 
                            case 4: 
                            case 6: {
                                this.localBroker.oneway(command);
                                break;
                            }
                            case 22: {
                                MessageAck ack = (MessageAck)command;
                                DemandSubscription localSub = this.subscriptionMapByRemoteId.get(ack.getConsumerId());
                                if (localSub != null) {
                                    ack.setConsumerId(localSub.getLocalInfo().getConsumerId());
                                    this.localBroker.oneway(ack);
                                    break;
                                }
                                LOG.warn("Matching local subscription not found for ack: " + ack);
                                break;
                            }
                            case 5: {
                                this.localStartedLatch.await();
                                if (this.started.get()) {
                                    if (!this.addConsumerInfo((ConsumerInfo)command)) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug("Ignoring ConsumerInfo: " + command);
                                            break;
                                        }
                                    } else if (LOG.isTraceEnabled()) {
                                        LOG.trace("Adding ConsumerInfo: " + command);
                                        break;
                                    }
                                    break block35;
                                }
                                LOG.warn("Stopping - ignoring ConsumerInfo: " + command);
                                break;
                            }
                            case 11: {
                                LOG.info("Stopping network bridge on shutdown of remote broker");
                                this.serviceRemoteException(new IOException(command.toString()));
                                break;
                            }
                            default: {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Ignoring remote command: " + command);
                                    break;
                                }
                                break block35;
                            }
                        }
                        break block35;
                    }
                    switch (command.getDataStructureType()) {
                        case 1: 
                        case 10: 
                        case 11: {
                            break;
                        }
                        default: {
                            LOG.warn("Unexpected remote command: " + command);
                        }
                    }
                }
                catch (Throwable e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Exception processing remote command: " + command, e);
                    }
                    this.serviceRemoteException(e);
                }
            }
        }
    }

    private void ackAdvisory(Message message) throws IOException {
        ++this.demandConsumerDispatched;
        if ((double)this.demandConsumerDispatched > (double)this.demandConsumerInfo.getPrefetchSize() * 0.75) {
            MessageAck ack = new MessageAck(message, 2, this.demandConsumerDispatched);
            ack.setConsumerId(this.demandConsumerInfo.getConsumerId());
            this.remoteBroker.oneway(ack);
            this.demandConsumerDispatched = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRemoteConsumerAdvisory(DataStructure data) throws IOException {
        int networkTTL = this.configuration.getNetworkTTL();
        if (data.getClass() == ConsumerInfo.class) {
            ConsumerInfo info = (ConsumerInfo)data;
            BrokerId[] path = info.getBrokerPath();
            if (info.isBrowser()) {
                if (LOG.isDebugEnabled()) {
                    LOG.info(this.configuration.getBrokerName() + " Ignoring sub from " + this.remoteBrokerName + ", browsers explicitly suppressed");
                }
                return;
            }
            if (path != null && path.length >= networkTTL) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getBrokerName() + " Ignoring sub from " + this.remoteBrokerName + ", restricted to " + networkTTL + " network hops only : " + info);
                }
                return;
            }
            if (DemandForwardingBridgeSupport.contains(path, this.localBrokerPath[0])) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getBrokerName() + " Ignoring sub from " + this.remoteBrokerName + ", already routed through this broker once : " + info);
                }
                return;
            }
            if (!this.isPermissableDestination(info.getDestination())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getBrokerName() + " Ignoring sub from " + this.remoteBrokerName + ", destination " + info.getDestination() + " is not permiited :" + info);
                }
                return;
            }
            URI uRI = this.brokerService.getVmConnectorURI();
            synchronized (uRI) {
                if (this.addConsumerInfo(info)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.configuration.getBrokerName() + " bridged sub on " + this.localBroker + " from " + this.remoteBrokerName + " : " + info);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getBrokerName() + " Ignoring sub from " + this.remoteBrokerName + " as already subscribed to matching destination : " + info);
                }
            }
        } else if (data.getClass() == DestinationInfo.class) {
            DestinationInfo destInfo = (DestinationInfo)data;
            BrokerId[] path = destInfo.getBrokerPath();
            if (path != null && path.length >= networkTTL) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getBrokerName() + " Ignoring destination " + destInfo + " restricted to " + networkTTL + " network hops only");
                }
                return;
            }
            if (DemandForwardingBridgeSupport.contains(destInfo.getBrokerPath(), this.localBrokerPath[0])) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getBrokerName() + " Ignoring destination " + destInfo + " already routed through this broker once");
                }
                return;
            }
            destInfo.setConnectionId(this.localConnectionInfo.getConnectionId());
            if (destInfo.getDestination() instanceof ActiveMQTempDestination) {
                ActiveMQTempDestination tempDest = (ActiveMQTempDestination)destInfo.getDestination();
                tempDest.setConnectionId(this.localSessionInfo.getSessionId().getConnectionId());
            }
            destInfo.setBrokerPath(this.appendToBrokerPath(destInfo.getBrokerPath(), this.getRemoteBrokerPath()));
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.configuration.getBrokerName() + " bridging " + (destInfo.isAddOperation() ? "add" : "remove") + " destination on " + this.localBroker + " from " + this.remoteBrokerName + ", destination: " + destInfo);
            }
            this.localBroker.oneway(destInfo);
        } else if (data.getClass() == RemoveInfo.class) {
            ConsumerId id = (ConsumerId)((RemoveInfo)data).getObjectId();
            this.removeDemandSubscription(id);
        }
    }

    @Override
    public void serviceLocalException(Throwable error) {
        if (!this.disposed.get()) {
            LOG.info("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown due to a local error: " + error);
            LOG.debug("The local Exception was:" + error, error);
            this.asyncTaskRunner.execute(new Runnable(){

                @Override
                public void run() {
                    ServiceSupport.dispose(DemandForwardingBridgeSupport.this.getControllingService());
                }
            });
            this.fireBridgeFailed();
        }
    }

    protected Service getControllingService() {
        return this.duplexInitiatingConnection != null ? this.duplexInitiatingConnection : this;
    }

    protected void addSubscription(DemandSubscription sub) throws IOException {
        if (sub != null) {
            this.localBroker.oneway(sub.getLocalInfo());
        }
    }

    protected void removeSubscription(final DemandSubscription sub) throws IOException {
        if (sub != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.configuration.getBrokerName() + " remove local subscription for remote " + sub.getRemoteInfo().getConsumerId());
            }
            this.subscriptionMapByLocalId.remove(sub.getLocalInfo().getConsumerId());
            this.subscriptionMapByRemoteId.remove(sub.getRemoteInfo().getConsumerId());
            this.asyncTaskRunner.execute(new Runnable(){

                @Override
                public void run() {
                    sub.waitForCompletion();
                    try {
                        DemandForwardingBridgeSupport.this.localBroker.oneway(sub.getLocalInfo().createRemoveCommand());
                    }
                    catch (IOException e) {
                        LOG.warn("failed to deliver remove command for local subscription, for remote " + sub.getRemoteInfo().getConsumerId(), (Throwable)e);
                    }
                }
            });
        }
    }

    protected Message configureMessage(MessageDispatch md) throws IOException {
        Message message = md.getMessage().copy();
        message.setBrokerPath(this.appendToBrokerPath(message.getBrokerPath(), this.localBrokerPath));
        message.setProducerId(this.producerInfo.getProducerId());
        message.setDestination(md.getDestination());
        if (message.getOriginalTransactionId() == null) {
            message.setOriginalTransactionId(message.getTransactionId());
        }
        message.setTransactionId(null);
        if (this.configuration.isUseCompression()) {
            message.compress();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceLocalCommand(Command command) {
        block26: {
            if (!this.disposed.get()) {
                try {
                    if (command.isMessageDispatch()) {
                        this.safeWaitUntilStarted();
                        this.enqueueCounter.incrementAndGet();
                        final MessageDispatch md = (MessageDispatch)command;
                        final DemandSubscription sub = this.subscriptionMapByLocalId.get(md.getConsumerId());
                        if (sub != null && md.getMessage() != null && sub.incrementOutstandingResponses()) {
                            if (this.suppressMessageDispatch(md, sub)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(this.configuration.getBrokerName() + " message not forwarded to " + this.remoteBrokerName + " because message came from there or fails networkTTL, brokerPath: " + Arrays.toString(md.getMessage().getBrokerPath()) + ", message: " + md.getMessage());
                                }
                                try {
                                    this.localBroker.oneway(new MessageAck(md, 4, 1));
                                }
                                finally {
                                    sub.decrementOutstandingResponses();
                                }
                                return;
                            }
                            Message message = this.configureMessage(md);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("bridging (" + this.configuration.getBrokerName() + " -> " + this.remoteBrokerName + ") " + (LOG.isTraceEnabled() ? message : message.getMessageId()) + ", consumer: " + md.getConsumerId() + ", destination " + message.getDestination() + ", brokerPath: " + Arrays.toString(message.getBrokerPath()) + ", message: " + message);
                            }
                            if (!this.configuration.isAlwaysSyncSend() && !message.isPersistent()) {
                                try {
                                    this.remoteBroker.oneway(message);
                                    this.localBroker.oneway(new MessageAck(md, 4, 1));
                                    this.dequeueCounter.incrementAndGet();
                                    break block26;
                                }
                                finally {
                                    sub.decrementOutstandingResponses();
                                }
                            }
                            ResponseCallback callback = new ResponseCallback(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void onCompletion(FutureResponse future) {
                                    try {
                                        Response response = future.getResult();
                                        if (response.isException()) {
                                            ExceptionResponse er = (ExceptionResponse)response;
                                            DemandForwardingBridgeSupport.this.serviceLocalException(er.getException());
                                        } else {
                                            DemandForwardingBridgeSupport.this.localBroker.oneway(new MessageAck(md, 4, 1));
                                            DemandForwardingBridgeSupport.this.dequeueCounter.incrementAndGet();
                                        }
                                    }
                                    catch (IOException e) {
                                        DemandForwardingBridgeSupport.this.serviceLocalException(e);
                                    }
                                    finally {
                                        sub.decrementOutstandingResponses();
                                    }
                                }
                            };
                            this.remoteBroker.asyncRequest(message, callback);
                            break block26;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("No subscription registered with this network bridge for consumerId " + md.getConsumerId() + " for message: " + md.getMessage());
                        }
                        break block26;
                    }
                    if (command.isBrokerInfo()) {
                        this.localBrokerInfo = (BrokerInfo)command;
                        this.serviceLocalBrokerInfo(command);
                    } else if (command.isShutdownInfo()) {
                        LOG.info(this.configuration.getBrokerName() + " Shutting down");
                        this.stop();
                    } else if (command.getClass() == ConnectionError.class) {
                        ConnectionError ce = (ConnectionError)command;
                        this.serviceLocalException(ce.getException());
                    } else {
                        switch (command.getDataStructureType()) {
                            case 1: {
                                break;
                            }
                            default: {
                                LOG.warn("Unexpected local command: " + command);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.warn("Caught an exception processing local command", e);
                    this.serviceLocalException(e);
                }
            }
        }
    }

    private boolean suppressMessageDispatch(MessageDispatch md, DemandSubscription sub) throws Exception {
        boolean suppress = false;
        if (sub.getLocalInfo().isDurable()) {
            MessageEvaluationContext messageEvalContext = new MessageEvaluationContext();
            messageEvalContext.setMessageReference(md.getMessage());
            messageEvalContext.setDestination(md.getDestination());
            suppress = !sub.getNetworkBridgeFilter().matches(messageEvalContext);
        }
        return suppress;
    }

    public ActiveMQDestination[] getDynamicallyIncludedDestinations() {
        return this.dynamicallyIncludedDestinations;
    }

    public void setDynamicallyIncludedDestinations(ActiveMQDestination[] dynamicallyIncludedDestinations) {
        this.dynamicallyIncludedDestinations = dynamicallyIncludedDestinations;
    }

    public ActiveMQDestination[] getExcludedDestinations() {
        return this.excludedDestinations;
    }

    public void setExcludedDestinations(ActiveMQDestination[] excludedDestinations) {
        this.excludedDestinations = excludedDestinations;
    }

    public ActiveMQDestination[] getStaticallyIncludedDestinations() {
        return this.staticallyIncludedDestinations;
    }

    public void setStaticallyIncludedDestinations(ActiveMQDestination[] staticallyIncludedDestinations) {
        this.staticallyIncludedDestinations = staticallyIncludedDestinations;
    }

    public ActiveMQDestination[] getDurableDestinations() {
        return this.durableDestinations;
    }

    public void setDurableDestinations(ActiveMQDestination[] durableDestinations) {
        this.durableDestinations = durableDestinations;
    }

    public Transport getLocalBroker() {
        return this.localBroker;
    }

    public Transport getRemoteBroker() {
        return this.remoteBroker;
    }

    public boolean isCreatedByDuplex() {
        return this.createdByDuplex;
    }

    public void setCreatedByDuplex(boolean createdByDuplex) {
        this.createdByDuplex = createdByDuplex;
    }

    public static boolean contains(BrokerId[] brokerPath, BrokerId brokerId) {
        if (brokerPath != null) {
            for (int i = 0; i < brokerPath.length; ++i) {
                if (!brokerId.equals(brokerPath[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected BrokerId[] appendToBrokerPath(BrokerId[] brokerPath, BrokerId[] pathsToAppend) {
        if (brokerPath == null || brokerPath.length == 0) {
            return pathsToAppend;
        }
        BrokerId[] rc = new BrokerId[brokerPath.length + pathsToAppend.length];
        System.arraycopy(brokerPath, 0, rc, 0, brokerPath.length);
        System.arraycopy(pathsToAppend, 0, rc, brokerPath.length, pathsToAppend.length);
        return rc;
    }

    protected BrokerId[] appendToBrokerPath(BrokerId[] brokerPath, BrokerId idToAppend) {
        if (brokerPath == null || brokerPath.length == 0) {
            return new BrokerId[]{idToAppend};
        }
        BrokerId[] rc = new BrokerId[brokerPath.length + 1];
        System.arraycopy(brokerPath, 0, rc, 0, brokerPath.length);
        rc[brokerPath.length] = idToAppend;
        return rc;
    }

    protected boolean isPermissableDestination(ActiveMQDestination destination) {
        return this.isPermissableDestination(destination, false);
    }

    protected boolean isPermissableDestination(ActiveMQDestination destination, boolean allowTemporary) {
        DestinationFilter inclusionFilter;
        ActiveMQDestination match;
        int i;
        if (destination.isTemporary()) {
            if (allowTemporary) {
                return true;
            }
            return this.configuration.isBridgeTempDestinations();
        }
        ActiveMQDestination[] dests = this.staticallyIncludedDestinations;
        if (dests != null && dests.length > 0) {
            for (i = 0; i < dests.length; ++i) {
                match = dests[i];
                inclusionFilter = DestinationFilter.parseFilter(match);
                if (match == null || !inclusionFilter.matches(destination) || dests[i].getDestinationType() != destination.getDestinationType()) continue;
                return true;
            }
        }
        if ((dests = this.excludedDestinations) != null && dests.length > 0) {
            for (i = 0; i < dests.length; ++i) {
                match = dests[i];
                DestinationFilter exclusionFilter = DestinationFilter.parseFilter(match);
                if (match == null || !exclusionFilter.matches(destination) || dests[i].getDestinationType() != destination.getDestinationType()) continue;
                return false;
            }
        }
        if ((dests = this.dynamicallyIncludedDestinations) != null && dests.length > 0) {
            for (i = 0; i < dests.length; ++i) {
                match = dests[i];
                inclusionFilter = DestinationFilter.parseFilter(match);
                if (match == null || !inclusionFilter.matches(destination) || dests[i].getDestinationType() != destination.getDestinationType()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void setupStaticDestinations() {
        ActiveMQDestination[] dests = this.staticallyIncludedDestinations;
        if (dests != null) {
            for (int i = 0; i < dests.length; ++i) {
                ActiveMQDestination dest = dests[i];
                DemandSubscription sub = this.createDemandSubscription(dest);
                try {
                    this.addSubscription(sub);
                }
                catch (IOException e) {
                    LOG.error("Failed to add static destination " + dest, (Throwable)e);
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("bridging messages for static destination: " + dest);
            }
        }
    }

    protected boolean addConsumerInfo(ConsumerInfo consumerInfo) throws IOException {
        boolean consumerAdded = false;
        ConsumerInfo info = consumerInfo.copy();
        this.addRemoteBrokerToBrokerPath(info);
        DemandSubscription sub = this.createDemandSubscription(info);
        if (sub != null) {
            if (this.duplicateSuppressionIsRequired(sub)) {
                this.undoMapRegistration(sub);
            } else {
                this.addSubscription(sub);
                consumerAdded = true;
            }
        }
        return consumerAdded;
    }

    private void undoMapRegistration(DemandSubscription sub) {
        this.subscriptionMapByLocalId.remove(sub.getLocalInfo().getConsumerId());
        this.subscriptionMapByRemoteId.remove(sub.getRemoteInfo().getConsumerId());
    }

    private boolean duplicateSuppressionIsRequired(DemandSubscription candidate) {
        ConsumerInfo consumerInfo = candidate.getRemoteInfo();
        boolean suppress = false;
        if (consumerInfo.getDestination().isQueue() && !this.configuration.isSuppressDuplicateQueueSubscriptions() || consumerInfo.getDestination().isTopic() && !this.configuration.isSuppressDuplicateTopicSubscriptions()) {
            return suppress;
        }
        List<ConsumerId> candidateConsumers = consumerInfo.getNetworkConsumerIds();
        Collection<Subscription> currentSubs = this.getRegionSubscriptions(consumerInfo.getDestination());
        for (Subscription sub : currentSubs) {
            List<ConsumerId> networkConsumers = sub.getConsumerInfo().getNetworkConsumerIds();
            if (networkConsumers.isEmpty() || !this.matchFound(candidateConsumers, networkConsumers)) continue;
            if (this.isInActiveDurableSub(sub)) {
                suppress = false;
                break;
            }
            suppress = this.hasLowerPriority(sub, candidate.getLocalInfo());
            break;
        }
        return suppress;
    }

    private boolean isInActiveDurableSub(Subscription sub) {
        return sub.getConsumerInfo().isDurable() && sub instanceof DurableTopicSubscription && !((DurableTopicSubscription)sub).isActive();
    }

    private boolean hasLowerPriority(Subscription existingSub, ConsumerInfo candidateInfo) {
        boolean suppress = false;
        if (existingSub.getConsumerInfo().getPriority() >= candidateInfo.getPriority()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.configuration.getBrokerName() + " Ignoring duplicate subscription from " + this.remoteBrokerName + ", sub: " + candidateInfo + " is duplicated by network subscription with equal or higher network priority: " + existingSub + ", networkConsumerIds: " + existingSub.getConsumerInfo().getNetworkConsumerIds());
            }
            suppress = true;
        } else {
            try {
                this.removeDuplicateSubscription(existingSub);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getBrokerName() + " Replacing duplicate subscription " + existingSub.getConsumerInfo() + " with sub from " + this.remoteBrokerName + ", which has a higher priority, new sub: " + candidateInfo + ", networkComsumerIds: " + candidateInfo.getNetworkConsumerIds());
                }
            }
            catch (IOException e) {
                LOG.error("Failed to remove duplicated sub as a result of sub with higher priority, sub: " + existingSub, (Throwable)e);
            }
        }
        return suppress;
    }

    private void removeDuplicateSubscription(Subscription existingSub) throws IOException {
        for (NetworkConnector connector : this.brokerService.getNetworkConnectors()) {
            if (connector.removeDemandSubscription(existingSub.getConsumerInfo().getConsumerId())) break;
        }
    }

    private boolean matchFound(List<ConsumerId> candidateConsumers, List<ConsumerId> networkConsumers) {
        boolean found = false;
        for (ConsumerId aliasConsumer : networkConsumers) {
            if (!candidateConsumers.contains(aliasConsumer)) continue;
            found = true;
            break;
        }
        return found;
    }

    private final Collection<Subscription> getRegionSubscriptions(ActiveMQDestination dest) {
        RegionBroker region_broker = (RegionBroker)this.brokerService.getRegionBroker();
        Region region = null;
        switch (dest.getDestinationType()) {
            case 1: {
                region = region_broker.getQueueRegion();
                break;
            }
            case 2: {
                region = region_broker.getTopicRegion();
                break;
            }
            case 5: {
                region = region_broker.getTempQueueRegion();
                break;
            }
            case 6: {
                region = region_broker.getTempTopicRegion();
            }
        }
        Collection<Subscription> subs = region instanceof AbstractRegion ? ((AbstractRegion)region).getSubscriptions().values() : null;
        return subs;
    }

    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        info.addNetworkConsumerId(info.getConsumerId());
        return this.doCreateDemandSubscription(info);
    }

    protected DemandSubscription doCreateDemandSubscription(ConsumerInfo info) throws IOException {
        DemandSubscription result = new DemandSubscription(info);
        result.getLocalInfo().setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        if (info.getDestination().isTemporary()) {
            ActiveMQTempDestination dest = (ActiveMQTempDestination)result.getLocalInfo().getDestination();
            dest.setConnectionId(this.localConnectionInfo.getConnectionId().toString());
        }
        if (this.configuration.isDecreaseNetworkConsumerPriority()) {
            byte priority = (byte)this.configuration.getConsumerPriorityBase();
            if (info.getBrokerPath() != null && info.getBrokerPath().length > 1) {
                priority = (byte)(priority - (info.getBrokerPath().length + 1));
            }
            result.getLocalInfo().setPriority(priority);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.configuration.getBrokerName() + " using priority :" + priority + " for subscription: " + info);
            }
        }
        this.configureDemandSubscription(info, result);
        return result;
    }

    protected final DemandSubscription createDemandSubscription(ActiveMQDestination destination) {
        ConsumerInfo info = new ConsumerInfo();
        info.setDestination(destination);
        info.setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        DemandSubscription result = null;
        try {
            result = this.createDemandSubscription(info);
        }
        catch (IOException e) {
            LOG.error("Failed to create DemandSubscription ", (Throwable)e);
        }
        return result;
    }

    protected void configureDemandSubscription(ConsumerInfo info, DemandSubscription sub) throws IOException {
        sub.getLocalInfo().setDispatchAsync(this.configuration.isDispatchAsync());
        sub.getLocalInfo().setPrefetchSize(this.configuration.getPrefetchSize());
        this.subscriptionMapByLocalId.put(sub.getLocalInfo().getConsumerId(), sub);
        this.subscriptionMapByRemoteId.put(sub.getRemoteInfo().getConsumerId(), sub);
        sub.setNetworkBridgeFilter(this.createNetworkBridgeFilter(info));
        if (!info.isDurable()) {
            sub.getLocalInfo().setAdditionalPredicate(sub.getNetworkBridgeFilter());
        }
    }

    protected void removeDemandSubscription(ConsumerId id) throws IOException {
        DemandSubscription sub = this.subscriptionMapByRemoteId.remove(id);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.configuration.getBrokerName() + " remove request on " + this.localBroker + " from " + this.remoteBrokerName + " , consumer id: " + id + ", matching sub: " + sub);
        }
        if (sub != null) {
            this.removeSubscription(sub);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.configuration.getBrokerName() + " removed sub on " + this.localBroker + " from " + this.remoteBrokerName + " :  " + sub.getRemoteInfo());
            }
        }
    }

    protected boolean removeDemandSubscriptionByLocalId(ConsumerId consumerId) {
        boolean removeDone = false;
        DemandSubscription sub = this.subscriptionMapByLocalId.get(consumerId);
        if (sub != null) {
            try {
                this.removeDemandSubscription(sub.getRemoteInfo().getConsumerId());
                removeDone = true;
            }
            catch (IOException e) {
                LOG.debug("removeDemandSubscriptionByLocalId failed for localId: " + consumerId, (Throwable)e);
            }
        }
        return removeDone;
    }

    protected void safeWaitUntilStarted() throws InterruptedException {
        while (!this.disposed.get()) {
            if (!this.startedLatch.await(1L, TimeUnit.SECONDS)) continue;
            return;
        }
    }

    protected NetworkBridgeFilter createNetworkBridgeFilter(ConsumerInfo info) throws IOException {
        PolicyEntry entry;
        NetworkBridgeFilterFactory filterFactory = this.defaultFilterFactory;
        if (this.brokerService != null && this.brokerService.getDestinationPolicy() != null && (entry = this.brokerService.getDestinationPolicy().getEntryFor(info.getDestination())) != null && entry.getNetworkBridgeFilterFactory() != null) {
            filterFactory = entry.getNetworkBridgeFilterFactory();
        }
        return filterFactory.create(info, this.getRemoteBrokerPath(), this.configuration.getNetworkTTL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceLocalBrokerInfo(Command command) throws InterruptedException {
        Object object = this.brokerInfoMutex;
        synchronized (object) {
            if (this.remoteBrokerId != null && this.remoteBrokerId.equals(this.localBrokerId)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this.configuration.getBrokerName() + " disconnecting local loop back connection for: " + this.remoteBrokerName + ", with id:" + this.remoteBrokerId);
                }
                this.safeWaitUntilStarted();
                ServiceSupport.dispose(this);
            }
        }
    }

    protected void addRemoteBrokerToBrokerPath(ConsumerInfo info) throws IOException {
        info.setBrokerPath(this.appendToBrokerPath(info.getBrokerPath(), this.getRemoteBrokerPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceRemoteBrokerInfo(Command command) throws IOException {
        Object object = this.brokerInfoMutex;
        synchronized (object) {
            BrokerInfo remoteBrokerInfo = (BrokerInfo)command;
            this.remoteBrokerPath[0] = this.remoteBrokerId = remoteBrokerInfo.getBrokerId();
            this.remoteBrokerName = remoteBrokerInfo.getBrokerName();
            if (this.localBrokerId != null && this.localBrokerId.equals(this.remoteBrokerId)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this.configuration.getBrokerName() + " disconnecting remote loop back connection for: " + this.remoteBrokerName + ", with id:" + this.remoteBrokerId);
                }
                ServiceSupport.dispose(this);
            }
            if (!this.disposed.get()) {
                this.triggerLocalStartBridge();
            }
        }
    }

    protected BrokerId[] getRemoteBrokerPath() {
        return this.remoteBrokerPath;
    }

    @Override
    public void setNetworkBridgeListener(NetworkBridgeListener listener) {
        this.networkBridgeListener = listener;
    }

    private void fireBridgeFailed() {
        NetworkBridgeListener l = this.networkBridgeListener;
        if (l != null) {
            l.bridgeFailed();
        }
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteBroker.getRemoteAddress();
    }

    @Override
    public String getLocalAddress() {
        return this.localBroker.getRemoteAddress();
    }

    @Override
    public String getRemoteBrokerName() {
        return this.remoteBrokerInfo == null ? null : this.remoteBrokerInfo.getBrokerName();
    }

    @Override
    public String getLocalBrokerName() {
        return this.localBrokerInfo == null ? null : this.localBrokerInfo.getBrokerName();
    }

    @Override
    public long getDequeueCounter() {
        return this.dequeueCounter.get();
    }

    @Override
    public long getEnqueueCounter() {
        return this.enqueueCounter.get();
    }

    protected boolean isDuplex() {
        return this.configuration.isDuplex() || this.createdByDuplex;
    }

    public ConcurrentHashMap<ConsumerId, DemandSubscription> getLocalSubscriptionMap() {
        return this.subscriptionMapByRemoteId;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
        this.localBrokerPath[0] = this.localBrokerId = brokerService.getRegionBroker().getBrokerId();
    }

    @Override
    public void setMbeanObjectName(ObjectName objectName) {
        this.mbeanObjectName = objectName;
    }

    @Override
    public ObjectName getMbeanObjectName() {
        return this.mbeanObjectName;
    }
}

