/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.osgi.service.cm.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="profile-edit", scope="fabric", description="Edits the specified version of the specified profile (where the version defaults to the current default version)", detailedDescription="classpath:profileEdit.txt")
public class ProfileEdit
extends FabricCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileEdit.class);
    static final String FEATURE_PREFIX = "feature.";
    static final String REPOSITORY_PREFIX = "repository.";
    static final String BUNDLE_PREFIX = "bundle.";
    static final String FAB_PREFIX = "fab.";
    static final String OVERRIDE_PREFIX = "fab.";
    static final String CONFIG_PREFIX = "config.";
    static final String SYSTEM_PREFIX = "system.";
    static final String DELIMETER = ",";
    static final String PID_KEY_SEPARATOR = "/";
    @Option(name="-r", aliases={"--repositories"}, description="Edit the features repositories", required=false, multiValued=false)
    private String repositoryUriList;
    @Option(name="-f", aliases={"--features"}, description="Edit features, specifying a comma-separated list of features to add (or delete).", required=false, multiValued=false)
    private String featuresList;
    @Option(name="-b", aliases={"--bundles"}, description="Edit bundles, specifying a comma-separated list of bundles to add (or delete).", required=false, multiValued=false)
    private String bundlesList;
    @Option(name="-f", aliases={"--fabs"}, description="Edit fabs, specifying a comma-separated list of fabs to add (or delete).", required=false, multiValued=false)
    private String fabsList;
    @Option(name="-o", aliases={"--overrides"}, description="Edit overrides, specifying a comma-separated list of overrides to add (or delete).", required=false, multiValued=false)
    private String overridesList;
    @Option(name="-p", aliases={"--pid"}, description="Edit an OSGi configuration property, specified in the format <PID>/<Property>.", required=false, multiValued=true)
    private String[] configAdminProperties;
    @Option(name="-s", aliases={"--system"}, description="Edit the Java system properties that affect installed bundles (analogous to editing etc/system.properties in a root container).", required=false, multiValued=true)
    private String[] systemProperties;
    @Option(name="-c", aliases={"--config"}, description="Edit the Java system properties that affect the karaf container (analogous to editing etc/config.properties in a root container).", required=false, multiValued=true)
    private String[] configProperties;
    @Option(name="-i", aliases={"--import-pid"}, description="Imports the pids that are edited, from local OSGi config admin", required=false, multiValued=false)
    private boolean importPid = false;
    @Option(name="--set", description="Set or create values (selected by default).")
    private boolean set = true;
    @Option(name="--delete", description="Delete values.")
    private boolean delete = false;
    @Option(name="--append", description="Append value. It is only usable with the system, config & pid options")
    private boolean append = false;
    @Option(name="--remove", description="Removes values. It is only usable with the system, config & pid options")
    private boolean remove = false;
    @Option(name="--delimiter", description="Specifies the delimeter to use for appends and removals.")
    private String delimiter = ",";
    @Argument(index=0, name="profile", description="The target profile to edit", required=true, multiValued=false)
    private String profileName;
    @Argument(index=1, name="version", description="The version of the profile to edit. Defaults to the current default version.", required=false, multiValued=false)
    private String versionName = "1.0";

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        if (this.delete) {
            this.set = false;
        }
        Version version = this.versionName != null ? this.fabricService.getVersion(this.versionName) : this.fabricService.getDefaultVersion();
        for (Profile profile : version.getProfiles()) {
            if (!this.profileName.equals(profile.getId())) continue;
            this.editProfile(profile);
        }
        return null;
    }

    private void editProfile(Profile profile) throws Exception {
        String value;
        String key;
        Map<String, String> configMap;
        String pid = AGENT_PID;
        Map config = profile.getConfigurations();
        HashMap<String, String> pidConfig = (HashMap<String, String>)config.get(pid);
        if (pidConfig == null) {
            pidConfig = new HashMap<String, String>();
        }
        if (this.featuresList != null && !this.featuresList.isEmpty()) {
            String[] features;
            for (String feature : features = this.featuresList.split(DELIMETER)) {
                this.updateConfig(pidConfig, FEATURE_PREFIX + feature.replace('/', '_'), feature, this.set, this.delete);
            }
        }
        if (this.repositoryUriList != null && !this.repositoryUriList.isEmpty()) {
            String[] repositoryURIs;
            for (String repopsitoryURI : repositoryURIs = this.repositoryUriList.split(DELIMETER)) {
                this.updateConfig(pidConfig, REPOSITORY_PREFIX + repopsitoryURI.replace('/', '_'), repopsitoryURI, this.set, this.delete);
            }
        }
        if (this.bundlesList != null && !this.bundlesList.isEmpty()) {
            String[] bundles;
            for (String bundlesLocation : bundles = this.bundlesList.split(DELIMETER)) {
                this.updateConfig(pidConfig, BUNDLE_PREFIX + bundlesLocation.replace('/', '_'), bundlesLocation, this.set, this.delete);
            }
        }
        if (this.fabsList != null && !this.fabsList.isEmpty()) {
            String[] fabs;
            for (String fabsLocation : fabs = this.fabsList.split(DELIMETER)) {
                this.updateConfig(pidConfig, "fab." + fabsLocation.replace('/', '_'), fabsLocation, this.set, this.delete);
            }
        }
        if (this.overridesList != null && !this.overridesList.isEmpty()) {
            String[] overrides;
            for (String overridesLocation : overrides = this.overridesList.split(DELIMETER)) {
                this.updateConfig(pidConfig, "fab." + overridesLocation.replace('/', '_'), overridesLocation, this.set, this.delete);
            }
        }
        if (this.configAdminProperties != null && this.configAdminProperties.length > 0) {
            for (String configAdminProperty : this.configAdminProperties) {
                String currentPid = null;
                HashMap<String, String> existingConfig = null;
                if (configAdminProperty == null) continue;
                String keyValue = "";
                if (configAdminProperty.contains(PID_KEY_SEPARATOR)) {
                    currentPid = configAdminProperty.substring(0, configAdminProperty.indexOf(PID_KEY_SEPARATOR));
                    keyValue = configAdminProperty.substring(configAdminProperty.indexOf(PID_KEY_SEPARATOR) + 1);
                } else {
                    currentPid = configAdminProperty;
                }
                existingConfig = (HashMap<String, String>)config.get(currentPid);
                if (existingConfig == null) {
                    existingConfig = new HashMap<String, String>();
                }
                if (this.configAdminProperties.length == 1 && this.importPid) {
                    this.importPidFromLocalConfigAdmin(currentPid, existingConfig);
                }
                Map<String, String> configMap2 = this.extractConfigs(keyValue);
                for (Map.Entry<String, String> configEntries : configMap2.entrySet()) {
                    String key2 = configEntries.getKey();
                    String value2 = configEntries.getValue();
                    this.updatedDelimitedList(existingConfig, key2, value2, this.delimiter, this.set, this.delete, this.append, this.remove);
                }
                config.put(currentPid, existingConfig);
            }
        }
        if (this.systemProperties != null && this.systemProperties.length > 0) {
            for (String systemProperty : this.systemProperties) {
                configMap = this.extractConfigs(systemProperty);
                for (Map.Entry<String, String> configEntries : configMap.entrySet()) {
                    key = configEntries.getKey();
                    value = configEntries.getValue();
                    this.updatedDelimitedList(pidConfig, SYSTEM_PREFIX + key, value, this.delimiter, this.set, this.delete, this.append, this.remove);
                }
            }
        }
        if (this.configProperties != null && this.configProperties.length > 0) {
            for (String configProperty : this.configProperties) {
                configMap = this.extractConfigs(configProperty);
                for (Map.Entry<String, String> configEntries : configMap.entrySet()) {
                    key = configEntries.getKey();
                    value = configEntries.getValue();
                    this.updatedDelimitedList(pidConfig, CONFIG_PREFIX + key, value, this.delimiter, this.set, this.delete, this.append, this.remove);
                }
            }
        }
        config.put(pid, pidConfig);
        profile.setConfigurations(config);
    }

    public void updatedDelimitedList(Map<String, String> map, String key, String value, String delimeter, boolean set, boolean delete, boolean append, boolean remove) {
        if (append || remove) {
            String oldValue = map.containsKey(key) ? map.get(key) : "";
            LinkedList<String> parts = new LinkedList<String>(Arrays.asList(oldValue.split(delimeter)));
            parts.remove("");
            if (append) {
                parts.add(value);
            }
            if (remove) {
                parts.remove(value);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.size(); ++i) {
                if (i != 0) {
                    sb.append(delimeter);
                }
                sb.append((String)parts.get(i));
            }
            map.put(key, sb.toString());
        } else if (set) {
            map.put(key, value);
        } else if (delete) {
            map.remove(key);
        }
    }

    public void updateConfig(Map<String, String> map, String key, String value, boolean set, boolean delete) {
        if (set) {
            map.put(key, value);
        } else if (delete) {
            map.remove(key);
        }
    }

    private void importPidFromLocalConfigAdmin(String pid, Map<String, String> target) {
        try {
            Configuration[] configuration = this.configurationAdmin.listConfigurations("(service.pid=" + pid + ")");
            if (configuration != null && configuration.length > 0) {
                Dictionary dictionary = configuration[0].getProperties();
                Enumeration keyEnumeration = dictionary.keys();
                while (keyEnumeration.hasMoreElements()) {
                    String key = String.valueOf(keyEnumeration.nextElement());
                    String value = String.valueOf(dictionary.get(key));
                    target.put(key, value);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while importing configuration {} to profile.", (Object)pid);
        }
    }

    private Map<String, String> extractConfigs(String configs) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (configs.contains("=")) {
            String key = configs.substring(0, configs.indexOf("="));
            String value = configs.substring(configs.indexOf("=") + 1);
            configMap.put(key, value);
        }
        return configMap;
    }
}

