/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.PrintStream;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.FabricRequirements;
import org.fusesource.fabric.api.ProfileRequirements;
import org.fusesource.fabric.commands.support.RequirementsListSupport;

@Command(name="require-profile-list", scope="fabric", description="Lists the requirements for profiles in the fabric", detailedDescription="classpath:status.txt")
public class RequireProfileList
extends RequirementsListSupport {
    @Override
    protected void printRequirements(PrintStream out, FabricRequirements requirements) {
        out.println(String.format("%-40s %-14s %-14s %s", "[profile]", "[# minimum]", "[# maximum]", "[depends on]"));
        List profileRequirements = requirements.getProfileRequirements();
        for (ProfileRequirements profile : profileRequirements) {
            out.println(String.format("%-40s %-14s %-14s %s", profile.getProfile(), this.getStringOrBlank(profile.getMinimumInstances()), this.getStringOrBlank(profile.getMaximumInstances()), this.getStringOrBlank(profile.getDependentProfiles())));
        }
    }

    protected Object getStringOrBlank(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

