/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.bytebuffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.bytebuffer.ByteBufferAllocator;
import org.apache.lucene.store.bytebuffer.ByteBufferFile;

public class ByteBufferIndexOutput
extends IndexOutput {
    private final ByteBufferAllocator allocator;
    private final ByteBufferAllocator.Type allocatorType;
    private final int BUFFER_SIZE;
    private final ByteBufferFile file;
    private ByteBuffer currentBuffer;
    private int currentBufferIndex;
    private long bufferStart;

    public ByteBufferIndexOutput(ByteBufferAllocator allocator, ByteBufferAllocator.Type allocatorType, ByteBufferFile file) throws IOException {
        this.allocator = allocator;
        this.allocatorType = allocatorType;
        this.BUFFER_SIZE = file.bufferSize;
        this.file = file;
        this.switchCurrentBuffer();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.setFileLength();
        if (pos < this.bufferStart || pos >= this.bufferStart + (long)this.BUFFER_SIZE) {
            this.currentBufferIndex = (int)(pos / (long)this.BUFFER_SIZE);
            this.switchCurrentBuffer();
        }
        this.currentBuffer.position((int)(pos % (long)this.BUFFER_SIZE));
    }

    @Override
    public long length() {
        return this.file.getLength();
    }

    @Override
    public void writeByte(byte b) throws IOException {
        if (!this.currentBuffer.hasRemaining()) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer();
        }
        this.currentBuffer.put(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int remainInBuffer;
            if (!this.currentBuffer.hasRemaining()) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            int bytesToCopy = len < (remainInBuffer = this.currentBuffer.remaining()) ? len : remainInBuffer;
            this.currentBuffer.put(b, offset, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
        }
    }

    private void switchCurrentBuffer() throws IOException {
        if (this.currentBufferIndex == this.file.numBuffers()) {
            this.currentBuffer = this.allocator.allocate(this.allocatorType);
            this.file.addBuffer(this.currentBuffer);
        } else {
            this.currentBuffer = this.file.getBuffer(this.currentBufferIndex);
        }
        this.currentBuffer.position(0);
        this.bufferStart = (long)this.BUFFER_SIZE * (long)this.currentBufferIndex;
    }

    private void setFileLength() {
        long pointer = this.bufferStart + (long)this.currentBuffer.position();
        if (pointer > this.file.getLength()) {
            this.file.setLength(pointer);
        }
    }

    @Override
    public void flush() throws IOException {
        this.file.setLastModified(System.currentTimeMillis());
        this.setFileLength();
    }

    @Override
    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.currentBuffer.position();
    }
}

