/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.base;

import javax.annotation.Nullable;
import org.elasticsearch.common.annotations.Beta;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.base.Equivalence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public final class Equivalences {
    private Equivalences() {
    }

    public static Equivalence<Object> equals() {
        return Impl.EQUALS;
    }

    @Deprecated
    public static Equivalence<Object> nullAwareEquals() {
        return Impl.EQUALS;
    }

    public static Equivalence<Object> identity() {
        return Impl.IDENTITY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Impl implements Equivalence<Object>
    {
        EQUALS{

            public boolean equivalent(@Nullable Object a, @Nullable Object b) {
                return a == null ? b == null : a.equals(b);
            }

            public int hash(@Nullable Object o) {
                return o == null ? 0 : o.hashCode();
            }
        }
        ,
        IDENTITY{

            public boolean equivalent(@Nullable Object a, @Nullable Object b) {
                return a == b;
            }

            public int hash(@Nullable Object o) {
                return System.identityHashCode(o);
            }
        };

    }
}

