/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import java.util.HashMap;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.BlockNode;
import org.elasticsearch.common.mvel2.ast.RedundantCodeException;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.MapVariableResolverFactory;
import org.elasticsearch.common.mvel2.util.CompilerTools;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class ForNode
extends BlockNode {
    protected String item;
    protected ExecutableStatement initializer;
    protected ExecutableStatement condition;
    protected ExecutableStatement after;

    public ForNode(char[] expr, int start, int offset, int blockStart, int blockEnd, int fields, ParserContext pCtx) {
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.blockStart = blockStart;
        this.blockOffset = blockEnd;
        boolean varsEscape = this.buildForEach(expr, this.start, this.offset, this.blockStart, this.blockOffset, fields, pCtx);
        if ((fields & 0x10) != 0 && this.compiledBlock.isEmptyStatement() && !varsEscape) {
            throw new RedundantCodeException();
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        MapVariableResolverFactory ctxFactory = new MapVariableResolverFactory(new HashMap<String, Object>(1), factory);
        this.initializer.getValue(ctx, thisValue, ctxFactory);
        while (((Boolean)this.condition.getValue(ctx, thisValue, ctxFactory)).booleanValue()) {
            this.compiledBlock.getValue(ctx, thisValue, ctxFactory);
            this.after.getValue(ctx, thisValue, ctxFactory);
        }
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        factory = new MapVariableResolverFactory(new HashMap<String, Object>(1), factory);
        this.initializer.getValue(ctx, thisValue, factory);
        while (((Boolean)this.condition.getValue(ctx, thisValue, factory)).booleanValue()) {
            this.compiledBlock.getValue(ctx, thisValue, factory);
            this.after.getValue(ctx, thisValue, factory);
        }
        return null;
    }

    private boolean buildForEach(char[] condition, int start, int offset, int blockStart, int blockEnd, int fields, ParserContext pCtx) {
        int end = start + offset;
        int cursor = ForNode.nextCondPart(condition, start, end, false);
        boolean varsEscape = false;
        try {
            ParserContext spCtx = pCtx;
            spCtx = pCtx != null ? pCtx.createSubcontext().createColoringSubcontext() : new ParserContext();
            this.initializer = (ExecutableStatement)ParseTools.subCompileExpression(condition, start, cursor - start - 1, spCtx);
            try {
                start = cursor;
                cursor = ForNode.nextCondPart(condition, start, end, false);
                this.condition = (ExecutableStatement)ParseTools.subCompileExpression(condition, start, cursor - start - 1, spCtx);
                CompilerTools.expectType(this.condition, Boolean.class, (fields & 0x10) != 0);
            }
            catch (CompileException e) {
                if (e.getExpr().length == 0) {
                    e.setExpr(this.expr);
                    while (start < this.expr.length && ParseTools.isWhitespace(this.expr[start])) {
                        ++start;
                    }
                    e.setCursor(start);
                }
                throw e;
            }
            start = cursor;
            this.after = (ExecutableStatement)ParseTools.subCompileExpression(condition, start, ForNode.nextCondPart(condition, start, end, true) - start, spCtx);
            if (spCtx != null && (fields & 0x10) != 0 && spCtx.isVariablesEscape()) {
                if (pCtx != spCtx) {
                    pCtx.addVariables(spCtx.getVariables());
                }
                varsEscape = true;
            }
            this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, blockStart, blockEnd, spCtx);
        }
        catch (NegativeArraySizeException e) {
            throw new CompileException("wrong syntax; did you mean to use 'foreach'?", this.expr, start);
        }
        return varsEscape;
    }

    private static int nextCondPart(char[] condition, int cursor, int end, boolean allowEnd) {
        while (cursor < end) {
            if (condition[cursor] == ';') {
                return ++cursor;
            }
            ++cursor;
        }
        if (!allowEnd) {
            throw new CompileException("expected ;", condition, cursor);
        }
        return cursor;
    }
}

