/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.yaml.snakeyaml.constructor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.yaml.snakeyaml.constructor.AbstractConstruct;
import org.elasticsearch.common.yaml.snakeyaml.constructor.BaseConstructor;
import org.elasticsearch.common.yaml.snakeyaml.constructor.Construct;
import org.elasticsearch.common.yaml.snakeyaml.constructor.ConstructorException;
import org.elasticsearch.common.yaml.snakeyaml.error.YAMLException;
import org.elasticsearch.common.yaml.snakeyaml.nodes.MappingNode;
import org.elasticsearch.common.yaml.snakeyaml.nodes.Node;
import org.elasticsearch.common.yaml.snakeyaml.nodes.NodeId;
import org.elasticsearch.common.yaml.snakeyaml.nodes.NodeTuple;
import org.elasticsearch.common.yaml.snakeyaml.nodes.ScalarNode;
import org.elasticsearch.common.yaml.snakeyaml.nodes.SequenceNode;
import org.elasticsearch.common.yaml.snakeyaml.nodes.Tag;
import org.elasticsearch.common.yaml.snakeyaml.util.Base64Coder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeConstructor
extends BaseConstructor {
    public static ConstructUndefined undefinedConstructor = new ConstructUndefined();
    private static final Map<String, Boolean> BOOL_VALUES = new HashMap<String, Boolean>();
    private static final Pattern TIMESTAMP_REGEXP;
    private static final Pattern YMD_REGEXP;

    public SafeConstructor() {
        this.yamlConstructors.put(Tag.NULL, new ConstructYamlNull());
        this.yamlConstructors.put(Tag.BOOL, new ConstructYamlBool());
        this.yamlConstructors.put(Tag.INT, new ConstructYamlInt());
        this.yamlConstructors.put(Tag.FLOAT, new ConstructYamlFloat());
        this.yamlConstructors.put(Tag.BINARY, new ConstructYamlBinary());
        this.yamlConstructors.put(Tag.TIMESTAMP, new ConstructYamlTimestamp());
        this.yamlConstructors.put(Tag.OMAP, new ConstructYamlOmap());
        this.yamlConstructors.put(Tag.PAIRS, new ConstructYamlPairs());
        this.yamlConstructors.put(Tag.SET, new ConstructYamlSet());
        this.yamlConstructors.put(Tag.STR, new ConstructYamlStr());
        this.yamlConstructors.put(Tag.SEQ, new ConstructYamlSeq());
        this.yamlConstructors.put(Tag.MAP, new ConstructYamlMap());
        this.yamlConstructors.put(null, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.scalar, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.sequence, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.mapping, undefinedConstructor);
    }

    private void flattenMapping(MappingNode node) {
        ArrayList<NodeTuple> merge = new ArrayList<NodeTuple>();
        int index = 0;
        List<NodeTuple> nodeValue = node.getValue();
        block4: while (index < nodeValue.size()) {
            Node keyNode = nodeValue.get(index).getKeyNode();
            Node valueNode = nodeValue.get(index).getValueNode();
            if (keyNode.getTag().equals(Tag.MERGE)) {
                nodeValue.remove(index);
                switch (valueNode.getNodeId()) {
                    case mapping: {
                        MappingNode mn = (MappingNode)valueNode;
                        this.flattenMapping(mn);
                        merge.addAll(mn.getValue());
                        break;
                    }
                    case sequence: {
                        ArrayList<List<NodeTuple>> submerge = new ArrayList<List<NodeTuple>>();
                        SequenceNode sn = (SequenceNode)valueNode;
                        List<Node> vals = sn.getValue();
                        for (Node node2 : vals) {
                            if (!(node2 instanceof MappingNode)) {
                                throw new ConstructorException("while constructing a mapping", node.getStartMark(), "expected a mapping for merging, but found " + (Object)((Object)node2.getNodeId()), node2.getStartMark());
                            }
                            MappingNode mnode = (MappingNode)node2;
                            this.flattenMapping(mnode);
                            submerge.add(mnode.getValue());
                        }
                        Collections.reverse(submerge);
                        for (List list : submerge) {
                            merge.addAll(list);
                        }
                        continue block4;
                    }
                    default: {
                        throw new ConstructorException("while constructing a mapping", node.getStartMark(), "expected a mapping or list of mappings for merging, but found " + (Object)((Object)valueNode.getNodeId()), valueNode.getStartMark());
                    }
                }
                continue;
            }
            if (keyNode.getTag().equals(Tag.VALUE)) {
                keyNode.setTag(Tag.STR);
                ++index;
                continue;
            }
            ++index;
        }
        if (!merge.isEmpty()) {
            merge.addAll(nodeValue);
            node.setValue(merge);
        }
    }

    @Override
    protected void constructMapping2ndStep(MappingNode node, Map<Object, Object> mapping) {
        this.flattenMapping(node);
        super.constructMapping2ndStep(node, mapping);
    }

    @Override
    protected void constructSet2ndStep(MappingNode node, Set<Object> set) {
        this.flattenMapping(node);
        super.constructSet2ndStep(node, set);
    }

    private Number createNumber(int sign, String number, int radix) {
        Number result;
        if (sign < 0) {
            number = "-" + number;
        }
        try {
            result = Integer.valueOf(number, radix);
        }
        catch (NumberFormatException e) {
            try {
                result = Long.valueOf(number, radix);
            }
            catch (NumberFormatException e1) {
                result = new BigInteger(number, radix);
            }
        }
        return result;
    }

    static {
        BOOL_VALUES.put("yes", Boolean.TRUE);
        BOOL_VALUES.put("no", Boolean.FALSE);
        BOOL_VALUES.put("true", Boolean.TRUE);
        BOOL_VALUES.put("false", Boolean.FALSE);
        BOOL_VALUES.put("on", Boolean.TRUE);
        BOOL_VALUES.put("off", Boolean.FALSE);
        TIMESTAMP_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \t]*(?:Z|([-+][0-9][0-9]?)(?::([0-9][0-9])?)?))?)?$");
        YMD_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)$");
    }

    private static final class ConstructUndefined
    extends AbstractConstruct {
        private ConstructUndefined() {
        }

        public Object construct(Node node) {
            throw new ConstructorException(null, null, "could not determine a constructor for the tag " + node.getTag(), node.getStartMark());
        }
    }

    private class ConstructYamlMap
    implements Construct {
        private ConstructYamlMap() {
        }

        public Object construct(Node node) {
            if (node.isTwoStepsConstruction()) {
                return SafeConstructor.this.createDefaultMap();
            }
            return SafeConstructor.this.constructMapping((MappingNode)node);
        }

        public void construct2ndStep(Node node, Object object) {
            if (!node.isTwoStepsConstruction()) {
                throw new YAMLException("Unexpected recursive mapping structure. Node: " + node);
            }
            SafeConstructor.this.constructMapping2ndStep((MappingNode)node, (Map)object);
        }
    }

    private class ConstructYamlSeq
    implements Construct {
        private ConstructYamlSeq() {
        }

        public Object construct(Node node) {
            SequenceNode seqNode = (SequenceNode)node;
            if (node.isTwoStepsConstruction()) {
                return SafeConstructor.this.createDefaultList(seqNode.getValue().size());
            }
            return SafeConstructor.this.constructSequence(seqNode);
        }

        public void construct2ndStep(Node node, Object data) {
            if (!node.isTwoStepsConstruction()) {
                throw new YAMLException("Unexpected recursive sequence structure. Node: " + node);
            }
            SafeConstructor.this.constructSequenceStep2((SequenceNode)node, (List)data);
        }
    }

    private class ConstructYamlStr
    extends AbstractConstruct {
        private ConstructYamlStr() {
        }

        public Object construct(Node node) {
            return (String)SafeConstructor.this.constructScalar((ScalarNode)node);
        }
    }

    private class ConstructYamlSet
    implements Construct {
        private ConstructYamlSet() {
        }

        public Object construct(Node node) {
            if (node.isTwoStepsConstruction()) {
                return SafeConstructor.this.createDefaultSet();
            }
            return SafeConstructor.this.constructSet((MappingNode)node);
        }

        public void construct2ndStep(Node node, Object object) {
            if (!node.isTwoStepsConstruction()) {
                throw new YAMLException("Unexpected recursive set structure. Node: " + node);
            }
            SafeConstructor.this.constructSet2ndStep((MappingNode)node, (Set)object);
        }
    }

    private class ConstructYamlPairs
    extends AbstractConstruct {
        private ConstructYamlPairs() {
        }

        public Object construct(Node node) {
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing pairs", node.getStartMark(), "expected a sequence, but found " + (Object)((Object)node.getNodeId()), node.getStartMark());
            }
            SequenceNode snode = (SequenceNode)node;
            ArrayList<Object[]> pairs = new ArrayList<Object[]>(snode.getValue().size());
            for (Node subnode : snode.getValue()) {
                if (!(subnode instanceof MappingNode)) {
                    throw new ConstructorException("while constructingpairs", node.getStartMark(), "expected a mapping of length 1, but found " + (Object)((Object)subnode.getNodeId()), subnode.getStartMark());
                }
                MappingNode mnode = (MappingNode)subnode;
                if (mnode.getValue().size() != 1) {
                    throw new ConstructorException("while constructing pairs", node.getStartMark(), "expected a single mapping item, but found " + mnode.getValue().size() + " items", mnode.getStartMark());
                }
                Node keyNode = mnode.getValue().get(0).getKeyNode();
                Node valueNode = mnode.getValue().get(0).getValueNode();
                Object key = SafeConstructor.this.constructObject(keyNode);
                Object value = SafeConstructor.this.constructObject(valueNode);
                pairs.add(new Object[]{key, value});
            }
            return pairs;
        }
    }

    private class ConstructYamlOmap
    extends AbstractConstruct {
        private ConstructYamlOmap() {
        }

        public Object construct(Node node) {
            LinkedHashMap<Object, Object> omap = new LinkedHashMap<Object, Object>();
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a sequence, but found " + (Object)((Object)node.getNodeId()), node.getStartMark());
            }
            SequenceNode snode = (SequenceNode)node;
            for (Node subnode : snode.getValue()) {
                if (!(subnode instanceof MappingNode)) {
                    throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a mapping of length 1, but found " + (Object)((Object)subnode.getNodeId()), subnode.getStartMark());
                }
                MappingNode mnode = (MappingNode)subnode;
                if (mnode.getValue().size() != 1) {
                    throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a single mapping item, but found " + mnode.getValue().size() + " items", mnode.getStartMark());
                }
                Node keyNode = mnode.getValue().get(0).getKeyNode();
                Node valueNode = mnode.getValue().get(0).getValueNode();
                Object key = SafeConstructor.this.constructObject(keyNode);
                Object value = SafeConstructor.this.constructObject(valueNode);
                omap.put(key, value);
            }
            return omap;
        }
    }

    protected class ConstructYamlTimestamp
    extends AbstractConstruct {
        private Calendar calendar;

        protected ConstructYamlTimestamp() {
        }

        public Calendar getCalendar() {
            return this.calendar;
        }

        public Object construct(Node node) {
            TimeZone timeZone;
            ScalarNode scalar = (ScalarNode)node;
            String nodeValue = scalar.getValue();
            Matcher match = YMD_REGEXP.matcher(nodeValue);
            if (match.matches()) {
                String year_s = match.group(1);
                String month_s = match.group(2);
                String day_s = match.group(3);
                this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                this.calendar.clear();
                this.calendar.set(1, Integer.parseInt(year_s));
                this.calendar.set(2, Integer.parseInt(month_s) - 1);
                this.calendar.set(5, Integer.parseInt(day_s));
                return this.calendar.getTime();
            }
            match = TIMESTAMP_REGEXP.matcher(nodeValue);
            if (!match.matches()) {
                throw new YAMLException("Unexpected timestamp: " + nodeValue);
            }
            String year_s = match.group(1);
            String month_s = match.group(2);
            String day_s = match.group(3);
            String hour_s = match.group(4);
            String min_s = match.group(5);
            String sec_s = match.group(6);
            String fract_s = match.group(7);
            String timezoneh_s = match.group(8);
            String timezonem_s = match.group(9);
            int usec = 0;
            if (fract_s != null && (usec = Integer.parseInt(fract_s)) != 0) {
                while (10 * usec < 1000) {
                    usec *= 10;
                }
            }
            if (timezoneh_s != null) {
                String time = timezonem_s != null ? ":" + timezonem_s : "00";
                timeZone = TimeZone.getTimeZone("GMT" + timezoneh_s + time);
            } else {
                timeZone = TimeZone.getTimeZone("UTC");
            }
            this.calendar = Calendar.getInstance(timeZone);
            this.calendar.set(1, Integer.parseInt(year_s));
            this.calendar.set(2, Integer.parseInt(month_s) - 1);
            this.calendar.set(5, Integer.parseInt(day_s));
            this.calendar.set(11, Integer.parseInt(hour_s));
            this.calendar.set(12, Integer.parseInt(min_s));
            this.calendar.set(13, Integer.parseInt(sec_s));
            this.calendar.set(14, usec);
            return this.calendar.getTime();
        }
    }

    private class ConstructYamlBinary
    extends AbstractConstruct {
        private ConstructYamlBinary() {
        }

        public Object construct(Node node) {
            byte[] decoded = Base64Coder.decode(SafeConstructor.this.constructScalar((ScalarNode)node).toString().toCharArray());
            return decoded;
        }
    }

    private class ConstructYamlFloat
    extends AbstractConstruct {
        private ConstructYamlFloat() {
        }

        public Object construct(Node node) {
            String value = SafeConstructor.this.constructScalar((ScalarNode)node).toString().replaceAll("_", "");
            int sign = 1;
            char first = value.charAt(0);
            if (first == '-') {
                sign = -1;
                value = value.substring(1);
            } else if (first == '+') {
                value = value.substring(1);
            }
            String valLower = value.toLowerCase();
            if (".inf".equals(valLower)) {
                return new Double(sign == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            if (".nan".equals(valLower)) {
                return new Double(Double.NaN);
            }
            if (value.indexOf(58) != -1) {
                String[] digits = value.split(":");
                int bes = 1;
                double val = 0.0;
                int j = digits.length;
                for (int i = 0; i < j; ++i) {
                    val += Double.parseDouble(digits[j - i - 1]) * (double)bes;
                    bes *= 60;
                }
                return new Double((double)sign * val);
            }
            Double d = Double.valueOf(value);
            return new Double(d * (double)sign);
        }
    }

    private class ConstructYamlInt
    extends AbstractConstruct {
        private ConstructYamlInt() {
        }

        public Object construct(Node node) {
            String value = SafeConstructor.this.constructScalar((ScalarNode)node).toString().replaceAll("_", "");
            int sign = 1;
            char first = value.charAt(0);
            if (first == '-') {
                sign = -1;
                value = value.substring(1);
            } else if (first == '+') {
                value = value.substring(1);
            }
            int base = 10;
            if ("0".equals(value)) {
                return new Integer(0);
            }
            if (value.startsWith("0b")) {
                value = value.substring(2);
                base = 2;
            } else if (value.startsWith("0x")) {
                value = value.substring(2);
                base = 16;
            } else if (value.startsWith("0")) {
                value = value.substring(1);
                base = 8;
            } else {
                if (value.indexOf(58) != -1) {
                    String[] digits = value.split(":");
                    int bes = 1;
                    int val = 0;
                    int j = digits.length;
                    for (int i = 0; i < j; ++i) {
                        val = (int)((long)val + Long.parseLong(digits[j - i - 1]) * (long)bes);
                        bes *= 60;
                    }
                    return SafeConstructor.this.createNumber(sign, String.valueOf(val), 10);
                }
                return SafeConstructor.this.createNumber(sign, value, 10);
            }
            return SafeConstructor.this.createNumber(sign, value, base);
        }
    }

    private class ConstructYamlBool
    extends AbstractConstruct {
        private ConstructYamlBool() {
        }

        public Object construct(Node node) {
            String val = (String)SafeConstructor.this.constructScalar((ScalarNode)node);
            return BOOL_VALUES.get(val.toLowerCase());
        }
    }

    private class ConstructYamlNull
    extends AbstractConstruct {
        private ConstructYamlNull() {
        }

        public Object construct(Node node) {
            SafeConstructor.this.constructScalar((ScalarNode)node);
            return null;
        }
    }
}

