/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class CjkAnalyzerProvider
extends AbstractIndexAnalyzerProvider<CJKAnalyzer> {
    private final CJKAnalyzer analyzer;

    @Inject
    public CjkAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        Set<?> stopWords = Analysis.parseStopWords(settings, CJKAnalyzer.getDefaultStopSet());
        this.analyzer = new CJKAnalyzer(this.version, stopWords);
    }

    @Override
    public CJKAnalyzer get() {
        return this.analyzer;
    }
}

