/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class DutchAnalyzerProvider
extends AbstractIndexAnalyzerProvider<DutchAnalyzer> {
    private final Set<?> stemExclusion;
    private final DutchAnalyzer analyzer;

    @Inject
    public DutchAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        Set<?> stopWords = Analysis.parseStopWords(settings, DutchAnalyzer.getDefaultStopSet());
        String[] stemExclusion = settings.getAsArray("stem_exclusion");
        this.stemExclusion = stemExclusion.length > 0 ? ImmutableSet.copyOf(Iterators.forArray(stemExclusion)) : ImmutableSet.of();
        this.analyzer = new DutchAnalyzer(this.version, stopWords, this.stemExclusion);
    }

    @Override
    public DutchAnalyzer get() {
        return this.analyzer;
    }
}

